<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
	
	<uix:document>
	  <%@ include file="/oemTitle.jspf"%>   
		  <uix:contents>

				<uix:form name="addObjects1" method="post">
				<uix:formValue name="pageName" value="/database/dist/advRepl/template/addObjects1"/>
				<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

				  <uix:contents>
                    <uix:pageLayout styleClass="OraInstructionText" titleBinding="MVG_TR_AO@ARSetupMsgs">
						<%@ include file="/oemGlobal.jspf"%>
                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

					  <uix:contents>

							 <uix:tableLayout cellSpacing="5"> 
    <%-- Object selection options --%>
    <uix:rowLayout>
      <uix:contents>
        <uix:cellFormat hAlign="right">
          <uix:contents>
            <uix:styledText textBinding="OBJECT_SELECTION_METHOD@MasterGrpMsgs" styleClass="OraInstructionText"/>
          </uix:contents>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
          <uix:contents>
            <oem:choice name="selectionOptions" optionsBinding="selectionOptions@addObjBean@servletRequest" selectedValueBinding="optionSelected@addObjBean@servletRequest" onChange="submitForm('addObjects1', true, {event:'optionChanged'})"/>  
          </uix:contents>
        </uix:cellFormat>
      </uix:contents>
    </uix:rowLayout>
    <%-- Object Types Row --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:styledText textBinding="OBJECT_TYPES@MasterGrpMsgs" styleClass="OraInstructionText"/>
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="left">
              <uix:contents>
                <uix:tableLayout cellSpacing="5">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:messageCheckBox name="table" textBinding="TABLES@MasterGrpMsgs" checkedBinding="table@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="view" textBinding="VIEWS@MasterGrpMsgs" checkedBinding="view@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="index" textBinding="INDEXES@MasterGrpMsgs" checkedBinding="index@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="trigger" textBinding="TRIGGERS@MasterGrpMsgs" checkedBinding="trigger@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="synonym" textBinding="SYNONYMS@MasterGrpMsgs" checkedBinding="synonym@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:messageCheckBox name="function" textBinding="FUNCTIONS@MasterGrpMsgs" checkedBinding="function@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="package1" textBinding="PACKAGES@MasterGrpMsgs" checkedBinding="package1@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="packagebody" textBinding="PACKAGE_BODY@MasterGrpMsgs" checkedBinding="packagebody@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="procedure" textBinding="PROCEDURES@MasterGrpMsgs" checkedBinding="procedure@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:contents>
                            <uix:messageCheckBox name="sequence" textBinding="SEQUENCE@MasterGrpMsgs"checkedBinding="sequence@addObjBean@servletRequest"/>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
              </uix:contents>
            </uix:cellFormat>
          </uix:contents>
        </uix:rowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Select Schema Row --%>
    <uix:rowLayout renderedBinding="option2@addObjBean@servletRequest">
      <uix:contents>
        <uix:cellFormat hAlign="right">
          <uix:contents>
            <uix:styledText textBinding="SCHEMA@MasterGrpMsgs" styleClass="OraInstructionText"/>
          </uix:contents>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
          <uix:contents>
            <uix:messageLovField name="singleSchema" id="singleSchema" textBinding="singleSchema@addObjBean@servletRequest" shortDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle@servletRequest" onClick="startLov('singleSchema', 'ListSchema')"/>
          </uix:contents>
        </uix:cellFormat>
      </uix:contents>
    </uix:rowLayout>

    <%-- Go Button Row--%>
    <uix:rowLayout renderedBinding="option2@addObjBean@servletRequest">
      <uix:contents>
        <uix:cellFormat hAlign="right"/>
        <uix:cellFormat hAlign="left">
          <uix:contents>
            <uix:submitButton name="event" value="searchObjFromSchema" textBinding="GO@MasterGrpMsgs"/>
          </uix:contents>
        </uix:cellFormat>
      </uix:contents>
    </uix:rowLayout>
  </uix:tableLayout>
	
 <%-- Schemast/Objects List --%>
  <uix:header textBinding="schemaOrSelObjs@servletRequest">
    <uix:contents>
      <uix:dataScope currentDataBinding="selectedObjList@servletRequest">
        <uix:table name="selectedObjList" formSubmitted="true" alternateTextBinding="NO_DATA_FOUND@ARSetupMsgs" width="100%" valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>" maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>" tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>" blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" summaryBinding="messageAlterText">
          <uix:contents>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="SCHEMA@MasterGrpMsgs"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:styledText textBinding="sname"/>
              </uix:contents>
            </uix:column>
            <uix:column renderedBinding="option2@addObjBean@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="OBJECT@ARSetupMsgs"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:styledText textBinding="oname"/>
              </uix:contents>
            </uix:column>
            <uix:column renderedBinding="option2@addObjBean@servletRequest">
              <uix:columnHeader>
                <uix:styledText textBinding="TYPE@MasterGrpMsgs"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:styledText textBinding="otype"/>
              </uix:contents>
            </uix:column>
          </uix:contents>
          <uix:tableSelection>
            <uix:multipleSelection textBinding="TABLE_SELECTION@MasterGrpMsgs" selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>"/>
          </uix:tableSelection>
          <uix:tableActions/>
        </uix:table>
      </uix:dataScope>
    </uix:contents>
  </uix:header>
                       
                      </uix:contents>
                                           
                      
                     <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                           <uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel"/>
                            <uix:submitButton textBinding="OK@ARSetupMsgs" name="event" value="OK_addObjects1"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                     
					  <uix:pageStatus/>
						<uix:location>
                           <uix:train value="1">
                              <uix:contents>
								<uix:link textBinding="GEN@MasterGrpMsgs"/>
								<uix:link textBinding="SUBSETTING@ARSetupMsgs" disabled="true"/>
								<uix:link textBinding="TEMP_PARAMS@ARSetupMsgs" disabled="true"/>
								<uix:link textBinding="SCHED_EM_JOB@ARSetupMsgs"  disabled="true"/>
								<uix:link textBinding="REVIEW@ARSetupMsgs"  disabled="true"/>
                            </uix:contents>
                            </uix:train>
                      </uix:location>

					</uix:pageLayout>
                  
				  </uix:contents>
                </uix:form>
              </uix:contents>

		</uix:document>

</uix:renderingContext>