<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.advRepl.ARSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="ARSetupMsgs" class="oracle.sysman.db.rsc.advRepl.ARSetupMsg"/>
  <uix:bundle name="MasterGrpMsgs" class="oracle.sysman.db.rsc.advRepl.MasterGroupMsg"/>	

	<uix:document>
	 <%@ include file="/oemTitle.jspf"%>   
		  <uix:contents>
			<uix:body>   
                <db:form name="general" method="post" destination="/console/database/dist/advRepl/createTemplate" copyParams="target,type,fromTempAdmin">
				<uix:formValue name="pageName" value="/database/dist/advRepl/template/general"/>
				<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

				  <uix:contents>
                    <uix:pageLayout styleClass="OraInstructionText" titleBinding="header@servletRequest">
						<%@ include file="/oemGlobal.jspf"%>
                       
						<oem:messageBox messageType = "error" msgBundleBinding="defaultMsgBundleName@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

					  <uix:contents>

                        <uix:tableLayout cellSpacing="5">
						  <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
										<uix:messagePrompt promptBinding="NAME@ARSetupMsgs" required="yes"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                  <uix:contents>
                                    <uix:messageTextInput name="schemaName" textBinding="schemaName@defaultBean@servletRequest"
									shortDescBinding="NAME@ARSetupMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
										<uix:messagePrompt promptBinding="SCHEMA@MasterGrpMsgs" required="yes"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                  <uix:contents>
                                   	<uix:messageLovField name="schema" id="schema" 
									textBinding="schema@defaultBean@servletRequest" shortDescBinding="SCHEMA@MasterGrpMsgs" onClick = "startLov('schema', 'ListSchema')"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="DESC@MasterGrpMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" vAlign="top">
                                  <uix:contents>
                                    <uix:messageTextInput name="schemaDesc" rows="3" columns="80" textBinding="schemaDesc@defaultBean@servletRequest"
									shortDescBinding="DESC@MasterGrpMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>

                        <uix:header textBinding="MVG_TR_AO@ARSetupMsgs">
                          <uix:contents>
                            <uix:formattedText styleClass="OraInstructionText" textBinding="ADD_OBJS_INST@ARSetupMsgs"/>
                            <uix:rowLayout width="100%">
								<uix:cellFormat hAlign="right">
									<uix:submitButton textBinding="ADD@MasterGrpMsgs" name="event" value="addObject" shortDescBinding="ADD@MasterGrpMsgs"/>
									<uix:spacer height="5" width="5"/>
    								<uix:submitButton textBinding="NEW@ARSetupMsgs" name="event" value="addNewObject" shortDescBinding="NEW@ARSetupMsgs"/>
								</uix:cellFormat>
							</uix:rowLayout>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat>
								
                               <uix:dataScope currentDataBinding="objectList@servletRequest">
								<uix:tableLayout hAlign="center" width="80%">
                                  <uix:contents>

									<uix:table name="objectList" 
                           formSubmitted="true"
                           width="100%"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="TAB_OF_OBJ@ARSetupMsgs"
						   shortDescBinding="TAB_OF_OBJ@ARSetupMsgs">                                     

                                      <uix:contents>
                                      
										<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="SCHEMA@MasterGrpMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="schema" textBinding="schema" columns="20" readOnly="true"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="OBJECT@MasterGrpMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="name" textBinding="name" columns="20" readOnly="true"/>
                              </uix:contents>
                            </uix:column>							

							<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="TYPE@MasterGrpMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageTextInput name="type" textBinding="type" columns="20" readOnly="true"/>
                              </uix:contents>
                            </uix:column>

							<uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="ADD_AS@ARSetupMsgs"/>
                              </uix:columnHeader>
                              <uix:contents>
                                <%--<uix:messageTextInput name="type" textBinding="type" columns="20" readOnly="true"/>--%>
								<oem:choice  name="addTableAs" optionsBinding="addOptions"
                                         selectedValueBinding="addTableAs"
										 renderedBinding="isTableType"/>
								
                              </uix:contents>
                            </uix:column>

									  </uix:contents>
                                     
									  <uix:tableActions>
                                        <uix:flowLayout>
                                          <uix:contents>
                                            <uix:submitButton renderedBinding="isObjectAvailable" textBinding="REMOVE@MasterGrpMsgs" name="event" value="remove" shortDescBinding="REMOVE@MasterGrpMsgs"/>
                                          </uix:contents>
                                        </uix:flowLayout>
                                      </uix:tableActions>

									  <uix:tableSelection>
		                            <uix:multipleSelection textBinding="TABLE_SELECTION@ARSetupMsgs" selectedBinding="select" />
				                  </uix:tableSelection>
						          <uix:tableActions/>


                                    </uix:table>
                                  </uix:contents>
                                </uix:tableLayout>
                                </uix:dataScope>
							  </uix:cellFormat>
							  </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:header>

						
                      </uix:contents>
					 
				      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<uix:submitButton textBinding="CANCEL@ARSetupMsgs" name="event" value="cancel" shortDescBinding="CANCEL@ARSetupMsgs"/>
							<uix:navigationBar maxValue="5" formSubmitted="true" name="setupTemplateNavBar"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
					  <uix:location>
                            <uix:train value="1">
                              <uix:contents>
							    
								<uix:link textBinding="MVG_TR_GEN@ARSetupMsgs"/>
                                <uix:link textBinding="SUBSETTING@ARSetupMsgs"/>
                                <uix:link textBinding="TEMP_PARAMS@ARSetupMsgs"/>
                                <uix:link textBinding="SCHED_EM_JOB@ARSetupMsgs"/>
                                <uix:link textBinding="REVIEW@ARSetupMsgs"/>

                            </uix:contents>
                            </uix:train>
                      </uix:location>


					  <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="addMasterSitePageStatusText@servletRequest"/>
                      </uix:pageStatus>
                    
					</uix:pageLayout>
                  
				  </uix:contents>
                </db:form>
			  </uix:body>   
              </uix:contents>

		</uix:document>

</uix:renderingContext>


