<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>

<%
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("streamsMsgs", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
%>

<%---------------------------------------------------------------------------------------------------------------%>

        <uix:rawText>
              <a name="TXNLIST" />
        </uix:rawText>

        <uix:spacer  height="10" />

        <uix:header textBinding="ACTIVE_TXN_LIST@streamsMsgs@servletRequest" >

	<uix:spacer  height="5" />
	<uix:switcher childNameBinding="allowTxnDetails@servletRequest">
            <uix:case name="true">
                 <uix:messageStyledText styleClass="OraInstructionText" textBinding="ACTIVE_TXN_LIST_INFO@streamsMsgs"/>
	    </uix:case>
            <uix:case name="false">
                 <uix:messageStyledText styleClass="OraInstructionText" textBinding="ACTIVE_TXN_LIST_INFO_DBCONSOLE@streamsMsgs"/>
	    </uix:case>
	</uix:switcher>

        <uix:spacer  height="5" />
        <uix:rowLayout>

        <uix:dataScope currentDataBinding="activeTxnList@defaultBean@servletRequest">
            <uix:table name="activeTxnList" 
                                alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
                                formSubmitted="true" width="100%"
                                tableDataBinding="rowData" valueBinding="startIndex"
                                maxValueBinding="numRows"  minValue="1"
                                blockSizeBinding="blockSize" partialRenderMode="true"
                                summaryBinding="ACTIVE_TXN_LIST_INFO@streamsMsgs@servletRequest"
                                shortDescBinding="ACTIVE_TXN_LIST_INFO@streamsMsgs@servletRequest" >

 <uix:column>                                         <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TXN_ID@applyBundle@servletRequest" sortable="true"/>
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
                                        <uix:text textBinding="txnID" />
                                </uix:column>
                                <uix:column renderedBinding="showSid@activeTxnList@defaultBean@servletRequest">
                                   <uix:columnHeader>   
					<uix:sortableHeader textBinding="SESSION_ID@applyBundle@servletRequest" 
			     renderedBinding="showSid@activeTxnList@defaultBean@servletRequest" sortable="true"/>
                                   </uix:columnHeader> 
				   <uix:columnFormat columnDataFormat="numberFormat" width="5%"/>         
				   <uix:styledText textBinding="sessionId" destinationBinding="sessionIdUrl" renderedBinding="showSid@activeTxnList@defaultBean@servletRequest" />
                                </uix:column>                                 
                                <uix:column>
                                   <uix:columnHeader>   <uix:sortableHeader textBinding="TOTAL_MSG_COUNT@streamsMsgs@servletRequest" sortable="true"/>
                                   </uix:columnHeader> 
				   <uix:columnFormat columnDataFormat="numberFormat" width="5%"/>         
				   <uix:text textBinding="totalMsgCnt" />
                                </uix:column>                                 
				<uix:column>                                   
				   <uix:columnHeader>
                                      <uix:sortableHeader textBinding="CUMULATIVE_MSG_COUNT@streamsMsgs@servletRequest" sortable="true"/>
                                   </uix:columnHeader>
                                   <uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
                                   <uix:text textBinding="cumMsgCnt" />
                                </uix:column>
				 <uix:column>
                                        <uix:columnHeader>                                         <uix:sortableHeader textBinding="FIRST_SCN@applyBundle@servletRequest" sortable="true"/>                                         </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
                                        <uix:text textBinding="firstSCN" /> 
			 	</uix:column>
                                <uix:column>
                                        <uix:columnHeader>          <uix:sortableHeader textBinding="LAST_SCN@streamsMsgs@servletRequest" sortable="true"/>
                                        </uix:columnHeader>           <uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
                                        <uix:text textBinding="lastSCN" />
                                </uix:column>
                                <uix:column>
                                        <uix:columnHeader>          <uix:sortableHeader textBinding="FIRST_MSG_TIME@streamsMsgs@servletRequest" sortable="true"/>
                                        </uix:columnHeader>           <uix:columnFormat columnDataFormat="numberFormat" width="30%"/>
                                        <uix:text textBinding="firstMsgTime" />
                                </uix:column>
				<uix:column>
                                        <uix:columnHeader>                                         <uix:sortableHeader textBinding="LAST_MSG_TIME@streamsMsgs@servletRequest" sortable="true"/>                                         </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="30%"/>                                         <uix:text textBinding="lastMsgTime" />
                                </uix:column>                                 

				<uix:tableSelection >
                                        <uix:singleSelection shortDescBinding="SELECT@dbBundle@servletRequest" renderedBinding="allowTxnDetails@servletRequest">
                                         <uix:submitButton textBinding="VIEW_TXN_DETAIL@streamsMsgs@servletRequest" shortDescBinding="VIEW_TXN_DETAIL@streamsMsgs@servletRequest"  renderedBinding="allowTxnDetails@servletRequest" name="event" value="viewTxnDetails"/>
                                        </uix:singleSelection> 
                                </uix:tableSelection>

                        </uix:table>
        </uix:dataScope >

            </uix:rowLayout>

</uix:header>

<%---------------------------------------------------------------------------------------------------------------%>


