<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsgID" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

		<uix:body>
            <db:form name="adminForm" method="post" destination="/console/database/dist/streams/administration" copyParams="target,type">
            <uix:formValue name="pageName" value="/database/dist/streams/admin/configParamsAdmin"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>

            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            

                      <!-- Main contents begin -->

                  <uix:contents>
                    <uix:spacer height="10" width="10"/>
		    
                    <uix:header textBinding="streamsPoolSizeName@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="STRM_POOL_MESG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="streamsPoolSizeName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="streamsPoolSizeValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="streamsPoolSizeURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>
		    
                    <uix:header textBinding="jobQueueProcessesName@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="JOB_QUEUE_PROCESSES_MSG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="jobQueueProcessesName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="jobQueueProcessesValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="jobQueueProcessURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>    

                    <uix:header textBinding="parallelMaxServersName@dbConfigParams@servletRequest" renderedBinding="parallelMaxServersUsed@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="PAR_MAX_MESG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="parallelMaxServersName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="parallelMaxServersValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="parallelMaxServersURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>

                    <uix:header textBinding="sgaTargetName@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="SGA_TAR_MESG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="sgaTargetName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="sgaTargetValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="sgaTargetURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>                       

                    <uix:header textBinding="undoRetentionName@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="UNDO_RET_MESG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="undoRetentionName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="undoRetentionValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="undoRetentionURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>       
		    
                    <uix:header textBinding="aqTmProcessesName@dbConfigParams@servletRequest">
                      <uix:contents>
                        <uix:messageStyledText textBinding="AQ_TM_PROCESSES_MSG@streamsMsgs" styleClass="OraInstructionText"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="aqTmProcessesName@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="aqTmProcessesValue@dbConfigParams@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="RELATED_LINK@streamsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" width="2%"/>
                                <uix:cellFormat hAlign="left" width="50%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:image source="/em/images/relatedlink_task.gif"/>
                                        <uix:link textBinding="INITIALIZATION_PARAMETERS@streamsMsgs" destinationBinding="aqtmProcessURL@dbConfigParams@servletRequest"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>		    
		    
                    <uix:spacer height="10" width="10"/>

					<!-- To add related links  -->
					<%--<%@ include file="../perfadv/paRelatedLinks.jspf" %> 
                    --%>
                    <%@ include file="../streamsLinks.jspf" %>
                   
					<%-- <uix:header textBinding="RELATED_LINKS@streamsMsgs">
                        <uix:bulletedList>
                        <uix:link textBinding="MANAGE_QUEUE_TABLES@streamsMsgs" destinationBinding="QueueTablesURL@servletRequest"/>
                        <uix:link textBinding="MANAGE_TRANSFORMATIONS@streamsMsgs" destinationBinding="TransformationsURL@servletRequest"/>
                        </uix:bulletedList>
                        <uix:spacer height="10" width="10"/>
                    </uix:header>
					--%>
                    
                  </uix:contents>

                      <!-- Main contents end -->
                      
            </uix:pageLayout>
            </db:form>
        </uix:body>
        </uix:document>
</uix:renderingContext>
