<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%
  request.setAttribute("streamsBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:document>   
        <uix:metaContainer>
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
        </uix:metaContainer>
        <uix:dataScope currentDataBinding="StreamsErrorsList@servletRequest">
            <db:form name="streamsErrors" method="POST" destination="/console/database/dist/streams/overviewDetails" copyParams="target,type, streamsType">
                <uix:formValue name="pageName" value="/database/dist/streams/allErrors"/>
                <uix:body>
                    <uix:pageLayout titleBinding="TITLE@servletRequest">
                        <%@ include file="/database/global.jspf" %>
                        <!-- main contents -->
                        <uix:spacer height="10" width="5"/>
                        <uix:tableLayout width="95%">
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer height="10" width="15"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                            
                                    <uix:table name="StreamsErrorsList" id="StreamsErrorsList" alternateTextBinding="NO_ITEMS_FOUND@dbBundle@servletRequest"
                                        formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex"
                                        maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize"
                                        summary="" >
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="STREAMS_NAME_HEADER@servletRequest" sortable="true"/>
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                        <uix:text textBinding="streamsNameIndex" />
                                        </uix:column>
        
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ERROR_NUMBER@streamsBundle@servletRequest" sortable="true"/>
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="numberFormat" width="20%"/>
                                        <uix:text textBinding="errorNoIndex" />
                                        </uix:column>
                  
            <%
              String showTime = (String)request.getAttribute("SHOW_TIME_COLUMN");
              if((showTime!=null)&&(showTime.equals("show")))
              {
            %>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ERROR_TIME@streamsBundle@servletRequest" sortable="true"/>
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                        <uix:text textBinding="errorTimeIndex" />
                                        </uix:column>
               <%
                }
              %>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="ERROR_MESSAGE@streamsBundle@servletRequest" sortable="true"/>
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="45%"/>
                                        <uix:text textBinding="errorMsgIndex" />
                                        </uix:column>
                                    </uix:table>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                    </uix:pageLayout>
                </uix:body>
            </db:form>
        </uix:dataScope>
    </uix:document>
</uix:renderingContext>

