<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("streamsBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
   <uix:metaContainer>
     <!-- Set the page title -->
     <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
   </uix:metaContainer>
   <uix:dataScope currentDataBinding="tableList@servletRequest">
         <db:form name="tableHandler" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type">
	<uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
	<uix:formValue name="pageName" value="/database/dist/streams/apply/addDmlErrHandler" />
     <uix:body>

		<uix:formValue name="owner" valueBinding="loggedUser@servletRequest" />
		<%--<uix:formValue name="event" value="errorHandlers" />--%>



             <uix:pageLayout titleBinding="TITLE@servletRequest" styleClass="OraInstructionText">
             <uix:messages>
             <uix:switcher childNameBinding="display@servletRequest">
              <uix:case name="info">
               <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation" textBinding="CONFIRMATION@applyBundle@servletRequest"/>
               </uix:case>
               <uix:case name="error">
                <uix:messageBox messageBinding="FAIL@servletRequest"    messageType="error" textBinding="EXCEPTION@applyBundle@servletRequest"/>
               </uix:case>
              </uix:switcher>

             </uix:messages>
		<%@ include file="/database/global.jspf" %>
	
               <uix:header textBinding="SEARCH@applyBundle@servletRequest">
                     <uix:stackLayout>
                         <uix:styledText textBinding="SEARCH_INFO@applyBundle@servletRequest" styleClass="OraInstructionText"/>
                         <uix:tableLayout width="360">
                             <uix:rowLayout width="360">
                                 <uix:cellFormat>
				    <uix:messageLovField name="schemaName" id="schemaName"   textBinding="schemaName@servletRequest" shortDescBinding="SCHEMA@applyBundle@servletRequest" promptBinding="SCHEMA@applyBundle@servletRequest"  onClick = "startLov('schemaName', 'ListSchema')" tip=""/>

                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="120">
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="searchTableName" textBinding="TABLE@applyBundle@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:textInput columns="20" name="searchTableName" id="searchTableName" shortDescBinding="TABLE@applyBundle@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:submitButton name="event" value="searchTables"  textBinding="GO@applyBundle@servletRequest" shortDescBinding="GO@applyBundle@servletRequest"  />
                                 </uix:cellFormat>
                             </uix:rowLayout>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:rowLayout width="360">
                                 <uix:cellFormat hAlign="left" width="100">
                                   <uix:contents/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="120">
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="100">
                                   <uix:contents/>
                                 </uix:cellFormat>
                             </uix:rowLayout>
                         </uix:tableLayout>
                         <uix:styledText textBinding="TO_RUN@applyBundle@servletRequest" styleClass="OraInlineInfoText"/>
                        <uix:spacer height="10" width="10" />
                 <uix:styledText textBinding="FOR_ADDING@applyBundle@servletRequest" styleClass="OraInstructionText"/>
                     </uix:stackLayout>
                 </uix:header>
                 
                 
        
                 <uix:tableLayout>
                     <uix:header text="">

				
                         <uix:spacer height="5"/>
                         <uix:tableLayout hAlign="right" width="35%">

        	    
				<uix:table name="tableList" id="tableList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="50%" tableDataBinding="rowData" valueBinding="startIndex"
				blockSizeBinding="blockTab" maxValueBinding="numRows"
				summaryBinding="ADD_DML_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="ADD_DML_TABLE_INFO@applyBundle@servletRequest" >
				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SCHEMA@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="15%"/>
					<uix:text textBinding="schemaIndex" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="TABLE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="tableIndex" />
				</uix:column>

				<uix:tableSelection>
					<uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbBundle@servletRequest">
<%--					    <uix:submitButton textBinding="ADD@applyBundle@servletRequest" shortDescBinding="ADD@applyBundle@servletRequest" name="event" value="addHandler"/>		--%>			    
					 </uix:singleSelection>
				</uix:tableSelection>

			</uix:table>

  <uix:spacer height="10" />

                         </uix:tableLayout>
                     </uix:header>
                 </uix:tableLayout>
                 <uix:spacer height="10" width="10"/>

                 <uix:header textBinding="RELATED_LINKS@applyBundle@servletRequest"/>
                 <uix:tableLayout>
                     <uix:rowLayout>
                         <uix:spacer height="10" width="10"/>
			                     <uix:spacer height="10" width="10"/>
                         <uix:link destinationBinding="createProceduresDest@servletRequest" textBinding="CREATE_PLSQL_PROCEDURES@applyBundle@servletRequest"/>

                     </uix:rowLayout>
                 </uix:tableLayout>
	        <uix:spacer height="10" width="10"/>
          <%--
		 </uix:subTabLayout>
--%>

                        <uix:pageButtons>
                            <uix:pageButtonBar>
                                <uix:contents>
                                    <uix:button textBinding="CANCEL@applyBundle@servletRequest" destinationBinding="cancelDest@servletRequest" shortDescBinding="CANCEL@applyBundle@servletRequest" />
									<uix:submitButton textBinding="CONTINUE@streamsBundle@servletRequest" shortDescBinding="CONTINUE@streamsBundle@servletRequest" name="event" value="addHandler"/>
									</uix:contents>
                            </uix:pageButtonBar>
                        </uix:pageButtons>

	 </uix:pageLayout>

     </uix:body>
     </db:form>
</uix:dataScope>

 </uix:document>
</uix:renderingContext>
