<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%> 
<script language="javascript">
function popWindow() {
    window.open('/em/console/help?topic=strms_cs_apply_common_errors', 'helpWindow', 'width=700, height=500, resizeable=yes, scrollbars=yes', true );    
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

<uix:document>   
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:dataScope currentDataBinding="errorList@servletRequest">
         <db:form name="errorHandler" method="post" destination="/console/database/dist/streams/apply" copyParams="target,type">
	<uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
	<uix:formValue name="pageName" value="/database/dist/streams/apply/applyErrors" />


            <uix:body>

                  <uix:pageLayout titleBinding="TITLE@servletRequest">
				<%@ include file="/database/global.jspf" %>
                    
                  <uix:subTabLayout>
                    <%@ include file="/database/dist/streams/repTab.jspf" %>
                     
                  <uix:messages>
                  <uix:switcher childNameBinding="display@servletRequest">
                 <uix:case name="info">
                  <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                                        textBinding="CONFIRMATION@applyBundle@servletRequest"/>
                 </uix:case>
                 <uix:case name="error">
                  <uix:messageBox messageBinding="FAIL@servletRequest"    messageType="error"
                                        textBinding="EXCEPTION@applyBundle@servletRequest"/>
          
          
                 </uix:case>
                 </uix:switcher>
                  </uix:messages>
                      <!-- main contents -->
			
			 <uix:spacer height="5" width="5"/>
			 <uix:tableLayout width="100%" >

                            <uix:rowLayout width="100%">
		
				<uix:cellFormat hAlign="right" width="30%" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="LAST_APPLY_MSG_NO@applyBundle@servletRequest"/>
                                </uix:cellFormat>
			 	<uix:spacer width="7"/>
                                <uix:cellFormat hAlign="left" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="lastSCN@servletRequest"/>
                                </uix:cellFormat>

			     </uix:rowLayout>

			     <uix:rowLayout width="100%">

				<uix:cellFormat hAlign="right" width="30%" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="LAST_APPLY_TIME@applyBundle@servletRequest"/>
                                </uix:cellFormat>
			 	<uix:spacer width="7"/>
                                <uix:cellFormat hAlign="left" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="lastSCNApplyTime@servletRequest"/>
                                </uix:cellFormat>

			     </uix:rowLayout>

			     <uix:rowLayout width="100%">

				<uix:cellFormat hAlign="right" width="30%" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="LAST_APPLIED_MSG_CREATE_TIME@applyBundle@servletRequest"/>
                                </uix:cellFormat>
			 	<uix:spacer width="7"/>
                                <uix:cellFormat hAlign="left" >
                        	   <uix:styledText styleClass="OraPromptText"
                            	        textBinding="lastSCNCreateTime@servletRequest"/>
                                </uix:cellFormat>

			     </uix:rowLayout>

                            <uix:rowLayout width="100%">
                                    <uix:spacer height="10" width="5" />
			    </uix:rowLayout>

                            <uix:rowLayout width="100%">

                                <uix:cellFormat hAlign="left" width="20%">
				<uix:rowLayout>

                                <uix:cellFormat>
                                     <uix:image source="/em/images/infoicon_active.gif" shortDescBinding="COMMON_ERROR_MSGS@applyBundle@servletRequest" />
                                </uix:cellFormat>
                                <uix:cellFormat>

                                    <uix:spacer height="10" width="5" />

                                </uix:cellFormat>
                                <uix:cellFormat>

                                    <uix:link textBinding="COMMON_ERROR_MSGS@applyBundle@servletRequest" styleClass="OraLinkText" onClick='<%= "popWindow(); return false;" %>' />

                                </uix:cellFormat>

				</uix:rowLayout>
				</uix:cellFormat>
				<uix:cellFormat hAlign="right" width="80%" columnSpan="2">
				<uix:rowLayout>
				
				<uix:cellFormat>
				
				<uix:submitButton textBinding="EXECUTE_ALL@applyBundle@servletRequest" shortDescBinding="EXECUTE_ALL@applyBundle@servletRequest" name="event" value="executeAllErrors"/>
				<uix:spacer height="10" width="10"/>
				<uix:submitButton textBinding="DELETE_ALL@applyBundle@servletRequest" shortDescBinding="DELETE_ALL@applyBundle@servletRequest" name="event" value="deleteAllErrors"/>
				</uix:cellFormat>

				</uix:rowLayout>
				</uix:cellFormat>

                            </uix:rowLayout>

                        </uix:tableLayout>
		        <uix:spacer  height="5" />

			<uix:table name="errorList" id="errorList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex"
				maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" partialRenderMode="true"
				summaryBinding="ERROR_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="ERROR_TABLE_INFO@applyBundle@servletRequest" >
				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="LOCAL_TXN_ID@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
					<uix:text textBinding="txnID" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="MSGNO@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
					<uix:text textBinding="msgNo" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="MSG_CNT@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
					<uix:text textBinding="msgCnt" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="COMMIT_SCN@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
					<uix:text textBinding="commitSCN" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SRDB@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="srcDB" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="ERROR_NUMBER@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
					<uix:text textBinding="errorNo" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="ERROR_MSG@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="35%"/>
					<uix:text textBinding="errorMsg" />
				</uix:column>
				<uix:column>
					<uix:columnHeader>
           <uix:sortableHeader textBinding="VIEW_LCRS@applyBundle@servletRequest" sortable="false"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
					<uix:image source="/em/images/detailsicon_enabled.gif" destinationBinding="viewLCRs" shortDescBinding="VIEW_LCRS@applyBundle@servletRequest" />
				</uix:column>
				<uix:tableSelection>
					<uix:multipleSelection shortDescBinding="SELECT@dbBundle@servletRequest">
					 <uix:submitButton textBinding="EXECUTE@applyBundle@servletRequest" shortDescBinding="EXECUTE@applyBundle@servletRequest" name="event" value="executeError"/>
					 <uix:spacer height="2" width="2" />
					 <uix:submitButton textBinding="DELETE@applyBundle@servletRequest" shortDescBinding="DELETE@applyBundle@servletRequest" name="event" value="deleteError"/>
					 </uix:multipleSelection>
				</uix:tableSelection>

			</uix:table>

		      <!-- navigation -->
                      <uix:tabs/>

                        </uix:subTabLayout>
                            <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                    </uix:pageLayout>

            </uix:body>
	    </db:form>
</uix:dataScope>
        </uix:document>
     </uix:renderingContext>

