<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>
<% 
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
   String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:form name="form0" destinationBinding="OKDest@servletRequest">
      <uix:body>
      <uix:formValue name="pageName" value="/database/dist/streams/apply/applyHandlers"/>
        <uix:pageLayout titleBinding="TITLE@servletRequest">
         
          <uix:messages>
            <uix:switcher childNameBinding="display@servletRequest">
              <uix:case name="info">
                <uix:messageBox messageBinding="SUCC@servletRequest" messageType="Information" textBinding="UPDATE_MSG@applyBundle@servletRequest"/>
              </uix:case>
              <uix:case name="error">
                <uix:messageBox messageBinding="FAIL@servletRequest" messageType="error" textBinding="EXCEPTION@applyBundle@servletRequest"/>
              </uix:case>
            </uix:switcher>
          </uix:messages>
          <%@ include file="/database/global.jspf"%>
            <uix:formValue name="owner" valueBinding="loggedUser@servletRequest"/>
            <uix:spacer height="5" width="5"/>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:spacer height="5" width="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:header textBinding="DDL_HANDLER@applyBundle@servletRequest" renderedBinding="showHandler@servletRequest">
              <uix:spacer height="10" width="5"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="DDL_HANDLER_INFO@applyBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="5" width="5"/>
              <uix:rowLayout>
                <uix:messageLovField name="ddlHandler" id="ddlHandler" shortDescBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" textBinding="ddlHandler@servletRequest" promptBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" onClick="setSearchFilter('owner');startLov('ddlHandler', 'ListAllProcedures')" tip=""/>
                <uix:spacer height="0" width="10"/>
                <uix:image sourceBinding="removeDDLHandlerImage@servletRequest" shortDescBinding="REMOVE_DDL_HANDLER@applyBundle@servletRequest" onClickBinding="removeDDLHandlerClicked@servletRequest"/>
              </uix:rowLayout>
            </uix:header>
            <uix:header textBinding="MSG_HANDLER@applyBundle@servletRequest" renderedBinding="showHandler@servletRequest">
              <uix:spacer height="10" width="5"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="MSG_HANDLER_INFO@applyBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="5" width="5"/>
              <uix:rowLayout>
                <uix:messageLovField name="msgHandler" id="msgHandler" textBinding="msgHandler@servletRequest" shortDescBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" promptBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" onClick="setSearchFilter('owner');startLov('msgHandler', 'ListAllProcedures')" tip=""/>
                <uix:spacer height="0" width="10"/>
                <uix:image sourceBinding="removeMsgHandlerImage@servletRequest" shortDescBinding="REMOVE_MSG_HANDLER@applyBundle@servletRequest" onClickBinding="removeMsgHandlerClicked@servletRequest"/>
              </uix:rowLayout>
            </uix:header>
            <%     
      if(!dbVersion.equals("9i"))
      {
%>
            <uix:header textBinding="PRECOMMIT_HANDLER@applyBundle@servletRequest" renderedBinding="showHandler@servletRequest">
              <uix:spacer height="10" width="5"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="PRECOMMIT_HANDLER_INFO@applyBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="5" width="5"/>
              <uix:rowLayout>
                <uix:messageLovField name="precommitHandler" id="precommitHandler" textBinding="precommitHandler@servletRequest" shortDescBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" promptBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" onClick="setSearchFilter('owner');startLov('precommitHandler', 'ListAllProcedures')" tip=""/>
                <uix:spacer height="0" width="10"/>
                <uix:image sourceBinding="removePrecommitHandlerImage@servletRequest" shortDescBinding="REMOVE_PRECOMMIT_HANDLER@applyBundle@servletRequest" onClickBinding="removePrecommitHandlerClicked@servletRequest"/>
              </uix:rowLayout>
            </uix:header>
            <% 
      }
%>


          <uix:header textBinding="ERROR_PAGE_TITLE@applyBundle@servletRequest">
              <uix:spacer height="10" width="5"/>
            <uix:tableLayout width="80%">
			    <uix:rowLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="DML_ERROR_HANDLER_INFO@applyBundle@servletRequest"/>
                </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
				    <uix:dataScope currentDataBinding="tableHandlerList@servletRequest">
                  <uix:spacer height="10" width="5"/>


								<uix:table name="tableHandlerList" id="tableHandlerList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true"  tableDataBinding="rowData" valueBinding="startIndex" width="100%"
				blockSizeBinding="blockTab" maxValueBinding="numRows"
				summaryBinding="HANDLER_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="HANDLER_TABLE_INFO@applyBundle@servletRequest" >
				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SCHEMA@applyBundle@servletRequest" sortable="no"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="15%"/>
					<uix:text textBinding="ownerIndex" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="TABLE@applyBundle@servletRequest" sortable="no"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="tableIndex" />
				</uix:column>
       
        <uix:column useSeparateRows="true">
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OPERATION@applyBundle@servletRequest" sortable="no"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:contents childDataBinding="operationIndex">
					<uix:text textBinding="Operation" />
					</uix:contents> 
				</uix:column>
        
    <uix:column  useSeparateRows="true">
					<uix:columnHeader>
					<uix:sortableHeader textBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" sortable="no"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
 				   <uix:contents childDataBinding="procedureIndex">

					<uix:text textBinding="Procedure" />
					</uix:contents> 
				</uix:column>
        
        <uix:column  useSeparateRows="true">
					<uix:columnHeader>
					<uix:sortableHeader textBinding="DML_HANDLER@applyBundle@servletRequest" sortable="no"/>
					</uix:columnHeader>
          <uix:columnFormat columnDataFormat="textFormat"/>
					<uix:contents childDataBinding="operationIndex">
					<uix:text textBinding="Type" />
					</uix:contents> 
				</uix:column>
 
				<uix:tableActions>
					  <uix:cellFormat  rendered="true" >
							<uix:submitButton textBinding="ADD@applyBundle@servletRequest" shortDescBinding="ADD@applyBundle@servletRequest" name="event" valueBinding="addDmlErrorHandler@servletRequest" />
					  </uix:cellFormat>
					</uix:tableActions>

				<uix:tableSelection>
					<uix:singleSelection shortDescBinding="SELECT@dbBundle@servletRequest" selectedIndex="0">
					
					     <uix:submitButton textBinding="EDIT@applyBundle@servletRequest" shortDescBinding="MANAGE@applyBundle@servletRequest" name="event" value="editHandler"/>
						 <uix:submitButton textBinding="DELETE@applyBundle@servletRequest" shortDescBinding="MANAGE@applyBundle@servletRequest" name="event" valueBinding="deleteHandler@servletRequest"/>

					 </uix:singleSelection>

				</uix:tableSelection>

			</uix:table>
    </uix:dataScope>

  <uix:spacer height="10" />

                       


                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:spacer height="5" width="5"/>
			</uix:header>

			 <uix:pageButtons>
                            <uix:pageButtonBar>
                                <uix:contents>
                                    <uix:button textBinding="CANCEL@applyBundle@servletRequest" destinationBinding="CANCELDest@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" renderedBinding="showCancel@servletRequest" />
                                    <uix:submitButton textBinding="OK@applyBundle@servletRequest"  shortDescBinding="OK@sb@servletRequest" name="action" value="OK"/>
                                </uix:contents>
                            </uix:pageButtonBar>
                        </uix:pageButtons>

             <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
        </uix:pageLayout>
      </uix:body>
    </uix:form>
  </uix:document>
</uix:renderingContext>
