<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
	         <uix:dataScope currentDataBinding="paramsList@servletRequest">
                 <db:form name="EditApplyParamsForm" method="POST" destination="/console/database/dist/streams/apply" copyParams="target,type, otype,objectType,sname, oname">
                 <uix:formValue name="pageName" value="/database/dist/streams/apply/applyParams" />		   
                 <uix:formValue name="applyName" valueBinding="applyName@defaultBean@servletRequest" />
                 <uix:formValue name="target" valueBinding="TARGET@servletRequest" />
                 <uix:formValue name="type" valueBinding="TYPE@servletRequest" />
                 <uix:formValue name="dispTag" valueBinding="dispTag@servletRequest" />
                 
                 <uix:pageLayout titleBinding="TITLE@servletRequest">
                     
		    <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
        
     			  <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
        
          <%@ include file="/database/global.jspf" %>
                    <!-- main contents -->
                        <uix:subTabLayout>
                            <uix:spacer height="10" width="10"/>
                <uix:header textBinding="PARAMETERS@captureBundle@servletRequest">
	 
          <uix:tableLayout width="70%">
          <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="center">
          
          <uix:submitButton name="event" value="default_params" textBinding="RESTORE_DEFAULTS@captureBundle@servletRequest" shortDescBinding="RESTORE_DEFAULTS@captureBundle@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="3" />
         <!-- table starts here -->
         <uix:table name="paramsList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
                formSubmitted="true" width="70%" tableDataBinding="rowData" valueBinding="startIndex"
                maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize"
                summaryBinding="PARAMS_TABLE_DESC@applyBundle@servletRequest"
                shortDescBinding="PARAMS_TABLE_SUMM@applyBundle@servletRequest" >

               <uix:column>
                     <uix:columnHeader>
                         <uix:sortableHeader textBinding="NAME@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="60%"/>
                     <uix:text textBinding="paramNameIndex" />
               </uix:column>

               <uix:column>
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="VALUE@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>					  
                   <uix:textInput name="paramValueIndex" textBinding="paramValueIndex" shortDescBinding="VALUE@captureBundle@servletRequest" />
               </uix:column>

               <uix:column>
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="SETBYUSER@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                     <uix:text textBinding="paramSetbyIndex" />
               </uix:column>

          </uix:table>
         </uix:header>
			    

			<uix:hideShowHeader textBinding="APPLY_TAG@applyBundle@servletRequest" disclosedBinding="disclosedTag@servletRequest"
			formSubmitted="true" id="headTag" destinationBinding="displayDest@servletRequest" >
    <uix:spacer height="30" width="0" />
    <uix:styledText styleClass="OraInstructionText" textBinding="TAG_INFO@applyBundle@servletRequest"/>
                          <uix:spacer height="10" width="30"/>
                          <uix:tableLayout width="40%">                            
                             <uix:rowLayout>                                
                                <uix:cellFormat>
                                   <uix:spacer height="10" width="10"/>
                                </uix:cellFormat>
                             </uix:rowLayout>
  
                              <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                       <uix:styledText styleClass="OraInstructionText" textBinding="CUR_APPLY_TAG@applyBundle@servletRequest"/>
                                  </uix:cellFormat>
  				<uix:cellFormat>
                                      <uix:spacer height="10" width="10"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                      <uix:styledText textBinding="applyTag_orig" styleClass="OraDataText" />
                                  </uix:cellFormat>
                              </uix:rowLayout>
  			    <uix:rowLayout>
                                  <uix:cellFormat hAlign="right">
                                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="applyTag" textBinding="NEW_APPLY_TAG@applyBundle@servletRequest"/>
                                  </uix:cellFormat>
  				<uix:cellFormat>
                                      <uix:spacer height="10" width="10"/>
                                  </uix:cellFormat>
  				<uix:cellFormat>
                                      <uix:textInput columns="10" name="applyTag" id="applyTag" shortDescBinding="NEW_APPLY_TAG@applyBundle@servletRequest" textBinding="applyTag"/>
                                  </uix:cellFormat>
                              </uix:rowLayout>
                          </uix:tableLayout>
</uix:hideShowHeader>



                        </uix:subTabLayout>
                        <uix:spacer height="10" width="10"/>
			<uix:pageButtons>
                        <uix:flowLayout>
                            <uix:pageButtonBar>
                                <uix:button textBinding="CANCEL@captureBundle@servletRequest" destinationBinding="APPLYDEST@servletRequest" shortDescBinding="CANCEL@captureBundle@servletRequest"/>
 
                                <uix:submitButton name="event" value="revert" textBinding="REVERT@dbBundle@servletRequest" shortDescBinding="REVERT@dbBundle@servletRequest"/>
                                <uix:submitButton name="event" value="apply_params" textBinding="APPLY@dbBundle@servletRequest" shortDescBinding="APPLY@dbBundle@servletRequest"/>                 
                            </uix:pageButtonBar>
                        </uix:flowLayout>
                      </uix:pageButtons>
                       <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
		    </uix:pageLayout>
                </db:form>
		</uix:dataScope>
            </uix:body>
        </uix:document>
</uix:renderingContext>
