<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>

<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
     <oem:setURLEncoder id="renderingContext"/>  
      <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
        <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
          <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
			</uix:rawText>
          </uix:case>
        </uix:switcher>
        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>          
            <uix:body>              
                
                <db:form name="serverStatsDetailsForm" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,applyName">
                <uix:formValue name="pageName" value="/database/dist/streams/apply/applyServerStats"/>
                    <uix:pageLayout titleBinding="TITLE@servletRequest">
                    <!-- main contents -->
                     
                    <uix:tableLayout width="100%">
                        <uix:rowLayout width="100%">
                          <uix:cellFormat hAlign="right" vAlign="top">
                            <uix:tableLayout width="100%">
                              <uix:rowLayout>                                      
                              <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                              <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@applyBundle@servletRequest"/>
                              <uix:spacer height="10" width="10"/>
                              <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                              <uix:spacer height="10" width="10"/>
                              <uix:submitButton textBinding="REFRESH@applyBundle@servletRequest" shortDescBinding="REFRESH@applyBundle@servletRequest" name="event" value="refreshStatistics"/>
                      
                              </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                 <uix:cellFormat>
                                <uix:spacer height="5" width="10"/>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout hAlign="right">
                              <uix:cellFormat hAlign="right">
                              <uix:rowLayout>
                      
                                <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@applyBundle@servletRequest" labeledNodeId="refreshHome" />
                                <uix:spacer height="5" width="10"/>
                                <uix:choice name="refreshHome" id="refreshHome"
                                  onChange="submitForm('serverStatsDetailsForm', true, {'event':'refreshStatistics'})"
                                  selectedValueBinding="refreshHomeSelected@servletRequest">
                                <uix:option textBinding="MANUALLY@applyBundle@servletRequest"
                                  value="RT_MAN"/>
                                <uix:option textBinding="AUTOMATIC@applyBundle@servletRequest"
                                  value="RT_60"/>
                                </uix:choice>
                              </uix:rowLayout>                                          
                              </uix:cellFormat>                                      
                              </uix:rowLayout>                                  
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                      <%@ include file="/database/global.jspf" %>
                      
                     
                     <uix:tableLayout width="100%"> 
                      <uix:rowLayout>
                       <uix:cellFormat hAlign="center">
                       
                        <uix:tableLayout width="70%">
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="SERVERID@applyBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="serverID@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="STATE@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="state@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                   <uix:styledText styleClass="OraInstructionText" textBinding="SESSION_ID@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">       
                                   <db:link destinationBinding="sessionIDUrl@defaultBean@servletRequest"
                                             copyParams="type,target" 
					     shortDescBinding="SESSION_DETAILS@streamsMsgs@servletRequest"
	                                     textBinding="sessionID@defaultBean@servletRequest" /> 
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="MSGNO@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="msgNo@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                                                      
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="TXN_ID@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="txnId@defaultBean@servletRequest"/>
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="DEP_TXN_ID@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="depTxnId@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="COMMIT_SCN@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="commitSCN@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="SERIAL_NO@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="serialNo@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:tableLayout width="80%">
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="TOT_TXN_ASSG@applyBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">
                                    <uix:spacer height="10" width="5"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText" textBinding="txnAssg@defaultBean@servletRequest" />
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="MSGS_APPL@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="msgApplied@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_TIME@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="applyTime@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_MSG_NO@applyBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">
                                    <uix:spacer height="10" width="5"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText" textBinding="appliedMsgNo@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="APPLIED_MSG_CREATE_TIME@applyBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">
                                    <uix:spacer height="10" width="5"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText" textBinding="appliedMsgCrtTime@defaultBean@servletRequest"/>
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ADMJOBSDONE@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="admJobsDone@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="TOTAL_ROLLBACKS@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="txnRollbacks@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">                              
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ELAP_DQ_TIME@applyBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="elapDqTime@defaultBean@servletRequest"/>
                                </uix:cellFormat>   
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="right">                                  
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ELAP_APL_TIME@applyBundle@servletRequest"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">                                  
                                    <uix:spacer height="10" width="5"/>                                  
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">                                  
                                    <uix:styledText styleClass="OraDataText" textBinding="elapApplyTime@defaultBean@servletRequest"/>                                  
                                </uix:cellFormat>                              
                            </uix:rowLayout>
                                                      
                        </uix:tableLayout>
                       </uix:cellFormat>
                      </uix:rowLayout>
                     </uix:tableLayout>
                  <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                 </uix:pageLayout>                  
                </db:form>              
            </uix:body>          
        </uix:document>      
</uix:renderingContext>



