<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:dataScope currentDataBinding="CompareList@servletRequest">
         <db:form name="errorLCRs" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,msgNum">
	<uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
  <uix:formValue name="pageName" value="/database/dist/streams/apply/compareColValues" />

            <uix:body>

                  <uix:pageLayout titleBinding="TITLE@servletRequest">
			<%@ include file="/database/global.jspf" %>
                     <uix:contents>
                      <!-- main contents -->
			<uix:switcher childNameBinding="display@servletRequest">
			 <uix:case name="info">
			  <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                              textBinding="CONFIRMATION@applyBundle@servletRequest"/>
			      <uix:spacer height="10" width="5"/>
			 </uix:case>
			 <uix:case name="error">
			  <uix:messageBox messageBinding="FAIL@servletRequest"    messageType="error"
                              textBinding="EXCEPTION@applyBundle@servletRequest"/>
			<uix:spacer height="5" width="5"/>

			 </uix:case>
			 </uix:switcher>
       <uix:bulletedList>     
          <uix:styledText styleClass="OraInstructionText" textBinding="OLD_COL_INFO@applyBundle@servletRequest" />
          <uix:styledText styleClass="OraInstructionText" textBinding="NEW_COL_INFO@applyBundle@servletRequest"  />
          <uix:styledText styleClass="OraInstructionText" textBinding="CURR_COL_INFO@applyBundle@servletRequest" />
       </uix:bulletedList>
       <uix:spacer height="5" width="5"/>
			 <uix:table name="CompareList" id="CompareList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex"
				blockSizeBinding="blockSize" maxValueBinding="numRows"  minValue="1" 
				summary="COMPARECOL_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="COMPARECOL_TABLE_INFO@applyBundle@servletRequest" >

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="COLUMN_NAME@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="colName" />
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="COLUMN_TYPE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="colType" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OLD_VALUE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="oldVal" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="NEW_VALUE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="newVal" />
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="CURR_VALUE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="currVal" />
				</uix:column>
        
			</uix:table>
			

		      <!-- navigation -->
                      <uix:tabs/>
                       </uix:contents>
                      <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                    </uix:pageLayout>

            </uix:body>

	    </db:form>
</uix:dataScope>
        </uix:document>
     </uix:renderingContext>

