<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<%  
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("streamsMsgs", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  String target = (String)request.getAttribute("target");
  String applyName = (String)request.getAttribute("applyName");
  String dbVersion = (String)request.getAttribute("DBVERSION");
 
%>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
			</uix:rawText>
        </uix:case>
    </uix:switcher>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="coordStatsForm" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,applyName">
                <uix:formValue name="pageName" value="/database/dist/streams/apply/coordinator"/>
                <uix:formValue name="target" valueBinding="targetDB@servletRequest"/>
                <uix:pageLayout titleBinding="TITLE@servletRequest">
                    <%@ include file="/database/global.jspf"%>
            <uix:subTabLayout>
                <%@ include file="/database/dist/streams/repTab.jspf" %>
                 
                    <!-- main contents -->
                 <uix:contents>
                    <uix:tableLayout width="100%">
                        <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:tableLayout width="100%">
                                    <uix:rowLayout>
                                        <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                            <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@applyBundle@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@applyBundle@servletRequest" shortDescBinding="REFRESH@applyBundle@servletRequest" name="event" value="refreshStatistics"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="5" width="10"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout hAlign="right">
                                        <uix:cellFormat hAlign="right">
                                            <uix:rowLayout>
                                                <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@applyBundle@servletRequest"  labeledNodeId="ViewLabel" />
                                                <uix:spacer height="5" width="10"/>
                                                <uix:choice name="refreshHome" id="ViewLabel" onChange="submitForm('coordStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                                                    <uix:option textBinding="MANUALLY@applyBundle@servletRequest" value="RT_MAN"/>
                                                    <uix:option textBinding="AUTOMATIC@applyBundle@servletRequest" value="RT_60"/>
                                                </uix:choice>
                                            </uix:rowLayout>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:spacer height="10" width="10"/>


                    <uix:subTabLayout>
<uix:contents>
                        <uix:subTabBar selectedIndex="2">
                            <uix:link destinationBinding="qDest@servletRequest" textBinding="QUEUE@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="rDest@servletRequest" textBinding="READER@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="cDest@servletRequest" textBinding="COORDINATOR@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="sDest@servletRequest" textBinding="SERVER@applyBundle@servletRequest"/>
                        </uix:subTabBar>
                        <uix:spacer height="10" width="10"/>
                        <uix:rowLayout width="100%">
                            <uix:cellFormat>
                                <uix:tableLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="STATE@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="state@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
				    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="SID_COORD@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraLinkText" textBinding="sid@defaultBean@servletRequest" destinationBinding="sidUrl@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TXN_APPLIED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnApplied@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TXN_ASSIGNED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnAssg@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TXN_RECD@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnRecd@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
<%
if (dbVersion != null && (dbVersion.equals("102g") || dbVersion.equals("11g")))
{
%>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TOTAL_IGNORED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnIgnored@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TOTAL_ROLLBACKS@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnRollbacks@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
<%
}
%>

<%
if (dbVersion != null && dbVersion.equals("11g"))
{
%>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="UNASSIGNED_TXNS@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnUnassigned@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TXN_BUFFER_SIZE@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="txnBufferSize@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
<%
}
%>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TOT_ERROR_CNT@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="totErrorCnt@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="DEPENDENCY_WAITS@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="depWaits@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="WAITS_TO_COMMIT@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="waitsCommit@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="ADM_REQ_ISSUED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="admReqIssued@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TIME_LOWWATER_UPDATED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="lowwatermarkUpdateTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="LOWWATERMARK_MSG@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="lowwatermarkMsg@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="LOWWATERMARK_MSG_CREATETIME@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="lowwatermarkCrtTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TIME_HIGHWATER_UPDATED@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="highwatermarkUpdateTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="HIGHWATERMARK_MSG@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="highwatermarkMsg@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="HIGHWATERMARK_MSG_CREATETIME@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="highwatermarkCrtTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_TIME@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="startupTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_SCH_TIME@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="elapsedSchTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
<%
if (dbVersion != null && dbVersion.equals("102g"))
{
%>
                                    <uix:rowLayout width="100%">
                                        <uix:cellFormat hAlign="right">
                                            <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_IDLE_TIME@applyBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="center">
                                            <uix:spacer height="10" width="5"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:styledText styleClass="OraDataText" textBinding="elapsedIdleTime@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
<%
}
%>
                                </uix:tableLayout>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:tableLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="center">                        

                                            <oem:chart shadowEffect="shadow" shortDescBinding="COORD_CHART_INFO@applyBundle@servletRequest" titleBinding="COOR_STATS@applyBundle@servletRequest" chartType="timeSeriesChart" yAxisLabelBinding="NUM_TXNS@applyBundle@servletRequest" xAxisLabelBinding="TIME@applyBundle@servletRequest" legendVisible="external" width="300" height="220" orientation="vertical">
                                            <oem:sqlChartDataSource sqlPreparedStatementBinding="coordChartDataSource@defaultBean@servletRequest"/>
                                            <oem:chartColumn displayLabelBinding="TOT_RECD@applyBundle@servletRequest" sourceIndex="0" itemColor="#9999FF"/>
                                            <oem:chartColumn displayLabelBinding="TOT_ASSG@applyBundle@servletRequest" sourceIndex="1" itemColor="#99FFFF"/>
                                            <oem:chartColumn displayLabelBinding="TOT_TXN_APPL@applyBundle@servletRequest" sourceIndex="2" itemColor="#999999"/>
                                            <oem:chartColumn isTimeColumn="true" displayLabelBinding="TIME@applyBundle@servletRequest" sourceIndex="3"/>
                                            </oem:chart>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>

<%
if (dbVersion != null && dbVersion.equals("102g") || dbVersion.equals("11g"))
{
%>
<uix:rowLayout width="100%">
<uix:contents>

<uix:include node="/database/dist/streams/activeTxnList.jsp" />

</uix:contents>
</uix:rowLayout>

<%
}
%>
               </uix:contents>
                    </uix:subTabLayout>

               </uix:contents>

             </uix:subTabLayout>
                 <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
