<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>
<% 
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:dataScope currentDataBinding="tableHandlerList@servletRequest">
      <db:form name="tableHandler" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type">
        <uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
        <uix:formValue name="pageName" value="/database/dist/streams/apply/dmlErrorHandlers"/>
        <uix:body>
          <uix:formValue name="owner" valueBinding="loggedUser@servletRequest"/>
          <%--<uix:formValue name="event" value="errorHandlers" />--%>
          <uix:pageLayout titleBinding="TITLE@servletRequest" styleClass="OraInstructionText">
           <uix:subTabLayout>
            <%@ include file="/database/dist/streams/repTab.jspf" %>
             
             <uix:contents>
            <uix:messages>
              <uix:switcher childNameBinding="display@servletRequest">
                <uix:case name="info">
                  <uix:messageBox messageBinding="SUCC@servletRequest" messageType="Information" textBinding="UPDATE_MSG@applyBundle@servletRequest"/>
                </uix:case>
                <uix:case name="error">
                  <uix:messageBox messageBinding="FAIL@servletRequest" messageType="error" textBinding="EXCEPTION@applyBundle@servletRequest"/>
                </uix:case>
              </uix:switcher>
            </uix:messages>
            <%@ include file="/database/global.jspf"%>
            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="si@servletRequest">
                  <%     
      if(dbVersion.equals("10g"))
      {
%>
                  <uix:link destinationBinding="generalDest@servletRequest" textBinding="GENERAL@applyBundle@servletRequest"/>
                  <% 
      }
%>
                  <uix:link destinationBinding="dmlErrorDest@servletRequest" textBinding="ERROR_PAGE_TITLE@applyBundle@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>
              <uix:spacer height="5" width="5"/>
              <uix:tableLayout width="100%">
                <%--
                     <uix:header text="">
                    --%> 
      <uix:rowLayout hAlign="right" width="100%">
       <uix:cellFormat hAlign="right" width="100%">
       <uix:spacer height="5" width="5"/>
				<uix:submitButton textBinding="ADD@applyBundle@servletRequest" shortDescBinding="ADD@applyBundle@servletRequest" name="event" value="addDmlErrorHandler"/>
        <uix:spacer height="5" width="5"/>
      </uix:cellFormat>
      </uix:rowLayout>
      <uix:rowLayout>
       <uix:cellFormat>
       <uix:spacer height="5" width="5"/>
       </uix:cellFormat>
      </uix:rowLayout>
       <uix:rowLayout>
       <uix:cellFormat>
                         
        
      
				<uix:table name="tableHandlerList" id="tableHandlerList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex"
				blockSizeBinding="blockTab" maxValueBinding="numRows"
				summaryBinding="HANDLER_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="HANDLER_TABLE_INFO@applyBundle@servletRequest" >
				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SCHEMA@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="15%"/>
					<uix:text textBinding="ownerIndex" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="TABLE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="tableIndex" />
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OPERATION@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="operationIndex" />
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="HANDLER_PROCEDURE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="procedureIndex" />
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="DML_HANDLER@applyBundle@servletRequest" sortable="false"/>
					</uix:columnHeader>
          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
          <uix:image sourceBinding="dmlHandlerIndex"/>					
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="ERROR_HANDLER@applyBundle@servletRequest" sortable="false"/>
					</uix:columnHeader>
          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
          <uix:image sourceBinding="errorHandlerIndex"/>					
				</uix:column>
        
        <uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="GENERAL_HANDLER@applyBundle@servletRequest" sortable="false"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="iconButtonFormat"/>
					<uix:image sourceBinding="generalHandlerIndex" />
				</uix:column>
        
        

				<uix:tableSelection>
					<uix:singleSelection selectedIndex="0"  shortDescBinding="SELECT@dbBundle@servletRequest">
					
					     <uix:submitButton textBinding="MANAGE@applyBundle@servletRequest" shortDescBinding="MANAGE@applyBundle@servletRequest" name="event" value="editHandler"/>
					
					 </uix:singleSelection>
				</uix:tableSelection>

			</uix:table>

  <uix:spacer height="10" />

                       
                         
       </uix:cellFormat>
      </uix:rowLayout>
                  <%--   </uix:header>--%>
                 </uix:tableLayout>
                 <uix:spacer height="10" width="10"/>

                 <uix:header textBinding="RELATED_LINKS@applyBundle@servletRequest"/>
                 <uix:tableLayout>
                     <uix:rowLayout>
                         <uix:spacer height="10" width="10"/>
			                     <uix:spacer height="10" width="10"/>
                         <uix:link destinationBinding="createProceduresDest@servletRequest" textBinding="CREATE_PLSQL_PROCEDURES@applyBundle@servletRequest"/>

                     </uix:rowLayout>
                 </uix:tableLayout>
	        <uix:spacer height="10" width="10"/>
		 </uix:subTabLayout>
           </uix:contents>
         </uix:subTabLayout>
             <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
	 </uix:pageLayout>

     </uix:body>
     </db:form>
</uix:dataScope>

 </uix:document>
</uix:renderingContext>
