
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>

<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
%>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

    <uix:body>


        <uix:contents>
          <uix:pageLayout messageType="error">

            <%@ include file="/database/global.jspf" %>

            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:stackLayout>

                <uix:spacer height="4"/>
                <uix:styledText styleClass="OraErrorText"
                                textBinding="ERRORINFO@servletRequest"/>
                <uix:spacer height="4"/>

		<uix:styledText styleClass="OraInstructionText"
                                textBinding="INSUFF_PRIVILEGES@servletRequest"/>

              </uix:stackLayout>
            </uix:rowLayout>


            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button  textBinding="OK@applyBundle@servletRequest" destinationBinding="OKDEST@servletRequest" />
              </uix:pageButtonBar>
            </uix:pageButtons>
z
          </uix:pageLayout>

        </uix:contents>

    </uix:body>
  </uix:document>
</uix:renderingContext>
