<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>
<% 
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:dataScope currentDataBinding="handlerList@servletRequest">
      <db:form name="tableHandler" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,schemaName,tableName,pageSubTitle">
        <uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
        <uix:formValue name="owner" valueBinding="loggedUser@servletRequest"/>
        <uix:body>
          <uix:pageLayout titleBinding="TITLE@servletRequest">
            <uix:messages>
              <uix:switcher childNameBinding="display@servletRequest">
                <uix:case name="info">
                  <uix:messageBox messageBinding="SUCC@servletRequest" messageType="confirmation" textBinding="CONFIRMATION@applyBundle@servletRequest"/>
                </uix:case>
                <uix:case name="error">
                  <uix:messageBox messageBinding="FAIL@servletRequest" messageType="error" textBinding="EXCEPTION@applyBundle@servletRequest"/>
                </uix:case>
              </uix:switcher>
            </uix:messages>
            <%@ include file="/database/global.jspf"%>
     
            <uix:header textBinding="pageSubTitle@servletRequest">
              <uix:tableLayout hAlign="right">
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="2" hAlign="right" width="100%"/>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="20" width="10"/>
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:spacer height="10" width="10"/>
                  <uix:table name="handlersList" id="handlerList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest" formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex" maxValueBinding="numRows" minValue="1" blockSizeBinding="blockSize" summaryBinding="MANAGE_HANDLER_TABLE_INFO@applyBundle@servletRequest" shortDescBinding="MANAGE_HANDLER_TABLE_INFO@applyBundle@servletRequest">
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="OPERATION@applyBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:text textBinding="operationIndex"/>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="HANDLER_PROCEDURE@applyBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:messageLovField columns="50" name="handlerName" id="handlerName" textBinding="handlerName" shortDescBinding="DML_HANDLER@applyBundle@servletRequest" onClickBinding="handlerNameLov" tip=""/>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="HANDLER_TYPE@applyBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:choice name="handlerType" id="handlerType"
                                  selectedValueBinding="handlerType">
                                <uix:option textBinding="DML@applyBundle@servletRequest"
                                  value="N"/>
                                <uix:option textBinding="ERROR@applyBundle@servletRequest"
                                  value="Y"/>
					</uix:choice>
                    </uix:column>

                  </uix:table>
                  <uix:spacer height="10" width="10"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
            <!-- navigation -->
            <uix:tabs/>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@applyBundle@servletRequest" shortDescBinding="CANCEL@applyBundle@servletRequest" destinationBinding="cancelDest@servletRequest"/>				
                <uix:submitButton textBinding="OK@applyBundle@servletRequest" shortDescBinding="OK@applyBundle@servletRequest" name="event" value="modifyHandler"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

   <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
  
          </uix:pageLayout>
        </uix:body>
      </db:form>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
