<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<%  
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  String target = (String)request.getAttribute("target");
  String dbVersion = (String)request.getAttribute("DBVERSION");
    
%>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
			</uix:rawText>
        </uix:case>
    </uix:switcher>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="queueStatsForm" method="get" destination="/console/database/dist/streams/apply" copyParams="type,applyName">
                <uix:formValue name="pageName" value="/database/dist/streams/apply/queueStats"/>
                <uix:formValue name="target" valueBinding="targetDB@servletRequest"/>
                <uix:pageLayout titleBinding="TITLE@servletRequest">
                    <%@ include file="/database/global.jspf"%>
 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>
      <uix:contents>


                    <!-- main contents -->
                    <uix:tableLayout width="100%">
                        <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:tableLayout width="100%">
                                    <uix:rowLayout>
                                        <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                            <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@applyBundle@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@applyBundle@servletRequest" shortDescBinding="REFRESH@applyBundle@servletRequest" name="event" value="refreshStatistics"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="5" width="10"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout hAlign="right">
                                        <uix:cellFormat hAlign="right">
                                            <uix:rowLayout>
                                                <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@applyBundle@servletRequest" labeledNodeId="ViewLabel" />
                                                <uix:spacer height="5" width="10"/>
                                                <uix:choice name="refreshHome" id="ViewLabel" onChange="submitForm('queueStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                                                    <uix:option textBinding="MANUALLY@applyBundle@servletRequest" value="RT_MAN"/>
                                                    <uix:option textBinding="AUTOMATIC@applyBundle@servletRequest" value="RT_60"/>
                                                </uix:choice>
                                            </uix:rowLayout>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:spacer height="10" width="10"/>
                    <uix:subTabLayout>
                        <uix:subTabBar selectedIndex="0">
                            <uix:link destinationBinding="qDest@servletRequest" textBinding="QUEUE@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="rDest@servletRequest" textBinding="READER@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="cDest@servletRequest" textBinding="COORDINATOR@applyBundle@servletRequest"/>
                            <uix:link destinationBinding="sDest@servletRequest" textBinding="SERVER@applyBundle@servletRequest"/>
                        </uix:subTabBar>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout>
                            <uix:tableLayout>
                                <uix:rowLayout>
                                    <uix:cellFormat wrappingDisabled="false" hAlign="left" vAlign="top">
                                        <uix:header textBinding="PERS_Q_STATS@applyBundle@servletRequest">
                                            <uix:spacer height="10" width="10"/>
                                            <uix:tableLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NOMSGS_WAITING@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="noMsgsWaiting@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NOMSGS_READY@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="noMsgsReady@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NOMSGS_EXPIRED@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="noMsgsExpired@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="TOT_WAIT_TIME@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="totalWaitTime@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="AVG_WAIT_TIME@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="avgWaitTime@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                            </uix:tableLayout>
                                        </uix:header>
                    <%  
      
      if(!dbVersion.equals("9i"))
      {
%>
                                        <uix:header textBinding="BUFF_Q_STATS@applyBundle@servletRequest">
                                            <uix:spacer height="10" width="10"/>
                                            <uix:tableLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="CUR_NOMSGS@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="noMsgs@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="CUR_NO_SPILLED_MSGS@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:styledText styleClass="OraDataText" textBinding="noSpilledMsgs@defaultBean@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                            </uix:tableLayout>
                                        </uix:header>
                    <%  
      }
%>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" vAlign="top" width="40%">
                                        <uix:switcher childNameBinding="applyType@servletRequest">
                                            <uix:case name="persistent">
                                                <oem:chart shadowEffect="shadow" shortDescBinding="QUEUE_STATS_INFO@applyBundle@servletRequest" titleBinding="MESSAGE_STATS@applyBundle@servletRequest" chartType="timeSeriesChart" legendVisible="external" width="300" height="220" yAxisLabelBinding="NUM_MSGS@applyBundle@servletRequest" xAxisLabelBinding="TIME@applyBundle@servletRequest" orientation="vertical">
                                                <oem:sqlChartDataSource sqlPreparedStatementBinding="persQChartDataSource@defaultBean@servletRequest"/>
                                                <oem:chartColumn displayLabelBinding="READY@applyBundle@servletRequest" sourceIndex="0" itemColor="#9999FF"/>
                                                <oem:chartColumn displayLabelBinding="WAITING@applyBundle@servletRequest" sourceIndex="1" itemColor="#99FFFF"/>
                                                <oem:chartColumn isTimeColumn="true" displayLabel="TIME@applyBundle@servletRequest" sourceIndex="2"/>
                                                </oem:chart>
                                            </uix:case>
                                            <uix:case name="buffered">
                                                <oem:chart shadowEffect="shadow" shortDescBinding="QUEUE_STATS_INFO@applyBundle@servletRequest" titleBinding="MESSAGE_STATS@applyBundle@servletRequest" chartType="timeSeriesChart" legendVisible="external" width="300" height="220" yAxisLabelBinding="NUM_MSGS@applyBundle@servletRequest" xAxisLabelBinding="TIME@applyBundle@servletRequest" orientation="vertical">
                                                <oem:sqlChartDataSource sqlPreparedStatementBinding="buffQChartDataSource@defaultBean@servletRequest"/>
                                                <oem:chartColumn displayLabelBinding="NUM_MSGS@applyBundle@servletRequest" sourceIndex="0" itemColor="#9999FF"/>
                                                <oem:chartColumn displayLabelBinding="NO_SPILLED_MSGS@applyBundle@servletRequest" sourceIndex="1" itemColor="#99FFFF"/>
                                                <oem:chartColumn isTimeColumn="true" displayLabel="TIME@applyBundle@servletRequest" sourceIndex="2"/>
                                                </oem:chart>
                                            </uix:case>
                                        </uix:switcher>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                        </uix:tableLayout>
                    </uix:subTabLayout>
  </uix:contents>
 </uix:subTabLayout>
  <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                        
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
