<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<% 
  request.setAttribute("streamsMsgs", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));

  String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
	<uix:rawText>
		<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
	</uix:rawText>
    </uix:case>
  </uix:switcher>
  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="queueStatsForm" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,applyName">
        <uix:formValue name="pageName" value="/database/dist/streams/apply/reader"/>
        <uix:formValue name="target" valueBinding="targetDB@servletRequest"/>
        <uix:pageLayout titleBinding="TITLE@servletRequest">
          <%@ include file="/database/global.jspf"%>
 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>
      <uix:contents>

          <!-- main contents -->
          <uix:tableLayout width="100%">
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                      <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@applyBundle@servletRequest"/>
                      <uix:spacer height="10" width="10"/>
                      <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                      <uix:spacer height="10" width="10"/>
                      <uix:submitButton textBinding="REFRESH@applyBundle@servletRequest" shortDescBinding="REFRESH@applyBundle@servletRequest" name="event" value="refreshStatistics"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:spacer height="5" width="10"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="right">
                      <uix:rowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@applyBundle@servletRequest" labeledNodeId="ViewLabel"/>
                        <uix:spacer height="5" width="10"/>
                        <uix:choice name="refreshHome" id="ViewLabel" onChange="submitForm('queueStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                          <uix:option textBinding="MANUALLY@applyBundle@servletRequest" value="RT_MAN"/>
                          <uix:option textBinding="AUTOMATIC@applyBundle@servletRequest" value="RT_60"/>
                        </uix:choice>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="10" width="10"/>
          <uix:subTabLayout>
            <uix:subTabBar selectedIndex="1">
              <uix:link destinationBinding="qDest@servletRequest" textBinding="QUEUE@applyBundle@servletRequest"/>
              <uix:link destinationBinding="rDest@servletRequest" textBinding="READER@applyBundle@servletRequest"/>
              <uix:link destinationBinding="cDest@servletRequest" textBinding="COORDINATOR@applyBundle@servletRequest"/>
              <uix:link destinationBinding="sDest@servletRequest" textBinding="SERVER@applyBundle@servletRequest"/>
            </uix:subTabBar>
            <uix:spacer height="6"/>
            <uix:spacer height="10" width="40"/>
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="center">
                  <uix:tableLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="STATE@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="10"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="stateReader@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
					<uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="SID_READER@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
					  <db:link destinationBinding="SIDUrl@defaultBean@servletRequest"
                         copyParams="type,target"
							shortDescBinding="SID_READER@applyBundle@servletRequest"
                         textBinding="SID@defaultBean@servletRequest" />                        
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="TOT_MSG_DQD@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="totMsgsDeqd@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="DQ_TIME@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="deqTime@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="DQ_MSG_NO@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="deqMsgNo@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="DQ_MSG_CREATETIME@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="deqMsgCrtTime@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="SGA_USED@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="sgaUsed@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <% 
      
      if(!dbVersion.equals("9i")) 
      {
%>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="LAST_BRW_SCN@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="lastBrwSCN@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="OLDEST_SCN@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="oldestSCN@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="LAST_BRW_SEQ_NO@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="lastBrwSeqNo@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="LAST_DQ_SEQ_NO@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="lastDeqSeqNo@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="TOT_MSG_SPILLED@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="totMsgsSpilled@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="SPILL_LWM_SCN@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="spillLwmSCN@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="OLDEST_TXNID@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="oldestTxnid@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <% 
      }
%>

<%---------------------------------------------------------------------------------------------------------------%>

					<uix:rowLayout width="100%" renderedBinding="ShowCCA@servletRequest">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="MODE@captureBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="Mode@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

					
					<uix:rowLayout width="100%" renderedBinding="ShowCCA@servletRequest">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="PROXY_SID@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
<%-- <uix:styledText styleClass="OraDataText" textBinding="proxySID@defaultBean@servletRequest"/>
--%>
			<db:link destinationBinding="proxySIDUrl@defaultBean@servletRequest"
                         copyParams="type,target"
			 shortDescBinding="SESSION_DETAILS@streamsMsgs@servletRequest"
                         textBinding="proxySID@defaultBean@servletRequest" />

                      </uix:cellFormat>
                    </uix:rowLayout>

					<uix:rowLayout width="100%" renderedBinding="ShowCCA@servletRequest">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="PROXY_SERIAL@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="proxySerial@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>


					<uix:rowLayout width="100%" renderedBinding="ShowCCA@servletRequest">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="PROXY_SPID@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="proxySPID@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

					<uix:rowLayout width="100%" renderedBinding="ShowCCA@servletRequest">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="CAPTURE_BYTES_RECEIVED@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="captureBytesRecd@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="ELAP_DQ_TIME@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="elapDeqTime@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_SCH_TIME@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="elapSchTime@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
<% 
      if(!dbVersion.equals("9i")) 
      {
%>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText styleClass="OraInstructionText" textBinding="ELAP_SPILL_TIME@applyBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="center">
                        <uix:spacer height="10" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" textBinding="elapsedSpillTime@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
<% 
     }
%>

<%---------------------------------------------------------------------------------------------------------------%>

                  </uix:tableLayout>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat width="80%" hAlign="left">
                        <oem:chart shadowEffect="shadow" shortDescBinding="READER_CHART_INFO@applyBundle@servletRequest" titleBinding="READER_STATS@applyBundle@servletRequest" chartType="timeSeriesChart" yAxisLabelBinding="NUM_MSGS@applyBundle@servletRequest" xAxisLabelBinding="TIME@applyBundle@servletRequest" legendVisible="external" width="300" height="220" orientation="vertical">
                          <oem:sqlChartDataSource sqlPreparedStatementBinding="readerChartDataSource@defaultBean@servletRequest"/>
                          <oem:chartColumn displayLabelBinding="TOT_MSG_DQD@applyBundle@servletRequest" sourceIndex="0" itemColor="#9999FF"/>
                          <oem:chartColumn isTimeColumn="true" displayLabelBinding="TIME@applyBundle@servletRequest" sourceIndex="1"/>
                        </oem:chart>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
<%---------------------------------------------------------------------------------------------------------------%>

<%
if (dbVersion != null && dbVersion.equals("102g") || dbVersion.equals("11g"))
{
%>

	<uix:rawText>
              <a name="TXNLIST" id="TXNLIST"/>         
        </uix:rawText>

        <uix:spacer  height="10" />

        <uix:header textBinding="SPILL_TXN_LIST@applyBundle@servletRequest" >

        <uix:spacer  height="5" />
	<uix:messageStyledText styleClass="OraInstructionText" textBinding="SPILL_TXN_LIST_INFO@applyBundle@servletRequest"/>

        <uix:spacer  height="5" />
	    <uix:rowLayout>

	<uix:dataScope currentDataBinding="spillTxnList@defaultBean@servletRequest">

			<uix:table name="spillTxnList" id="spillTxnList" 
			        alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="100%" 
				tableDataBinding="rowData" valueBinding="startIndex"
				maxValueBinding="numRows"  minValue="1" 
				blockSizeBinding="blockSize" partialRenderMode="true"
				summaryBinding="SPILL_TXN_LIST_INFO@applyBundle@servletRequest" 
				shortDescBinding="SPILL_TXN_LIST_INFO@applyBundle@servletRequest" >
				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="TXN_ID@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="15%"/>
					<uix:text textBinding="txnID" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="FIRST_SCN@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
					<uix:text textBinding="firstSCN" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="MSG_CNT@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
					<uix:text textBinding="msgCnt" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="FIRST_MSG_CREATE_TIME@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
					<uix:text textBinding="msgCreate" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SPILL_CREATE_TIME@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="spillCreate" />
				</uix:column>

				<uix:tableSelection >
					<uix:singleSelection shortDescBinding="SELECT@dbBundle@servletRequest"  renderedBinding="allowTxnDetails@servletRequest">
					 <uix:submitButton textBinding="VIEW_TXN_DETAIL@streamsMsgs@servletRequest" 
			 shortDescBinding="VIEW_TXN_DETAIL@streamsMsgs@servletRequest" 				name="event" value="viewSpilledTxnDetails"
			 renderedBinding="allowTxnDetails@servletRequest"/>
					</uix:singleSelection>
				</uix:tableSelection>

			</uix:table>
	</uix:dataScope >

            </uix:rowLayout>

</uix:header>

<%
}
%>
          </uix:subTabLayout>
  </uix:contents>
 </uix:subTabLayout>
  <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                        
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
