<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import='oracle.sysman.emSDK.chart.SimpleChartDataSource' %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement" %>
<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
        <uix:case name="true">
            <uix:rawText>
				<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
            </uix:rawText>
        </uix:case>
    </uix:switcher>
      
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
        </uix:metaContainer>

        <uix:body>

            <db:form name="queueStatsForm" method="get" destination="/console/database/dist/streams/apply" copyParams="target,type,applyName">
                <uix:formValue name="pageName" value="/database/dist/streams/apply/server"/>
                <uix:formValue name="target" valueBinding="targetDB@servletRequest"/>
                <uix:pageLayout titleBinding="TITLE@servletRequest">
                    <%@ include file="/database/global.jspf" %>
					 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>
      <uix:contents>

                    <!-- main contents -->

                    <uix:tableLayout width="100%">
                        <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:tableLayout width="100%">
                                    <uix:rowLayout>                                      
                                        <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                            <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@applyBundle@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@applyBundle@servletRequest" shortDescBinding="REFRESH@applyBundle@servletRequest" name="event" value="refreshStatistics"/>

                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="5" width="10"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout hAlign="right">
                                        <uix:cellFormat hAlign="right">
                                            <uix:rowLayout>

                                                <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@applyBundle@servletRequest" labeledNodeId="refreshHome"/>
                                                <uix:spacer height="5" width="10"/>
                                                <uix:choice name="refreshHome" id="refreshHome"
                                                    onChange="submitForm('queueStatsForm', true, {'event':'refreshStatistics'})"
                                                    selectedValueBinding="refreshHomeSelected@servletRequest">
                                                    <uix:option textBinding="MANUALLY@applyBundle@servletRequest"
                                                    value="RT_MAN"/>
                                                    <uix:option textBinding="AUTOMATIC@applyBundle@servletRequest"
                                                    value="RT_60"/>
                                                </uix:choice>
                                            </uix:rowLayout>                                          
                                        </uix:cellFormat>                                      
                                    </uix:rowLayout>                                  
                                </uix:tableLayout>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:spacer height="10" width="10"/>

                    <uix:subTabLayout>
                        <uix:subTabs>
                            <uix:subTabBar selectedIndex="3">

                                <uix:link destinationBinding="qDest@servletRequest" textBinding="QUEUE@applyBundle@servletRequest"/>
                                <uix:link destinationBinding="rDest@servletRequest" textBinding="READER@applyBundle@servletRequest"/>
                                <uix:link destinationBinding="cDest@servletRequest" textBinding="COORDINATOR@applyBundle@servletRequest"/>
                                <uix:link destinationBinding="sDest@servletRequest" textBinding="SERVER@applyBundle@servletRequest"/>

                            </uix:subTabBar>
                        </uix:subTabs>

                        <uix:spacer height="10" width="10"/>

				
                        <uix:spacer height="20" />
                        <oem:table name="dataSource" width="100%" blockSize="5" beanKey="defaultBean"   alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
                            formSubmitted="true" shortDescBinding="SERVER_TABLE_INFO@applyBundle@servletRequest" summaryBinding="SERVER_TABLE_INFO@applyBundle@servletRequest"  dataSourceProp="dataSource" >
                            <uix:tableSelection>
                                <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbBundle@servletRequest">

                                    <uix:submitButton textBinding="VIEW_DET@applyBundle@servletRequest" shortDescBinding="VIEW_DET@applyBundle@servletRequest" name="event" value="applyServerDetails"/>

                                </uix:singleSelection>
                            </uix:tableSelection>
                        </oem:table>
                        <uix:spacer height="20" />

                    </uix:subTabLayout>

  </uix:contents>
 </uix:subTabLayout>
   <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 

                </uix:pageLayout>

            </db:form>

        </uix:body>

    </uix:document>

</uix:renderingContext>


