<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%  
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("sBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  
        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>          
            <uix:body>              
                <uix:form name="form0">                  
                    <uix:pageLayout titleBinding="TITLE@servletRequest">
                      <%@ include file="/database/global.jspf" %>
                      <!-- main contents -->
                        <uix:subTabLayout>
                        <%@ include file="/database/dist/streams/repTab.jspf" %>
                         
                         <uix:contents>
                                    <!-- Define the content of the page here -->
                                               
                            <uix:header textBinding="GENERAL@applyBundle@servletRequest">                              
                                <uix:tableLayout>                                  
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NAME@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="applyName@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="QUEUE@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="queueName@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="QUEUE_SCHEMA@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="queueSchema@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                 
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="STATUS@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                     
                                                        <uix:styledText styleClass="OraDataText" textBinding="status@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                 
                                                </uix:rowLayout>

                                                <uix:rowLayout width="100%"> 
                                                    <uix:cellFormat hAlign="right"> 
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="STATE@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/> 
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left"> 
                                                        <uix:styledText styleClass="OraDataText" textBinding="applyState@defaultBean@servletRequest"/> 
                                                    </uix:cellFormat> 
                                                </uix:rowLayout>


												<uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="PVERULESET_NAME@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:link destinationBinding="POSLINK@servletRequest" styleClass="OraLinkText" textBinding="pveRulesetName@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="PVERULESET_OWNER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="pveRulesetOwner@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NVERULESET_NAME@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:link destinationBinding="NEGLINK@servletRequest" styleClass="OraLinkText" textBinding="nveRulesetName@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                 
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="NVERULESET_OWNER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                     
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="nveRulesetOwner@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="PRECOMMIT_HANDLER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText destinationBinding="PCLINK@servletRequest" styleClass="OraLinkText" textBinding="preCommitHandler@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="DDL_HANDLER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                     
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText destinationBinding="DDLINK@servletRequest" styleClass="OraLinkText" textBinding="ddlHandler@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="MESSAGE_HANDLER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                     
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:link destinationBinding="MSGLINK@servletRequest" styleClass="OraLinkText" textBinding="messageHandler@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="ERROR_NUMBER@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                     
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="errorNumber@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_CAPTURED@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="applyCaptured@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_TAG@applyBundle@servletRequest"/>                                                     
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText destinationBinding="TAGLINK@servletRequest" styleClass="OraLinkText" textBinding="applyTag@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                  
                                                </uix:rowLayout>
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="MAX_APPLIED_MSG_NO@applyBundle@servletRequest"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">                                                      
                                                        <uix:spacer height="10" width="5"/>                                                      
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left">                                                      
                                                        <uix:styledText styleClass="OraDataText" textBinding="maxApplMsgNo@defaultBean@servletRequest"/>                                                      
                                                    </uix:cellFormat>                                                 
                                                </uix:rowLayout>                                              
                                                <uix:rowLayout width="100%">                                                  
                                                    <uix:cellFormat hAlign="right">                                                      
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="SRDB@applyBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="center">
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat hAlign="left"> 
                                                        <uix:styledText styleClass="OraDataText" textBinding="srcDBName@defaultBean@servletRequest"/> 
                                                    </uix:cellFormat> 
                                                </uix:rowLayout> 

                                </uix:tableLayout>
                            </uix:header>
                            <uix:header textBinding="OBJECTS@applyBundle@servletRequest" shortDescBinding="OBJECTS@applyBundle@servletRequest">
                                <uix:formValue name="applyName" valueBinding="applyName@defaultBean@servletRequest" />
                                <uix:tableLayout>                                  
                                    <uix:rowLayout>                                     
                                        <uix:cellFormat>                                          
                                            <uix:styledText styleClass="OraInstructionText" textBinding="SEARCH@applyBundle@servletRequest" labeledNodeIdBinding="search_options" />
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                          <uix:spacer height="3" width="3" />                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat>

                                            <uix:choice name="search_options" selectedValueBinding="searchType@servletRequest" onChange="submitForm('form0', true, {'event':'viewType'})" shortDescBinding="SELECT@dbBundle@servletRequest" id="search_options">
                                                <uix:option textBinding="RULE_TYPE@applyBundle@servletRequest" value="Rule Type" shortDescBinding="RULE_TYPE@applyBundle@servletRequest" />
                                                <uix:option textBinding="CHANGE_TYPE@applyBundle@servletRequest" value="Change Type"  shortDescBinding="CHANGE_TYPE@applyBundle@servletRequest" />
                                                <uix:option textBinding="PVERULESET@applyBundle@servletRequest" value="Positive Rule Set"  shortDescBinding="PVERULESET@applyBundle@servletRequest"/>
                                                <uix:option textBinding="NVERULESET@applyBundle@servletRequest" value="Negative Rule Set"  shortDescBinding="NVERULESET@applyBundle@servletRequest"/>
                                            </uix:choice>                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer height="3" width="3"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>                                          
                                            <uix:switcher childNameBinding="searchType@servletRequest">
                                              <uix:case name="Positive Rule Set">
                                                <uix:textInput columns="10" name="search_string" maximumLength="25" />
                                              </uix:case>
                                              <uix:case name="Negative Rule Set">
                                                <uix:textInput columns="10" name="search_string" maximumLength="25"/>
                                              </uix:case>
                                              <uix:case name="Rule Type">
                                                <uix:choice name="search_string" selectedValueBinding="searchStr@servletRequest" shortDescBinding="SELECT@dbBundle@servletRequest" >
                                                  <uix:contents childDataBinding="searchStrings@defaultBean@servletRequest">
                                                    <uix:option textBinding="textKey" valueBinding="valueKey" shortDescBinding="textKey" />
                                                  </uix:contents>
                                                </uix:choice>
                                              </uix:case>
                                              <uix:case name="Change Type" >
                                                <uix:choice name="search_string" selectedValueBinding="searchStr@servletRequest" shortDescBinding="SELECT@dbBundle@servletRequest" >
                                                  <uix:contents childDataBinding="searchStrings@defaultBean@servletRequest">
                                                    <uix:option textBinding="textKey" valueBinding="valueKey" shortDescBinding="textKey" />
                                                  </uix:contents>
                                                </uix:choice>
                                              </uix:case>
                                            </uix:switcher>
                                        </uix:cellFormat>
                                        <uix:cellFormat>                                          
                                            <uix:spacer height="3" width="3"/>                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat>                                          
                                            <uix:submitButton textBinding="GO@applyBundle@servletRequest" shortDescBinding="GO@applyBundle@servletRequest" name="event" value="filterData" />                                          
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:spacer height="20" width="10"/>                                  
                                </uix:tableLayout>
                                <uix:spacer height="15" width="1"/>

				  <oem:table name="dataSource" width="100%" blockSize="5" beanKey="defaultBean"   alternateTextBinding="NO_SEARCH_DONE@sBundle@servletRequest"
         				formSubmitted="true" summaryBinding="DETAILS_TABLE_INFO@applyaBundle@servletRequest" shortDescBinding="DETAILS_TABLE_INFO@applyBundle@servletRequest"    dataSourceProp="dataSource" copyParams="search_string" />
                                <uix:spacer height="20" width="10"/>
                                <uix:tableLayout>                                  
                                    <uix:rowLayout>                                      
                                        <uix:cellFormat>                                          
                                            <uix:tip/>                                          
                                        </uix:cellFormat>
                                        <uix:cellFormat>                                          
                                            <uix:styledText styleClass="OraTipText" textBinding="SAME_CONDITION_MSG@sBundle@servletRequest"/>                                          
                                        </uix:cellFormat>                                      
                                    </uix:rowLayout>                                  
                                </uix:tableLayout>
                                <uix:spacer height="20" width="10"/>                              
                            </uix:header>
                            <uix:spacer height="10" width="10"/>  
                          </uix:contents>
                        </uix:subTabLayout>
                            <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
                    </uix:pageLayout>                  
                </uix:form>              
            </uix:body>          
        </uix:document>
        </uix:renderingContext>





