<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document>   
    <uix:metaContainer>
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:dataScope currentDataBinding="LCRList@servletRequest">
         <db:form name="errorLCRs" method="post" destination="/console/database/dist/streams/apply" copyParams="target,type">
	<uix:formValue name="applyName" valueBinding="applyName@servletRequest"/>
  <uix:formValue name="pageName" value="/database/dist/streams/apply/viewLCRs"/>
  

            <uix:body>

                  <uix:pageLayout titleBinding="TITLE@servletRequest">
			<%@ include file="/database/global.jspf" %>

                      <!-- main contents -->
			<uix:switcher childNameBinding="display@servletRequest">
			 <uix:case name="info">
			  <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                              textBinding="CONFIRMATION@applyBundle@servletRequest"/>
			      <uix:spacer height="10" width="5"/>
			 </uix:case>
			 <uix:case name="error">
			  <uix:messageBox messageBinding="FAIL@servletRequest"    messageType="error"
                              textBinding="EXCEPTION@applyBundle@servletRequest"/>
			<uix:spacer height="10" width="5"/>

			 </uix:case>
			 </uix:switcher>

			<uix:header textBinding="VIEW_LCR@applyBundle@servletRequest">
			 <uix:spacer height="10" width="5"/>
			 <uix:table name="LCRList" id="errorList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
				formSubmitted="true" width="90%" tableDataBinding="rowData" valueBinding="startIndex"
				maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" shortDescBinding="VIEWLCR_TABLE_INFO@applyBundle@servletRequest"
				summaryBinding="VIEWLCR_TABLE_INFO@applyBundle@servletRequest" >

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="MSGNO@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
					<uix:text textBinding="msgNum" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="SRDB@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="30%"/>
					<uix:text textBinding="srcDB" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OBJECT_NAME@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="objName" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OWNER@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="20%"/>
					<uix:text textBinding="owner" />
				</uix:column>



				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="OPER_TYPE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="25%"/>
					<uix:text textBinding="operationType" />
				</uix:column>

				<uix:column>
					<uix:columnHeader>
					<uix:sortableHeader textBinding="LCR_TYPE@applyBundle@servletRequest" sortable="true"/>
					</uix:columnHeader>
					<uix:columnFormat columnDataFormat="textFormat" width="10%"/>
					<uix:text textBinding="lcrType" />
				</uix:column>

				<uix:tableSelection>
					<uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbBundle@servletRequest">
					
					        <uix:submitButton shortDescBinding="COMPARE_VALUES@applyBundle@servletRequest" textBinding="COMPARE_VALUES@applyBundle@servletRequest" name="event" value="compareColValues"/>
					 </uix:singleSelection>
				</uix:tableSelection>

			</uix:table>
			</uix:header>
			 
		      <!-- navigation -->
                      <uix:tabs/>
                    </uix:pageLayout>

            </uix:body>

	    </db:form>
</uix:dataScope>
        </uix:document>
     </uix:renderingContext>

