<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg"%>
<% 
request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
      <uix:body>
     
     <uix:dataScope currentDataBinding="paramsList@servletRequest">
     <db:form name="EditCaptureParamsForm" method="POST" destination="/console/database/dist/streams/capture" copyParams="target,type, otype,objectType,sname, oname">
     <uix:formValue name="pageName" value="/database/dist/streams/capture/editCaptureParams" />
     <uix:formValue name="showFirstSCNValue" valueBinding="showFirstSCNValue@servletRequest" />
     <uix:formValue name="captureName" valueBinding="captureName@servletRequest" />
     <uix:pageLayout  titleBinding="pageTitle@servletRequest">
     
     <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
     <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
    
    <%----%>
      <%@ include file="/database/global.jspf" %>       
      <uix:metaContainer>
         <!-- Set the page title -->
         <uix:head titleBinding="pageTitle@servletRequest"/>
     </uix:metaContainer>
         <uix:header textBinding="PARAMETERS@captureBundle@servletRequest">
          <uix:tableLayout width="70%">
          <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="center">
          <uix:submitButton name="event" value="restore_default" textBinding="RESTORE_DEFAULTS@captureBundle@servletRequest" shortDescBinding="RESTORE_DEFAULTS@captureBundle@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="3" />
         <!-- table starts here -->
         <uix:table name="paramsList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest"
                formSubmitted="true" width="70%" tableDataBinding="rowData" valueBinding="startIndex"
                maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize"
                summaryBinding="PARAMS_TABLE_DESC@captureBundle@servletRequest"
                shortDescBinding="PARAMS_TABLE_SUMM@captureBundle@servletRequest" >

               <uix:column>
                     <uix:columnHeader>
                         <uix:sortableHeader textBinding="NAME@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="60%"/>
                     <uix:text  textBinding="paramNameIndex"  />
               </uix:column>

               <uix:column>
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="VALUE@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                     <uix:textInput name="paramValueIndex" textBinding="paramValueIndex" shortDescBinding="VALUE@captureBundle@servletRequest" />
               </uix:column>

               <uix:column>
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="SETBYUSER@captureBundle@servletRequest" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                     <uix:text textBinding="paramSetbyIndex" />
               </uix:column>

          </uix:table>
          
         </uix:header>

	   <uix:header textBinding="CHECKPOINT_RETENTION_TIME@captureBundle@servletRequest">
	       <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat/>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
				<uix:rowLayout>
                  <uix:cellFormat columnSpan="3">
                   <uix:styledText styleClass="OraInstructionText" textBinding="CHKPT_RETN_TIME_INFO@captureBundle@servletRequest" labeledNodeId="chkptRetn" />
                  </uix:cellFormat>
                 </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right"  width="20%" >
                   <uix:styledText styleClass="OraInstructionText" textBinding="CHKPT_RETN_TIME@captureBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat  width="1%" >
                    <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:textInput columns="10" name="chkptRetn" id="chkptRetn" textBinding="chkptRetn" shortDescBinding="CHKPT_RETN_TIME@captureBundle@servletRequest" />
                  </uix:cellFormat>
                </uix:rowLayout>
				  <uix:rowLayout>
                  <uix:cellFormat/>
                  <uix:cellFormat>
                    <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
		</uix:tableLayout>    
	   </uix:header>

	   <uix:header textBinding="START_SCN@captureBundle@servletRequest">
	       <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat/>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
				<uix:rowLayout>
                  <uix:cellFormat columnSpan="3">
                   <uix:styledText styleClass="OraInstructionText" textBinding="STARTSCN_INFO@captureBundle@servletRequest" labeledNodeId="startSCN" />
                  </uix:cellFormat>
                 </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right"  width="20%" >
                   <uix:styledText styleClass="OraInstructionText" textBinding="START_SCN@captureBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat  width="1%" >
                    <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:textInput columns="10" name="startSCN" id="startSCN" textBinding="startSCN" shortDescBinding="START_SCN@captureBundle@servletRequest" />
                  </uix:cellFormat>
                </uix:rowLayout>
				  <uix:rowLayout>
                  <uix:cellFormat/>
                  <uix:cellFormat>
                    <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
		</uix:tableLayout>    
	   </uix:header>



        <uix:hideShowHeader textBinding="FIRST_SCN@captureBundle@servletRequest" disclosedBinding="showFirstSCN@servletRequest" formSubmitted="true" id="firstscnHS">
              <uix:spacer height="30" width="0" />
              <!-- Define the content of the page here -->
              
                 <uix:styledText styleClass="OraInstructionText" textBinding="FIRSTSCN_INFO@captureBundle@servletRequest"/>
               
              <uix:spacer height="10" width="30"/>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat/>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInstructionText" textBinding="APPLIED_SCN@captureBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText textBinding="appliedSCN" styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInstructionText" textBinding="REQ_CHKPT_SCN@captureBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer height="30" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText textBinding="reqCheckPointSCN" styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInstructionText" labeledNodeId="firstSCN" textBinding="FIRST_SCN@captureBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:textInput columns="10" name="firstSCN" id="firstSCN" shortDescBinding="FIRST_SCN@captureBundle@servletRequest" textBinding="firstSCN"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraInlineErrorText" textBinding="FIRSTSCNERROR@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <% 
      }
%>
                
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer height="10" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraInlineErrorText" textBinding="FIRSTSCNERROR@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:hideShowHeader>
            <uix:pageButtons>
              <uix:flowLayout>
                <uix:pageButtonBar>
				 <uix:button textBinding="CANCEL@captureBundle@servletRequest" destinationBinding="CAPTUREDEST@servletRequest" shortDescBinding="CANCEL@captureBundle@servletRequest"/>
                  <uix:submitButton name="event" value="revert" textBinding="REVERT@dbBundle@servletRequest" shortDescBinding="REVERT@dbBundle@servletRequest"/>
                  <uix:submitButton name="event" value="apply_params" textBinding="APPLY@dbBundle@servletRequest" shortDescBinding="APPLY@dbBundle@servletRequest"/>
                </uix:pageButtonBar>
              </uix:flowLayout>
            </uix:pageButtons>
             <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
          </uix:pageLayout>
        </db:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>
