<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
  <%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<% 
    request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
    request.setAttribute("sBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
    String dbVersion = (String)request.getAttribute("DBVERSION");
    request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
	 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:document>
      <uix:metaContainer>
        <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
      </uix:metaContainer>
      <uix:pageLayout titleBinding="title@defaultBean@servletRequest" styleClass="OraInstructionText">
        <%@ include file="/database/global.jspf"%>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <db:form method="post" name="viewdetform" destinationBinding="goBinding@servletRequest" copyParams="target,type">
         <uix:subTabLayout>
	   <%@ include file="/database/dist/streams/repTab.jspf" %>
          <uix:contents>
          <uix:tableLayout width="90%">
            <uix:rowLayout>
              <uix:cellFormat width="50%">
                <uix:tableLayout hAlign="left" width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="GENERAL@captureBundle@servletRequest">
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left"/>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="NAME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="captureName@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="QUEUE@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="queueName@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="QUEUE_SCHEMA@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="queueSchema@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="STATUS@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraDataText" textBinding="status@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      
      if(!dbVersion.equals("9i"))
      {
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="ERROR_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="errorno@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="STATUS_CHANGE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="statusChangeTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
			  <uix:rowLayout>
			     <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="VERSION@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">          
			    <uix:styledText styleClass="OraDataText" textBinding="version@defaultBean@servletRequest"/>
                            </uix:cellFormat>
			  </uix:rowLayout>
                          <% 
      }
%>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="RULES@captureBundle@servletRequest">
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                            <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                              <uix:styledText styleClass="OraInstructionText" textBinding="POSITIVE_RULE_SET@captureBundle@servletRequest"/>
       <% 
      }
      else
      {
%>                       
                              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_NAME@sBundle@servletRequest"/>
<% 
      }
%>                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="POSLINK@servletRequest" styleClass="OraLinkText" textBinding="pveRuleSetName@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                            <%
                            if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                              <uix:styledText styleClass="OraInstructionText" textBinding="POSITIVE_RULE_SET_OWNER@captureBundle@servletRequest"/>
       <% 
      }
      else
      {
%>                       
                              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_OWNER@sBundle@servletRequest"/>
<% 
      }
%>         
                              
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="pveRuleSetOwner@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="NEGATIVE_RULE_SET@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="NEGLINK@servletRequest" styleClass="OraLinkText" textBinding="nveRuleSetName@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="NEGATIVE_RULE_SET_OWNER@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="nveRuleSetOwner@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      }
%>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                    <uix:cellFormat>
                      <uix:spacer height="10" width="10"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="DATABASE@captureBundle@servletRequest">
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="SRC_DB@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="srcDb@defaultBean@servletRequest"/>
                            </uix:cellFormat>

                          </uix:rowLayout>
                          <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="SRC_DB_ID@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="srcDbID@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="CAPTURE_TYPE@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="captureType@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="USE_DB_LINK@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="useDbLink@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="LOGFILE_ASSG@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="logFileAssg@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="LOG_MINER_ID@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="logMinerID@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
			   <uix:rowLayout width="100%"  renderedBinding="GT102">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="CHKPT_RETN_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
							<uix:link destinationBinding="firstSCNURL@servletRequest" styleClass="OraLinkText" textBinding="chkptRetnTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
			  
						
						 
                        </uix:tableLayout>
                      </uix:header>
                      <%                       
       } 
%>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top">
                      <uix:header textBinding="SCN@captureBundle@servletRequest">
                        <uix:tableLayout>
                          <uix:rowLayout hAlign="left">
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:contents/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="FIRST_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="firstSCNURL@servletRequest" styleClass="OraLinkText" textBinding="firstSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      }
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="START_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="firstSCNURL@servletRequest" styleClass="OraLinkText" textBinding="startSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="CAPTURED_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="capturedSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="APPLIED_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="appliedSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <% 
      
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="MAX_CHKPT_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="maxChkptSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout width="100%">
                            <uix:cellFormat hAlign="right">
                              <uix:styledText styleClass="OraInstructionText" textBinding="REQ_CHKPT_SCN@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center">
                              <uix:spacer height="10" width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraDataText" textBinding="reqChkptSCN@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
			  <uix:rowLayout>                             
			    <uix:cellFormat hAlign="right">
                                <uix:styledText textBinding="LAST_ENQUEUED_SCN@captureBundle@servletRequest" styleClass="OraInstructionText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
			    </uix:cellFormat>
                            <uix:cellFormat>                                 
			    <uix:styledText textBinding="lastEnqSCN@defaultBean@servletRequest" styleClass="OraDataText"/>
                            </uix:cellFormat>
                        </uix:rowLayout> 
                          <% 
      }
%>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:header textBinding="OBJECTS@captureBundle@servletRequest">
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText textBinding="SEARCH@sBundle@servletRequest" styleClass="OraInstructionText"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer height="3" width="3"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:formValue name="captureName" valueBinding="captureName@defaultBean@servletRequest"/>
                        <uix:choice name="searchType" selectedValueBinding="searchType@servletRequest" onChange="submitForm('viewdetform', true, {'event':'viewType'})">
                          <uix:option textBinding="RULE_TYPE@captureBundle@servletRequest" value="RULE_TYPE"/>
                          <uix:option textBinding="CHANGE_TYPE@captureBundle@servletRequest" value="CHANGE_TYPE"/>
                          <% 
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                          <uix:option textBinding="PVE@captureBundle@servletRequest" value="PVE"/>
                          <uix:option textBinding="NVE@captureBundle@servletRequest" value="NVE"/>
                          <% 
      }
      else
      {
%>
                          <uix:option textBinding="RULE_NAME@captureBundle@servletRequest" value="PVE"/>
                          <% 
      }
%>
                        </uix:choice>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer height="3" width="3"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:switcher childNameBinding="searchType@servletRequest">
                          <uix:case name="PVE">
                            <uix:textInput columns="10" name="searchString" maximumLength="25"/>
                          </uix:case>
                          <uix:case name="NVE">
                            <uix:textInput columns="10" name="searchString" maximumLength="25"/>
                          </uix:case>
                          <uix:case name="RULE_TYPE">
                            <uix:choice name="searchString" selectedValueBinding="searchStr@servletRequest">
                              <uix:contents childDataBinding="searchStrings@defaultBean@servletRequest">
                                <uix:option textBinding="textKey" valueBinding="valueKey"/>
                              </uix:contents>
                            </uix:choice>
                          </uix:case>
                          <uix:case name="CHANGE_TYPE">
                            <uix:choice name="searchString" selectedValueBinding="searchStr@servletRequest">
                              <uix:contents childDataBinding="searchStrings@defaultBean@servletRequest">
                                <uix:option textBinding="textKey" valueBinding="valueKey"/>
                              </uix:contents>
                            </uix:choice>
                          </uix:case>
                        </uix:switcher>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer height="3" width="3"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:submitButton textBinding="GO@captureBundle@servletRequest" shortDescBinding="GO@captureBundle@servletRequest" name="event" value="GO"/>
                      </uix:cellFormat>
                      <uix:cellFormat/>
                      <uix:cellFormat/>
                    </uix:rowLayout>
                    <uix:rowLayout/>
                    <uix:spacer height="20" width="10"/>
                  </uix:tableLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="OBJECTS_INFO@captureBundle@servletRequest"/>
                  <uix:spacer height="15" width="15"/>
                  <oem:table name="dataSource" width="100%" blockSize="5" formSubmitted="true" summary="OBJECTS_INFO@captureBundle@servletRequest" beanKey="defaultBean" dataSourceProp="dataSource" alternateTextBinding="NO_SEARCH_DONE@sBundle@servletRequest"/>
                  <% 
      if(dbVersion.equals("10g") || dbVersion.equals("102g") || dbVersion.equals("112"))
      {
%>
                  <uix:spacer height="20" width="10"/>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:tip/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraTipText" textBinding="SAME_CONDITION_MSG@sBundle@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                  <uix:spacer height="2" width="10"/>
                </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <% 
      }
%>
          </uix:contents>
         </uix:subTabLayout>
         <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
        </db:form>

      </uix:pageLayout>
    </uix:document>
  </uix:renderingContext>
