<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="java.text.NumberFormat"%>
<%@ page import="oracle.sysman.emSDK.chart.SimpleChartDataSource"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.emo.dist.streams.capture.CaptureSQLList"%>
<%  
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
  request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));
  request.setAttribute("streamsMsgs", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
  request.setAttribute("setupBundle", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");

%>
<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
            <uix:case name="true">
                <uix:rawText>
					<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
				</uix:rawText>
            </uix:case>
        </uix:switcher>
        <uix:metaContainer>
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
        </uix:metaContainer>
        <db:form name="captureStatsForm" method="get" destination="/console/database/dist/streams/capture" copyParams="target,type,captureName">
            <uix:formValue name="pageName" value="/database/dist/streams/capture/viewCaptureStats"/>
            <uix:formValue name="target" valueBinding="targetDB@servletRequest"/>
            <uix:pageLayout titleBinding="title@defaultBean@servletRequest" styleClass="OraInstructionText">
                <%@ include file="/database/global.jspf"%>
     <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>
        
                <uix:tableLayout width="100%">
                    <uix:rowLayout width="100%">
                        <uix:cellFormat hAlign="right" vAlign="top">
                            <uix:tableLayout width="100%">
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                        <uix:spacer height="5" width="10"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                        <uix:styledText styleClass="OraTipText" textBinding="LAST_REFRESH@dbMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:submitButton textBinding="REFRESH@captureBundle@servletRequest" name="event" value="refreshStatistics"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                        <uix:spacer height="5" width="10"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout hAlign="right">
                                    <uix:cellFormat hAlign="right">
                                        <uix:rowLayout>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@captureBundle@servletRequest" labeledNodeId="ViewLabel" />
                                            <uix:spacer height="5" width="10"/>
                                            <uix:choice name="refreshHome" id="ViewLabel" onChange="submitForm('captureStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                                                <uix:option textBinding="MANUALLY@captureBundle@servletRequest" value="RT_MAN"/>
                                                <uix:option textBinding="AUTOMATIC@captureBundle@servletRequest" value="RT_60"/>
                                            </uix:choice>
                                        </uix:rowLayout>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                        </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
                <uix:subTabLayout>
                    <uix:header>
                        <uix:tableLayout hAlign="left" width="76%">
                            <uix:rowLayout width="100%">
                <%  
      if(!dbVersion.equals("9i"))
      {          
%>
                                <uix:cellFormat hAlign="right">
                                    <oem:chart shadowEffect="3d" seriesSymbolsAutomatic="true" titleBinding="Q_STATS@captureBundle@servletRequest" chartType="timeSeriesChart" externalLegendOrientation="horizontal" legendPosition="south" yAxisLabelBinding="NOMSGS@captureBundle@servletRequest" xAxisLabelBinding="TIME@captureBundle@servletRequest" legendVisible="external" width="350" height="170" orientation="vertical">
                                    <oem:sqlChartDataSource sqlPreparedStatementBinding="queChartDataSource@defaultBean@servletRequest"/>
                                    <oem:chartColumn displayLabelBinding="NO_SPILLED_MSGS@captureBundle@servletRequest" sourceIndex="0" itemColor="#663366"/>
                                    <oem:chartColumn displayLabelBinding="NO_MSGS@captureBundle@servletRequest" sourceIndex="1" itemColor="#9999FF"/>
                                    <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="2"/>
                                    </oem:chart>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="center">
                                    <uix:spacer height="10" width="5"/>
                                </uix:cellFormat>
                <%  
      }
%>
                                <uix:cellFormat hAlign="left">
                                    <oem:chart shadowEffect="shadow" titleBinding="MSG_STATS@captureBundle@servletRequest" chartType="timeSeriesChart" externalLegendOrientation="horizontal" legendPosition="south" yAxisLabelBinding="NOMSGS@captureBundle@servletRequest" xAxisLabelBinding="TIME@captureBundle@servletRequest" legendVisible="external" width="350" height="170" orientation="vertical">
                                    <oem:sqlChartDataSource sqlPreparedStatementBinding="msgChartDataSource@defaultBean@servletRequest"/>
                                    <oem:chartColumn displayLabelBinding="TOTAL_MSGS_ENQD@captureBundle@servletRequest" sourceIndex="0" itemColor="#663366"/>
                                    <oem:chartColumn displayLabelBinding="TOTAL_MSGS_CAP@captureBundle@servletRequest" sourceIndex="1" itemColor="#9999FF"/>
                                    <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="2"/>
                                    </oem:chart>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:tableLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:contents/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                    </uix:header>
                    <uix:header textBinding="CAPTURE_STATS@captureBundle@servletRequest">
                        <uix:contents/>
                    </uix:header>
                    <uix:tableLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText textBinding="STATE@captureBundle@servletRequest" styleClass="OraInstructionText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText textBinding="state@defaultBean@servletRequest" styleClass="OraDataText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
<%-----------------------------------------------------------------------------------------%>

 
						<uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText textBinding="MODE@captureBundle@servletRequest" styleClass="OraInstructionText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText textBinding="Mode@servletRequest" styleClass="OraDataText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            
                            <uix:cellFormat hAlign="right">
								<uix:switcher childNameBinding="ShowApply@servletRequest">
									<uix:case name="TRUE">
										<uix:styledText styleClass="OraInstructionText" textBinding="APN@setupBundle@servletRequest"/>
									</uix:case>
									<uix:case name="FALSE">
										<uix:spacer height="10" width="10"/>
									</uix:case>
								</uix:switcher>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
								<uix:switcher childNameBinding="ShowApply@servletRequest">
									<uix:case name="TRUE">
								        <uix:styledText styleClass="OraDataText" textBinding="applyName@defaultBean@servletRequest"/>
									</uix:case>
									<uix:case name="FALSE">
										<uix:spacer height="10" width="10"/>
									</uix:case>
								</uix:switcher>
                            </uix:cellFormat>
                        </uix:rowLayout>

						
						<uix:rowLayout renderedBinding="ShowCCA@servletRequest">
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_DB_LINK@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="applyDBLink@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

						<uix:rowLayout renderedBinding="ShowCCA@servletRequest">
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_MSGS_SENT@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="applyMsgsSent@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

						<uix:rowLayout renderedBinding="ShowCCA@servletRequest">
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="APPLY_BYTES_SENT@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="applyBytesSent@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

						<uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
<%-----------------------------------------------------------------------------------------%>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="CAPTURE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="captureTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText textBinding="TOTAL_MSGS_CAP@captureBundle@servletRequest" styleClass="OraInstructionText"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText textBinding="totalMessagesCaptured@defaultBean@servletRequest" styleClass="OraDataText"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="CAP_MSG_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="capturedMessageNo@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraInstructionText" textBinding="CAP_MSG_CREATE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="capturedMessageCreateTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
            <%  
      
      if(!dbVersion.equals("9i"))
      {
%>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="AVAIL_MSG_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="availableMessageNo@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="AVAIL_MSG_CREATE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="availableMessageCreateTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
            <%  
      }
%>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ENQ_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="enqueueTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="TOTAL_MSGS_ENQD@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="totalMessageEnqd@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ENQD_MSG_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="enqdMessageNo@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ENQD_MSG_CREATE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="enqdMessageCreateTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="startupTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_CAP_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="elapCapTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_RULE_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="elapRulTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_LCR_TIME@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="elapLCRTime@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="SESSION_ID@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
<%--                                <uix:styledText styleClass="OraDataText" textBinding="sessionID@defaultBean@servletRequest"/>
--%>
				<db:link destinationBinding="sessionIDUrl@defaultBean@servletRequest"                          
					 copyParams="type,target"
					 shortDescBinding="SESSION_DETAILS@streamsMsgs@servletRequest"
                         		 textBinding="sessionID@defaultBean@servletRequest" /> 

                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="SERIAL_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="serialNo@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInstructionText" textBinding="CAPTURE_PROCESS_NO@captureBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:styledText styleClass="OraDataText" textBinding="captureProcessNo@defaultBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer height="10" width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:contents/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>

<%
if (dbVersion != null && !dbVersion.equals("9i") && !dbVersion.equals("10g") )
{
%>
	    <uix:include node="/database/dist/streams/activeTxnList.jsp" />
<% 
}
%>

<%
if (dbVersion != null && dbVersion.equals("112"))
{
%>
            <uix:spacer height="10" width="10"/>
 	    <%@ include file="/database/dist/streams/splitMerge.jspf" %> 
<% 
}
%>


                </uix:subTabLayout>

 </uix:subTabLayout>
 <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
            </uix:pageLayout>
        </db:form>
    </uix:document>
</uix:renderingContext>
