<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.rsc.streams.PerfAdvisorMsgID"%>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>



<uix:renderingContext id="renderingContext">
  <db:script src="/database/LOV.js"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="paMsgs" class="oracle.sysman.db.rsc.streams.PerfAdvisorMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>   

    <uix:document>
      <uix:metaContainer> <!--Set the page title -->
        <uix:head titleBinding="title@servletRequest"></uix:head>
      </uix:metaContainer>

      <uix:body>
        <db:form name="componentsListForm" method="post" 
				destination="/em/console/database/dist/streams/perfAdvisor" 
				copyParams="target,type">

          <uix:formValue name="pageName" value="/database/dist/streams/perfadv/componentsList"/>
          <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf" %>
            <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" 
							mainTextKey="mainText"/>
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" 
							mainTextKey="mainText"/>

		<!--main contents -->

			<uix:spacer height="10" width="10"/>
            <uix:messageStyledText textBinding="STREAMS_PERF_ADVISOR_TEXT@paMsgs" styleClass="OraInstructionText"/>
            <uix:spacer height="10" width="10"/>


            <uix:header textBinding="STREAMS_COMPONENTS@paMsgs">
				<uix:messageStyledText textBinding="COMPONENTS_LIST_TEXT@paMsgs" styleClass="OraInstructionText"/>
				<uix:spacer height="10" width="10"/>

			<uix:tableLayout width="100%">

				<uix:rowLayout hAlign="right">
				  <uix:contents>
					<uix:cellFormat>
					  <uix:contents>
						<uix:submitButton  textBinding="VIEW_ALL_DETAILS@paMsgs" shortDescBinding="VIEW_ALL_DETAILS@paMsgs" name="event" value="viewAllDetails"
						disabledBinding="viewAllDetailsDisabled@servletRequest" />
					  </uix:contents>
					</uix:cellFormat>
				  </uix:contents>
				</uix:rowLayout>
			  
			  
			  <uix:rowLayout width="100%">
              
              <!-- Table data begin -->
              <uix:dataScope currentDataBinding="componentsListBean@servletRequest">
                <uix:table name="componentsListTable" 
                    alternateTextBinding="NO_COMPONENTS_FOUND@paMsgs@servletRequest"
                    formSubmitted="true" 
                    width="100%" 
                    tableDataBinding="rowData" 
                    minValue="1" 
                    valueBinding="startIndex" 
                    blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                    maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                    shortDescBinding="COMPONENTS_LIST_TABLE@paMsgs"
                    summaryBinding="COMPONENTS_LIST_TABLE@paMsgs">
                    
                  <uix:tableFormat tableBanding="rowBanding"/>

				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="NAME@paMsgs" sortable="true"/>
					</uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="15%" />
                    <uix:messageStyledText textBinding="<%= PerfAdvisorMsgID.NAME %>" 
		    	promptBinding="ComponentName_TIP@componentsListBean@servletRequest"
			destinationBinding="ComponentName_URL@componentsListBean@servletRequest"/>
                  </uix:column>

				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="TYPE@paMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PerfAdvisorMsgID.TYPE %>" 
                               shortDescBinding="TYPE_TIP@componentsListBean@servletRequest" />
                  </uix:column>

				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="STREAMS_PATH_ID@paMsgs" sortable="true"/>
					</uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= PerfAdvisorMsgID.STREAMS_PATH_ID %>"/>
                  </uix:column>

				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="COMPONENT_DB@paMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:messageStyledText textBinding="<%= PerfAdvisorMsgID.COMPONENT_DB %>" 
		    promptBinding="ComponentDB_TIP@componentsListBean@servletRequest" />
                  </uix:column>
                  
				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="BOTTLENECK@paMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PerfAdvisorMsgID.BOTTLENECK %>" shortDescBinding="BOTTLENECK@paMsgs"/>
                  </uix:column>
                  
				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LATENCY@paMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= PerfAdvisorMsgID.LATENCY %>"
									destinationBinding="LATENCY_URL@componentsListBean@servletRequest" />
                  </uix:column>                  
                  
				  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="THROUGHPUT@paMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= PerfAdvisorMsgID.THROUGHPUT %>" 
									destinationBinding="THROUGHPUT_URL@componentsListBean@servletRequest" /> 
                  </uix:column>                  

				<uix:tableSelection>
					<uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@paMsgs">
						<uix:contents>
							<uix:submitButton textBinding ="VIEW_DETAILS@paMsgs" shortDescBinding="VIEW_DETAILS@paMsgs" name="event" value="viewDetails"/>
						</uix:contents>
					</uix:singleSelection>
				</uix:tableSelection>

				</uix:table>
                </uix:dataScope>
                <!-- Table data end -->

              </uix:rowLayout>


			
			<%-- hgrid begin 

				<uix:rowLayout hAlign="right">
				  <uix:contents>
					<uix:cellFormat>
					  <uix:contents>
			            <uix:spacer height="10" width="10"/>
					  </uix:contents>
					</uix:cellFormat>
				  </uix:contents>
				</uix:rowLayout>


				<uix:rowLayout hAlign="right">
				  <uix:contents>
					<uix:cellFormat>
					  <uix:contents>

             <uix:hGrid id="availablepolicies"
                    width="100%"
                    formSubmitted="true"
                    partialRenderMode="self"
                    treeDataBinding="availablepolicies_tree@servletRequest"
                    columnHeaderDataBinding="availablepolicies_chead@servletRequest"
                    columnFormatsBinding="availablepolicies_cfmt@servletRequest"
                    proxyBinding="availablepolicies_proxy@servletRequest"
                    alternateText="Some alternate text">

                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader text="Stream Path ID"
                          sortable="false"
                          value="0"/>
                      </uix:columnHeader>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                        <uix:styledText textBinding="text"/>
                 </uix:columnHeaderStamp>
                 <uix:styledText textBinding="POLICY_DESC"  />
                 <uix:styledText textBinding="POLICY_STATUS"/>
                 <uix:styledText textBinding="POLICY_AUDIT"/>
                 <uix:styledText textBinding="POLICY_AUDIT1"/>
                 <uix:styledText textBinding="POLICY_AUDIT2"/>
                 <uix:styledText textBinding="POLICY_AUDIT3"/>

              </uix:hGrid>



					  </uix:contents>
					</uix:cellFormat>
				  </uix:contents>
				</uix:rowLayout>

			 hgrid end --%>


			</uix:tableLayout>
            </uix:header>
            <uix:spacer height="10" width="10"/>

            <!-- To add related links  -->
			<%@ include file="paRelatedLinks.jspf" %>

		   <%-- <uix:tableLayout width="50%">
				<uix:contents>
				<uix:rowLayout>
					<uix:header textBinding="RELATED_LINKS@streamsMsgs">
						<uix:bulletedList>
							<db:link destination="/em/console/database/dist/streams/setup?event=showOptions&previousPage=overviewMain" 
									copyParams="type,target"
									textBinding="SETUP_REPLICATION@streamsMsgs"/>
								   
							<db:link destination="/em/console/database/dist/streams?event=removeStreams&backURL=overviewMain" 
									copyParams="type,target"
									textBinding="REMOVE_STREAMS@streamsMsgs"/>

							<db:link destination="/em/console/database/dist/streams/streamsOverview" 
									copyParams="type,target"
									textBinding="REP_MANAGEMENT@dbInstMsgs"/>

						</uix:bulletedList>
						<uix:spacer height="10" width="10"/>
					</uix:header>
				</uix:rowLayout>
				</uix:contents>
		   </uix:tableLayout>
			--%> 


          </uix:pageLayout>
        </db:form>
      </uix:body>
    </uix:document>
  </uix:renderingContext>

