<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.rsc.streams.PerfAdvisorMsgID"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsgID"%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="paMsgs" class="oracle.sysman.db.rsc.streams.PerfAdvisorMsg"/>
<uix:bundle name="strMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>   

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
        <uix:rawText>
			<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
		</uix:rawText>
    </uix:case>
  </uix:switcher>

 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="queueDetailsForm" method="post" 
				destination="/console/database/dist/streams/perfAdvisor" 
				copyParams="target,type">
    <uix:formValue name="pageName" value="/database/dist/streams/perfadv/queueDetails"/>
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
	<uix:pageLayout titleBinding="header@servletRequest">
			 <%@ include file="/database/global.jspf" %>
			 <oem:messageBox messageType="info" 
							  errorTableBinding="info@servletRequest"
							  titleTextKey="titleText" mainTextKey="mainText"/>
			  <oem:messageBox messageType="error" 
							  errorTableBinding="errors@servletRequest"
							  titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- main contents -->
                      <uix:contents>
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:tableLayout width="100%">
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                              <uix:contents>
                                                <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@paMsgs"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:submitButton textBinding="REFRESH@dbMsgs" shortDescBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout hAlign="right">
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer height="30" width="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          
                                            <uix:cellFormat hAlign="right">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>

													  <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" shortDescBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                          onChange="submitForm('queueDetailsForm', true, {'event':'refreshStatistics'})"
                                                           selectedValueBinding="refreshHomeSelected@servletRequest">
                                                        <uix:option textBinding="MANUAL_REFRESH@paMsgs"
                                                          value="RT_MAN"/>
                                                        <uix:option textBinding="AUTOMATIC_REFRESH@paMsgs"
                                                          value="RT_60"/> 
                                                      </uix:messageChoice>                                                    
                                                    
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:subTabLayout>
							
							<!-- TODO: Add the contents here-->

					<uix:header textBinding="COMPONENT_LEVEL_STATISTICS@paMsgs" renderedBinding="compInfoRendered@servletRequest">
						<uix:spacer height="10" width="10"/>
						<%@ include file="componentInfo.jspf" %>
					</uix:header>

					<uix:header textBinding="SESSION_LEVEL_STATISTICS@paMsgs" renderedBinding="compSessionInfoRendered@servletRequest">
						<uix:spacer height="10" width="10"/>
						<%@ include file="componentSessionInfo.jspf" %>
					</uix:header>

						  <uix:subTabs>
                            <uix:subTabBar selectedIndex="3">
                              <uix:contents>
                                <uix:link textBinding="CAPTURE@paMsgs" renderedBinding="capTabRendered@servletRequest" destinationBinding="captureTabURL@queueCompDetailsBean@servletRequest"/>
                                <uix:link textBinding="PROPAGATION@paMsgs" renderedBinding="propTabRendered@servletRequest" destinationBinding="propTabURL@queueCompDetailsBean@servletRequest"/>
                                <uix:link textBinding="APPLY@paMsgs" renderedBinding="appTabRendered@servletRequest" destinationBinding="applyTabURL@queueCompDetailsBean@servletRequest"/>
                                <uix:link textBinding="QUEUE@paMsgs" renderedBinding="queueTabRendered@servletRequest" />
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                        </uix:subTabLayout>
                      </uix:contents>

					<!-- To add related links  -->
					<%@ include file="paRelatedLinks.jspf" %>

                    </uix:pageLayout>
                    </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>

