<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/utils.js"/>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.PropagateMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>


<%
  request.setAttribute("propagateBundle", new BundleDataObject(NLSUtil.getBundle(PropagateMsg.class.getName(), request)));
%>


 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
         <db:form name="confirmPropAction" method="post" destination="/console/database/dist/streams/propagate" copyParams="target,type,propagateName">
          <uix:pageLayout messageTypeBinding="MSGTYPE@servletRequest">
            <%@ include file="/database/global.jspf" %>
            <uix:tableLayout>
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:stackLayout>
              
                <uix:spacer height="4"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="ERRORMSG@servletRequest"/>
                <uix:spacer height="4"/>
				<uix:checkBox textBinding="FORCE_STOP@propagateBundle@servletRequest" name="forced_stop" id="forced_stop" value="on" shortDescBinding="FORCE_STOP@propagateBundle@servletRequest" renderedBinding="forceStop@servletRequest"/>
                <uix:spacer height="4"/>
         
              </uix:stackLayout>
            </uix:rowLayout>
			</uix:tableLayout>
 
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button  textBinding="NO@propagateBundle@servletRequest" destinationBinding="NO@servletRequest"/>
				 <uix:switcher childNameBinding="forceStop@servletRequest">
                            <uix:case name="true">                            
								<uix:submitButton  textBinding="YES@propagateBundle@servletRequest" shortDescBinding="YES@propagateBundle@servletRequest" name="event" value="stopPropagation"/>
                            </uix:case>
                            <uix:default>
								<uix:button  textBinding="YES@propagateBundle@servletRequest" destinationBinding="YES@servletRequest"/>
                            </uix:default>
					</uix:switcher>

              </uix:pageButtonBar>
            </uix:pageButtons>
<%--
  <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
i--%>
          </uix:pageLayout>
            <uix:pageStatus>
                 </uix:pageStatus> 
     </db:form> 
    </uix:body>
  </uix:document>
</uix:renderingContext>
