<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.PropagateMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("propagateBundle", new BundleDataObject(NLSUtil.getBundle(PropagateMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:document> 
  <uix:metaContainer>
    <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
  </uix:metaContainer>
  <uix:form name="form0" method="post">
    <uix:formValue name="event" value="propagateSchedule" />
   	<uix:formValue name="propagateName" valueBinding="propagationName@defaultBean@servletRequest" />
    <uix:pageLayout titleBinding="TITLE@servletRequest" styleClass="OraInstructionText" >	

    <uix:messages>
    <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
    </uix:messages>
    <%@ include file="/database/global.jspf" %> 
    <uix:pageButtons>
      <uix:pageButtonBar>
          <uix:button name="ACTION" shortDescBinding="CANCEL@propagateBundle@servletRequest" textBinding="CANCEL@propagateBundle@servletRequest" destinationBinding="CANCELURL@servletRequest"/>
          <uix:submitButton name="ACTION" value="OK" shortDescBinding="OK@propagateBundle@servletRequest" textBinding="OK@propagateBundle@servletRequest"/>
      </uix:pageButtonBar>
    </uix:pageButtons>
    
    <uix:body>
      <uix:header textBinding="CURRENT_STATUS@propagateBundle@servletRequest">
         <uix:spacer height="20" width="10"/>
         <uix:tableLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:messageRadioButton name="disabled" textBinding="DISABLED@propagateBundle@servletRequest" shortDescBinding="DISABLED@propagateBundle@servletRequest" value="Y" selectedValueBinding="currentStatus@defaultBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>                             
            <uix:cellFormat>
              <uix:messageRadioButton name="disabled" textBinding="ENABLED@propagateBundle@servletRequest" value="N" shortDescBinding="ENABLED@propagateBundle@servletRequest" selectedValueBinding="currentStatus@defaultBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
         </uix:tableLayout>   
                
			    <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat width="50%" vAlign="top">
                <uix:header size="5" textBinding="START_TIME@propagateBundle@servletRequest">
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                         <uix:spacer height="10" width="10"/>
                      </uix:cellFormat>
                     </uix:rowLayout>
<%--
                     <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="DATE@propagateBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:spacer height="10" width="10"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:messageStyledText styleClass="OraDataText" textBinding="STDATE@servletRequest"/>
                        </uix:cellFormat>
                     </uix:rowLayout>
                     <uix:rowLayout>
                        <uix:cellFormat>
                           <uix:spacer height="10" width="10"/>
                        </uix:cellFormat>
                     </uix:rowLayout>
--%>
                     <uix:rowLayout>
                        <uix:cellFormat>                        
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="TIME@propagateBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:spacer height="10" width="10"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:messageStyledText styleClass="OraDataText" textBinding="STTIME@servletRequest"/>
                        </uix:cellFormat>
                     </uix:rowLayout>
                    </uix:tableLayout>         
                </uix:header>
              </uix:cellFormat>
              <uix:cellFormat width="50%" vAlign="top">
                  <uix:header textBinding="DURATION_OF_PROP@propagateBundle@servletRequest">
                      <uix:tableLayout>
                            <uix:rowLayout>
                                  <uix:cellFormat>
                                      <uix:messageRadioButton name="durationRB" shortDescBinding="INFINITE@propagateBundle@servletRequest" textBinding="INFINITE@propagateBundle@servletRequest"  value="I" selectedValueBinding="LENGTH@servletRequest" />
                                  </uix:cellFormat>
                              </uix:rowLayout>
                            <uix:rowLayout>
                                  <uix:cellFormat>
                                      <uix:messageRadioButton name="durationRB" shortDescBinding="FINITE@propagateBundle@servletRequest" textBinding="FINITE@propagateBundle@servletRequest"  value="F" selectedValueBinding="LENGTH@servletRequest"/>
                                  </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat columnSpan="2" hAlign="right" width="17%">
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeIdBinding="duration" textBinding="DURATION@propagateBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:cellFormat>
                                  <uix:spacer height="10" width="3"/>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="left" width="20%">
                                  <uix:textInput columns="10" name="duration" id="duration" textBinding="DURATION@servletRequest" shortDescBinding="DURATION@propagateBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="left">
                                  <uix:messageChoice name="DTIME" selectedValueBinding="DTIME@servletRequest" shortDescBinding="SELECT@dbBundle@servletRequest">
                                      <uix:option textBinding="SECS@propagateBundle@servletRequest" value="DSC"  shortDescBinding="SECS@propagateBundle@servletRequest" />
                                      <uix:option textBinding="MINS@propagateBundle@servletRequest" value="DMN"  shortDescBinding="MINS@propagateBundle@servletRequest" />
                                      <uix:option textBinding="HOURS@propagateBundle@servletRequest" value="DHR"  shortDescBinding="HOURS@propagateBundle@servletRequest" />
                                      <uix:option textBinding="DAYS@propagateBundle@servletRequest" value="DDY"  shortDescBinding="DAYS@propagateBundle@servletRequest" />
                                  </uix:messageChoice>
                              </uix:cellFormat>
                              </uix:rowLayout>
                          </uix:tableLayout>
                  </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:cellFormat columnSpan="2" width="50%">
                    <uix:spacer height="10" width="20"/>
                </uix:cellFormat>
                <uix:cellFormat width="50%"/>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:cellFormat width="50%">
                    <uix:header textBinding="NEXT_TIME@propagateBundle@servletRequest">
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer height="10" width="15"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:tableLayout>
                                  <uix:rowLayout>
                                        <uix:cellFormat>
                                           <uix:messageRadioButton name="nextTimeRB" shortDescBinding="SIMPLE@propagateBundle@servletRequest" textBinding="SIMPLE@propagateBundle@servletRequest" value="S" selectedValueBinding="NTYPE@servletRequest" />
                                       </uix:cellFormat>
                                   </uix:rowLayout>
                                   </uix:tableLayout>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:rowLayout>
                                            <uix:cellFormat>
                                                <uix:spacer height="10" width="20"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat width="95%">
                                                <uix:tableLayout width="100%">
                                                    <uix:rowLayout width="65%">
                                                        <uix:cellFormat>
                                                            <uix:spacer height="10" width="40"/>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                            <uix:tableLayout>
                                                                <uix:rowLayout>
                                                                    <uix:cellFormat>
                                                                        <uix:messageStyledText styleClass="OraInstructionText" labeledNodeIdBinding="NTIME" textBinding="REPEAT_PROP@propagateBundle@servletRequest"/>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:messageChoice name="NTIME" id="NTIME" selectedValueBinding="NTIME@servletRequest" shortDescBinding="SELECT@dbBundle@servletRequest" >
                                                                            <uix:option textBinding="BY_SECS@propagateBundle@servletRequest" value="NSC" shortDescBinding="BY_SECS@propagateBundle@servletRequest" />
                                                                            <uix:option textBinding="BY_MINS@propagateBundle@servletRequest" value="NMN" shortDescBinding="BY_MINS@propagateBundle@servletRequest" />
                                                                            <uix:option textBinding="BY_HRS@propagateBundle@servletRequest" value="NHR" shortDescBinding="BY_HRS@propagateBundle@servletRequest" />
                                                                            <uix:option textBinding="BY_DAYS@propagateBundle@servletRequest" value="NDY" shortDescBinding="BY_DAYS@propagateBundle@servletRequest" />
                                                                        </uix:messageChoice>
                                                                    </uix:cellFormat>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:cellFormat>
                                                                        <uix:spacer height="2" width="10"/>
                                                                    </uix:cellFormat>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:cellFormat hAlign="left" vAlign="bottom" width="35%">
                                                                        <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="FREQUENCY" textBinding="FREQUENCY@propagateBundle@servletRequest"/>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:messageTextInput columns="8" name="FREQUENCY" id="FREQUENCY" shortDescBinding="FREQUENCY@propagateBundle@servletRequest" textBinding="FREQUENCY@servletRequest" />
                                                                    </uix:cellFormat>
                                                                </uix:rowLayout>
                                                            </uix:tableLayout>
                                                        </uix:cellFormat>
                                                    </uix:rowLayout>
                                                </uix:tableLayout>
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                        <uix:tableLayout>
                                  <uix:rowLayout>
                                        <uix:cellFormat>
                                           <uix:messageRadioButton name="nextTimeRB" shortDescBinding="ADVANCED@propagateBundle@servletRequest" textBinding="ADVANCED@propagateBundle@servletRequest"  value="A" selectedValueBinding="NTYPE@servletRequest" />
                                       </uix:cellFormat>
                                   </uix:rowLayout>
                                   </uix:tableLayout>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:rowLayout>
                                            <uix:cellFormat>
                                                <uix:spacer height="10" width="15"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                                <uix:tableLayout>
                                                    <uix:rowLayout>
                                                        <uix:cellFormat>
                                                            <uix:spacer height="10" width="10"/>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="center">
                                                            <uix:messageTextInput columns="20" textBinding="FUNCTION@servletRequest" shortDescBinding="ADVANCED_INFO@propagateBundle@servletRequest" name="FUNCTION" messageBinding="ADVANCED_INFO@propagateBundle@servletRequest"/> 
                                                        </uix:cellFormat>
                                                    </uix:rowLayout>
                                                </uix:tableLayout>
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:spacer height="20" width="10"/>
                    </uix:header>
                </uix:cellFormat>
                <uix:cellFormat width="50%" vAlign="top">
                    <uix:header textBinding="LATENCY@propagateBundle@servletRequest">
                        <uix:spacer height="8" width="10"/>
                        <uix:messageStyledText textBinding="LATENCY_INFO@propagateBundle@servletRequest" styleClass="OraInstructionText"/>
                        <uix:spacer height="8" width="10"/>
                        <uix:tableLayout width="50%">
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messageStyledText labeledNodeIdBinding="LATENCY" styleClass="OraInstructionText" textBinding="LATENCY@propagateBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:spacer height="10" width="3"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:messageTextInput columns="8" name="LATENCY" id="LATENCY" shortDescBinding="LATENCY@propagateBundle@servletRequest" textBinding="latency@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:messageChoice name="LTIME" selectedValueBinding="LTIME@servletRequest" shortDescBinding="SELECT@dbBundle@servletRequest" >
                                        <uix:option textBinding="SECS@propagateBundle@servletRequest" value="LSC" shortDescBinding="SECS@propagateBundle@servletRequest" />
                                        <uix:option textBinding="MINS@propagateBundle@servletRequest" value="LMN" shortDescBinding="MINS@propagateBundle@servletRequest" />
                                    </uix:messageChoice>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat/>
                                <uix:cellFormat>
                                    <uix:spacer height="10" width="3"/>
                                </uix:cellFormat>
                                <uix:cellFormat columnSpan="2">
                                    <uix:formattedText styleClass="OraInlineInfoText" textBinding="SPECIFY_MAX_TIME@propagateBundle@servletRequest"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                    </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                  <uix:cellFormat columnSpan="2" width="50%">
                      <uix:spacer height="20" width="10"/>
                  </uix:cellFormat>
                  <uix:cellFormat width="50%"/>
              </uix:rowLayout>
          </uix:tableLayout>
            <uix:spacer height="20" width="10"/>
        </uix:header>
        </uix:body>
   <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 

        </uix:pageLayout> 
	  </uix:form>
	 </uix:document> 
	</uix:renderingContext>  
