<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.PropagateMsg"%>
<%@ page import="oracle.sysman.db.rsc.streams.CaptureMsg"%>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<% 
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("captureBundle", new BundleDataObject(NLSUtil.getBundle(CaptureMsg.class.getName(), request)));
  request.setAttribute("propagateBundle", new BundleDataObject(NLSUtil.getBundle(PropagateMsg.class.getName(), request)));
  String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:form name="view_prop_details">
      <uix:pageLayout titleBinding="title@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf"%>
		 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:header textBinding="GENERAL@streamBundle@servletRequest">
          <uix:tableLayout hAlign="left" width="75%">
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="PROP_NAME@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="name@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="SRC_Q@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="srcQueue@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="SRC_Q_SCHEMA@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="srcQueueSchema@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="DEST_Q@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="destQueue@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="DEST_Q_SCHEMA@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="destQueueSchema@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="DB_LINK@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="destLink@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="NUM_OF_ERRORS@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="numberOfErrors@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
              <% 
      
      if(dbVersion.equals("10g"))
      {
%>
                              <uix:styledText styleClass="OraInstructionText" textBinding="POS_RULE_SET@streamBundle@servletRequest"/>
       <% 
      }
      else
      {
%>                       
                              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_NAME@streamBundle@servletRequest"/>
<% 
      }
%>  
                
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                                    
                <uix:link styleClass="OraLinkText" textBinding="positiveRuleSet@defaultBean@servletRequest" destinationBinding="POSLINK@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
<%
                            if(dbVersion.equals("10g"))
      {
%>
                              <uix:styledText styleClass="OraInstructionText" textBinding="POS_RULE_SET_OWNER@streamBundle@servletRequest"/>
       <% 
      }
      else
      {
%>                       
                              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_OWNER@streamBundle@servletRequest"/>
<% 
      }
%>         
                           
                
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="positiveRuleSetOwner@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <% 
      
      if(dbVersion.equals("10g"))
      {
%>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="NEG_RULE_SET@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:link styleClass="OraLinkText" textBinding="negativeRuleSet@defaultBean@servletRequest" destinationBinding="NEGLINK@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="NEG_RULE_SET_OWNER@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="negativeRuleSetOwner@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <% 
    }
%>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="START_DATE@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="startDate@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="LAST_ERROR_TIME@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="lastErrorTime@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText" textBinding="LAST_ERROR_MSG@streamBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="center">
                <uix:spacer height="10" width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="lastErrorMsg@defaultBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        <uix:header textBinding="OBJECTS@streamBundle@servletRequest">
          <uix:spacer height="15" width="10"/>
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText textBinding="SEARCH@streamBundle@servletRequest" styleClass="OraInstructionText"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="3" width="3"/>
              </uix:cellFormat>
              <uix:formValue name="propagateName" valueBinding="name@defaultBean@servletRequest"/>
              <uix:formValue name="pageName" value="/database/dist/streams/propagate/viewDetails"/>
              <uix:cellFormat>
                <%--  <oem:choice name="search_options" optionsBinding="searchStrings@defaultBean@servletRequest" selectedValueBinding="searchType@servletRequest" onChange="submitForm('view_prop_details', true, {'event':'viewType'})"/>
--%>
                <uix:choice name="search_options" selectedValueBinding="searchType@servletRequest" onChange="submitForm('view_prop_details', true, {'event':'viewType'})">
                  <uix:option textBinding="RULE_TYPE@streamBundle@servletRequest" value="Rule Type"/>
                  <uix:option textBinding="CHANGE_TYPE@streamBundle@servletRequest" value="Change Type"/>
                  <% 
      if(dbVersion.equals("10g"))
      {
%>
                  <uix:option textBinding="POS@streamBundle@servletRequest" value="Positive Rule Set"/>
                  <uix:option textBinding="NOS@streamBundle@servletRequest" value="Negative Rule Set"/>
                  <% 
      }
      else
      {
%>
                  <uix:option textBinding="RULE_NAME@captureBundle@servletRequest" value="Positive Rule Set"/>
                  <% 
      }
%>
                </uix:choice>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="3" width="3"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:switcher childNameBinding="searchType@servletRequest">
                  <uix:case name="Positive Rule Set">
                    <uix:textInput columns="10" name="search_string" maximumLength="25"/>
                  </uix:case>
                  <uix:case name="Negative Rule Set">
                    <uix:textInput columns="10" name="search_string" maximumLength="25"/>
                  </uix:case>
                  <uix:case name="Rule Type">
                    <uix:choice name="search_string" selectedValueBinding="searchStr@servletRequest">
                      <uix:contents childDataBinding="searchOptions@defaultBean@servletRequest">
                        <uix:option textBinding="textKey" valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:case>
                  <uix:case name="Change Type">
                    <uix:choice name="search_string" selectedValueBinding="searchStr@servletRequest">
                      <uix:contents childDataBinding="searchOptions@defaultBean@servletRequest">
                        <uix:option textBinding="textKey" valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="3" width="3"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:submitButton textBinding="GO@streamBundle@servletRequest" name="event" value="filterData" shortDescBinding="GO@streamBundle@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="15" width="10"/>
          <oem:table name="dataSource" width="95%" blockSize="5" summary="OBJ_SUMMARY@streamBundle@servletRequest" shortDescBinding="OBJ_SUMMARY@streamBundle@servletRequest" beanKey="defaultBean" alternateTextBinding="NO_SEARCH_DONE@streamBundle@servletRequest" formSubmitted="true" dataSourceProp="dataSource" copyParams="search_string"/>
          <uix:spacer height="15" width="10"/>
          <% 
      if(dbVersion.equals("10g"))
      {
%>
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:tip/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText styleClass="OraTipText" textBinding="SAME_CONDITION_MSG@streamBundle@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <% 
      }
%>
          <uix:spacer height="2" width="10"/>
        </uix:header>

 </uix:subTabLayout>
   <%@ include file="/database/dist/streams/streamsLinks.jspf" %>
      </uix:pageLayout>
    </uix:form>
  </uix:document>
</uix:renderingContext>
