<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.PropagateMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<% 
  request.setAttribute("propBundle", new BundleDataObject(NLSUtil.getBundle(PropagateMsg.class.getName(), request)));
    String dbVersion = (String)request.getAttribute("DBVERSION");

%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
 <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
		<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
	  </uix:rawText>
    </uix:case>
  </uix:switcher>
  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
    </uix:metaContainer>
    <db:form name="propagateStatsForm" method="get" destination="/console/database/dist/streams/propagate" copyParams="target,type,propagateName">
      <uix:formValue name="pageName" value="/database/dist/streams/propagate/viewStatistics"/>
      <uix:formValue name="propagateName" valueBinding="propagateName@servletRequest"/>
      <uix:pageLayout titleBinding="title@defaultBean@servletRequest">
		 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>

        <%@ include file="/database/global.jspf"%>
        <uix:tableLayout width="100%">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                    <%--
				<uix:styledText styleClass="OraTipText" textBinding="PAGE_REFR@propBundle@servletRequest"/>
        --%>
                    <uix:styledText styleClass="OraTipText" textBinding="LAST_REFRESH@dbMsgs"/>
                    <uix:spacer height="10" width="10"/>
                    <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                    <uix:spacer height="10" width="10"/>
                    <uix:submitButton textBinding="REFRESH@propBundle@servletRequest" shortDescBinding="REFRESH@propBundle@servletRequest" name="event" value="refreshStatistics"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="5" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat hAlign="right">
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText" labeledNodeIdBinding="refreshHome" textBinding="VIEW_DATA@propBundle@servletRequest"/>
                      <uix:spacer height="5" width="10"/>
                      <uix:choice name="refreshHome" id="refreshHome" shortDescBinding="VIEW_DATA@propBundle@servletRequest" onChange="submitForm('propagateStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                        <uix:option textBinding="MANUALLY@propBundle@servletRequest" value="RT_MAN"/>
                        <uix:option textBinding="AUTOMATIC@propBundle@servletRequest" value="RT_60"/>
                      </uix:choice>
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer height="10" width="10"/>
        <uix:header textBinding="QUEUE@propBundle@servletRequest">
          <uix:tableLayout width="90%">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:labeledFieldLayout>
                  <uix:messageStyledText promptBinding="TOTAL_WAIT_TIME@propBundle@servletRequest" textBinding="totalWaitTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                  <uix:messageStyledText promptBinding="AVG_WAIT_TIME@propBundle@servletRequest" textBinding="avgWaitTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                  <% 
      
      if(dbVersion.equals("10g"))
      {
%>
                  <uix:messageStyledText promptBinding="BUF_Q_MESG_COUNT@propBundle@servletRequest" textBinding="mesgCount@defaultBean@servletRequest" styleClass="OraDataText"/>
                  <uix:messageStyledText promptBinding="BUF_Q_SPL_MESG@propBundle@servletRequest" textBinding="spilledMsg@defaultBean@servletRequest" styleClass="OraDataText"/>
                  <% 
      }
%>
                </uix:labeledFieldLayout>
              </uix:cellFormat>
              <uix:cellFormat/>
              <uix:cellFormat>
                <oem:chart shadowEffect="shadow" titleBinding="MESG_STATS@propBundle@servletRequest" chartType="timeSeriesChart" shortDescBinding="CHART_INFO@propBundle@servletRequest" yAxisLabelBinding="NOMSGS@propBundle@servletRequest" xAxisLabelBinding="TIME@propBundle@servletRequest" legendVisible="external" width="350" height="200" orientation="vertical">
                  <oem:sqlChartDataSource sqlPreparedStatementBinding="bufQMsgStatsChartDS@defaultBean@servletRequest"/>
                  <oem:chartColumn displayLabelBinding="READ@propBundle@servletRequest" sourceIndex="0" itemColor="#663366"/>
                  <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                </oem:chart>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        <uix:header textBinding="PROPAGATION@propBundle@servletRequest">
          <uix:header textBinding="GENERAL@propBundle@servletRequest">
            <uix:tableLayout width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:labeledFieldLayout>
                    <uix:messageStyledText promptBinding="START_TIME@propBundle@servletRequest" textBinding="startTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="PROCESS_NAME@propBundle@servletRequest" textBinding="processName@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="SESSION_ID@propBundle@servletRequest" textBinding="sessionID@defaultBean@servletRequest" 
     destinationBinding="sessionIDUrl@defaultBean@servletRequest"
     shortDescBinding="SESSION_DETAILS@streamsMsgs@servletRequest"
     styleClass="OraLinkText"/>

<%--		<db:link 
			 destinationBinding="sessionIDUrl@defaultBean@servletRequest"
			 copyParams="type,target"
			 shortDescBinding="SESSION_DETAILS@streamsMsgs@servletRequest"
			 textBinding="sessionID@defaultBean@servletRequest" /> 
--%>

                    <uix:messageStyledText promptBinding="CLUSTER_DB@propBundle@servletRequest" textBinding="clusterDBInstance@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_NUM_OF_MSG_PROPAGATED@propBundle@servletRequest" textBinding="messagesPropagated@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_NUM_OF_BYTE_PROPAGATED@propBundle@servletRequest" textBinding="bytesPropagated@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_PROP_TIME@propBundle@servletRequest" textBinding="totalPropagationTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="MAX_MESG_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="maxMesg@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="MAX_BYTE_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="maxBytes@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_MESG_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="avgMesg@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_BYTE_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="avgBytes@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_TIME_FOR_SINGLE_MSG@propBundle@servletRequest" textBinding="avgPropagationTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                  </uix:labeledFieldLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          <uix:header textBinding="FAILURES@propBundle@servletRequest">
            <uix:tableLayout width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:labeledFieldLayout>
                    <uix:messageStyledText promptBinding="NUM_OF_FAILURES@propBundle@servletRequest" textBinding="numOfFailures@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="LAST_ERROR_OCCURED_TIME@propBundle@servletRequest" textBinding="lastErrorDate@defaultBean@servletRequest" styleClass="OraDataText"/>
                  </uix:labeledFieldLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:header>
		
 </uix:subTabLayout>
   <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 
      </uix:pageLayout>
    </db:form>
  </uix:document>
</uix:renderingContext>
