<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.PropagateMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg"%>
<%@ page import="oracle.sysman.emSDK.chart.EmChartPreparedStatement"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<% 
  request.setAttribute("propBundle", new BundleDataObject(NLSUtil.getBundle(PropagateMsg.class.getName(), request)));
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
		<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrlPersQ") %>" />
	  </uix:rawText>
    </uix:case>
  </uix:switcher>
  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
    <db:form name="propagateStatsForm" method="get" destination="/console/database/dist/streams/propagate" copyParams="target,type,propagateName">
      <uix:formValue name="target" valueBinding="target@servletRequest"/>
      <uix:formValue name="type" valueBinding="type@servletRequest"/>
      <uix:formValue name="pageName" value="/database/dist/streams/propagate/viewStatsPersQ"/>
      <uix:formValue name="propagateName" valueBinding="propagateName@servletRequest"/>
      <uix:pageLayout titleBinding="title@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf"%>
		 <uix:subTabLayout>
   <%@ include file="/database/dist/streams/repTab.jspf" %>
      <uix:contents>

        <uix:tableLayout width="100%">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                   
                    <uix:spacer height="10" width="10"/>
                    <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                    <uix:spacer height="10" width="10"/>
                    <uix:submitButton textBinding="REFRESH@propBundle@servletRequest" name="event" value="refreshStatistics"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="5" width="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat hAlign="right">
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@propBundle@servletRequest" labeledNodeIdBinding="refreshHome"/>
                      <uix:spacer height="5" width="10"/>
                      <uix:choice name="refreshHome" id="refreshHome" onChange="submitForm('propagateStatsForm', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest" shortDescBinding="VIEW_DATA@propBundle@servletRequest">
                        <uix:option textBinding="MANUALLY@propBundle@servletRequest" value="RT_MAN"/>
                        <uix:option textBinding="AUTOMATIC@propBundle@servletRequest" value="RT_60"/>
                      </uix:choice>
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        
        <uix:tableLayout>
    
	<uix:rowLayout>
        <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText" textBinding="VIEW@captureMsgs"/>
            <uix:spacer height="10" width="10"/>

            <uix:radioButton name="queueType" 
                textBinding="BUFF_Q@propBundle@servletRequest" 
                shortDescBinding="BUFF_Q@propBundle@servletRequest"
                selectedValueBinding="queueType@servletRequest" 
                value="buffQ" 
                onClick="submitForm( 'propagateStatsForm', true, {'event':'viewStatsBuffQ'}  )"
            />
            <uix:spacer height="10" width="10"/>
        </uix:cellFormat>
	
        <uix:cellFormat>
            <uix:radioButton name="queueType" 
                textBinding="PERS_Q@propBundle@servletRequest" 
                shortDescBinding="PERS_Q@propBundle@servletRequest"
                selectedValueBinding="queueType@servletRequest" 
                value="persQ" 
                onClick="submitForm( 'propagateStatsForm', true, {'event':'viewStatsPersQ'}  )"
            />
        </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout hAlign="right">
        <uix:cellFormat>
            <uix:spacer height="10" width="10"/>
        </uix:cellFormat>
    </uix:rowLayout>
</uix:tableLayout>
          <uix:spacer height="10" width="10"/>
          <uix:header textBinding="QUEUE@propBundle@servletRequest">
            <uix:tableLayout width="90%">
              <uix:rowLayout>
                <uix:cellFormat>
                  <oem:chart shadowEffect="shadow" titleBinding="MESG_STATS@propBundle@servletRequest" chartType="timeSeriesChart" yAxisLabelBinding="NOMSGS@propBundle@servletRequest" xAxisLabelBinding="TIME@propBundle@servletRequest" legendVisible="external" width="350" height="170" orientation="vertical" shortDescBinding="MESG_STATS@propBundle@servletRequest">
                    <oem:sqlChartDataSource sqlPreparedStatementBinding="persQMsgStatsChartDS@defaultBean@servletRequest"/>
                    <oem:chartColumn displayLabelBinding="READ@propBundle@servletRequest" sourceIndex="0" itemColor="#663366"/>
                    <oem:chartColumn displayLabelBinding="WAIT@propBundle@servletRequest" sourceIndex="1" itemColor="#9999FF"/>
                    <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="2"/>
                  </oem:chart>
                </uix:cellFormat>
                <uix:cellFormat/>
                <uix:cellFormat>
                  <oem:chart shadowEffect="shadow" titleBinding="PROP_STATS@propBundle@servletRequest" chartType="timeSeriesChart" yAxisLabelBinding="NOMSGS@propBundle@servletRequest" xAxisLabelBinding="TIME@propBundle@servletRequest" legendVisible="external" width="350" height="170" orientation="vertical" shortDescBinding="PROP_STATS@propBundle@servletRequest">
                    <oem:sqlChartDataSource sqlPreparedStatementBinding="persQPropStatsChartDS@defaultBean@servletRequest"/>
                    <oem:chartColumn displayLabelBinding="TOTAL_NUM_OF_MSG_PROPAGATED@propBundle@servletRequest" sourceIndex="0" itemColor="#663366"/>
                    <oem:chartColumn displayLabelBinding="TOTAL_NUM_OF_KBYTE_PROPAGATED@propBundle@servletRequest" sourceIndex="1" itemColor="#9999FF"/>
                    <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="2"/>
                  </oem:chart>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          <uix:header textBinding="GENERAL@propBundle@servletRequest">
            <uix:tableLayout width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:labeledFieldLayout>
                    <uix:messageStyledText promptBinding="START_TIME@propBundle@servletRequest" textBinding="startTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="PROCESS_NAME@propBundle@servletRequest" textBinding="processName@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="SESSION_ID@propBundle@servletRequest" textBinding="sessionID@defaultBean@servletRequest" styleClass="OraLinkText" destinationBinding="sessionIDUrl@defaultBean@servletRequest"/>
                    <uix:messageStyledText promptBinding="CLUSTER_DB@propBundle@servletRequest" textBinding="clusterDBInstance@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_NUM_OF_MSG_PROPAGATED@propBundle@servletRequest" textBinding="messagesPropagated@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_NUM_OF_BYTE_PROPAGATED@propBundle@servletRequest" textBinding="bytesPropagated@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_PROP_TIME@propBundle@servletRequest" textBinding="totalPropagationTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="MAX_MESG_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="maxMesg@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="MAX_BYTE_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="maxBytes@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_MESG_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="avgMesg@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_BYTE_IN_PROP_WINDOW@propBundle@servletRequest" textBinding="avgBytes@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_TIME_FOR_SINGLE_MSG@propBundle@servletRequest" textBinding="avgPropagationTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="TOTAL_WAIT_TIME@propBundle@servletRequest" textBinding="totalWaitTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                    <uix:messageStyledText promptBinding="AVG_WAIT_TIME@propBundle@servletRequest" textBinding="avgWaitTime@defaultBean@servletRequest" styleClass="OraDataText"/>
                  </uix:labeledFieldLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        
        <uix:header textBinding="FAILURES@propBundle@servletRequest">
          <uix:tableLayout width="80%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:labeledFieldLayout>
                  <uix:messageStyledText promptBinding="NUM_OF_FAILURES@propBundle@servletRequest" textBinding="numOfFailures@defaultBean@servletRequest" styleClass="OraDataText"/>
                  <uix:messageStyledText promptBinding="LAST_ERROR_OCCURED_TIME@propBundle@servletRequest" textBinding="lastErrorDate@defaultBean@servletRequest" styleClass="OraDataText"/>
                </uix:labeledFieldLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
  </uix:contents>
 </uix:subTabLayout>
   <%@ include file="/database/dist/streams/streamsLinks.jspf" %> 

      </uix:pageLayout>
    </db:form>
  </uix:document>
</uix:renderingContext>
