<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
        <uix:rawText>
			<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
		</uix:rawText>
    </uix:case>
  </uix:switcher>

 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="bufferedQueueStatsForm" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType,sname, oname, isBufferQueue, QTYPE">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/bufferedQueueStats"/>
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
 <uix:pageLayout titleBinding="header@servletRequest">
<%@ include file="/database/global.jspf" %>
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
<uix:contents>
<uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:contents>
                                <uix:tableLayout width="100%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                          <uix:contents>
                                            <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESH@aqMsgs"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@dbMsgs" shortDescBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout hAlign="right">
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="30" width="10"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <%-- <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@dbMsgs"/> --%>

                                                  <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" shortDescBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                      onChange="submitForm('bufferedQueueStatsForm', true, {'event':'refreshStatistics'})"
                                                       selectedValueBinding="refreshHomeSelected@servletRequest">
                                                    <uix:option textBinding="MANUAL_REFRESH@aqMsgs"
                                                      value="RT_MAN"/>
                                                    <uix:option textBinding="AUTOMATIC_REFRESH@aqMsgs"
                                                      value="RT_60"/> 
                                                  </uix:messageChoice>
                                                
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:spacer height="10" width="10"/>

        <uix:subTabLayout>

            <%--  RAC changes begin  --%>   
			<uix:tableLayout hAlign="left" renderedBinding="queueOwningInstrRendered@buffQStatsBean@servletRequest">
             <uix:rowLayout hAlign="left">
              <uix:cellFormat vAlign="middle" wrappingDisabled="true">
				<uix:messageStyledText 
								   styleClass="OraDataText" textBinding="changeInstanceInstr@servletRequest"/>
              </uix:cellFormat>
             </uix:rowLayout>            
			</uix:tableLayout>

            <uix:tableLayout hAlign="right">
             <uix:rowLayout hAlign="right" renderedBinding="isRacInstance@servletRequest">
              <uix:cellFormat vAlign="middle" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText" 
                               labeledNodeId="instanceOption"
                               textBinding="SWITCH_TO@DBMsgBundle@servletRequest"/>  
               <uix:spacer width="1"/>
               <oem:choice name="instance" id="instance" 
                           selectedValueBinding="target@servletRequest" 
                           optionsBinding="racInstances@servletRequest"/>
               <uix:submitButton name="event"
                                 textBinding="GO@DBMsgBundle@servletRequest" 
                                 value="switchRacInstance"/>
              </uix:cellFormat>     

             </uix:rowLayout>            
            </uix:tableLayout> 
        
            <uix:tableLayout hAlign="center" renderedBinding="isRacInstance@servletRequest">
              <uix:rowLayout >
                <uix:cellFormat>
                    <uix:spacer height="30" width="100"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>                   

            <uix:header textBinding="BUFFQSTATS@aqMsgs" renderedBinding="isBuffQListRendered@servletRequest">
                <uix:contents>
                    <uix:tableLayout width="100%">
                        <uix:contents>
                            <uix:rowLayout width="100%">
                                <uix:contents>

                                    <uix:dataScope currentDataBinding="bufQStatsList@buffQStatsBean@servletRequest">
                                        <uix:table name="bufQStatsList" 
                                        alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="rowData"
                                        minValue="1"
                                        valueBinding="startIndex"
                                        blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                        maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"                                    
                                        shortDescBinding="BUFFQSTATS@aqMsgs"
                                        summaryBinding="BUFFQSTATS@aqMsgs">

                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="INSTANCE_NAME@aqMsgs" sortable="true"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" />
                                        <uix:styledText textBinding="<%= AQMsgID.INSTANCE_NAME %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="LCRS_MEM@aqMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="numberFormat"/>
                                        <uix:styledText textBinding="<%= AQMsgID.LCRS_MEM %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CURR_TOTAL_LCRS@aqMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="numberFormat"/>
                                        <uix:styledText textBinding="<%= AQMsgID.CURR_TOTAL_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>														
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CUMM_LCRS@aqMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="numberFormat"/>
                                        <uix:styledText textBinding="<%= AQMsgID.CUMM_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CURR_SPILLED_LCRS@aqMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="numberFormat"/>
                                        <uix:styledText textBinding="<%= AQMsgID.CURR_SPILLED_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CUMM_SPILLED_LCRS@aqMsgs" sortable="no"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="numberFormat"/>
                                        <uix:styledText textBinding="<%= AQMsgID.CUMM_SPILLED_LCRS %>"/>
                                        </uix:column>
                                        </uix:table>
                                    </uix:dataScope>

                                </uix:contents>
                            </uix:rowLayout>
                        </uix:contents>
                    </uix:tableLayout>
                </uix:contents>
            </uix:header>

        <%--  RAC changes end   --%>

                    <uix:tableLayout hAlign="center" width="100%" renderedBinding="isBuffQStatsRendered@servletRequest">
                      <uix:contents>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                              
                                <uix:cellFormat hAlign="right" width="50%">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="QUEUE_OWNER@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="schemaName@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="LCRS_MEM@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="currMemLCRs@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="CURR_TOTAL_LCRS@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="currLCRs@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="CUMM_LCRS@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="cummLCRs@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="CURR_SPILLED_LCRS@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="currSpillLCRs@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="CUMM_SPILLED_LCRS@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="1"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" textBinding="cummSpillLCRs@buffQStatsBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        

<uix:header textBinding="PUBLISHER_STATISTICS@aqMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="BUFFERED_PUB_INSTR@aqMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                  
                                  <uix:dataScope currentDataBinding="pubStats@buffQStatsBean@servletRequest">
                                   <uix:table name="pubStats" 
                                    alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                    formSubmitted="true"
                                    width="100%"
                                    tableDataBinding="rowData"
                                    minValue="1"
                                    valueBinding="startIndex"
                                    blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                    maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"                                    
                                    shortDescBinding="PUBLISHER_STATISTICS_TABLE@aqMsgs"
                                    summaryBinding="PUBLISHER_STATISTICS_TABLE@aqMsgs">

               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column renderedBinding="isBuffQListRendered@servletRequest">
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="INSTANCE_NAME@aqMsgs" sortable="true"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" />
                                        <uix:styledText textBinding="<%= AQMsgID.INSTANCE_NAME %>"/>
                                        </uix:column>
                                            
                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="CAPTURE_PROCESS@aqMsgs" sortable="true"/>
                                              </uix:columnHeader> 
                                              <uix:columnFormat columnDataFormat="textFormat" />
                                              <uix:styledText textBinding="<%= AQMsgID.CAPTURE_PROCESS %>"/>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="SENDER_QUEUE@aqMsgs" sortable="true"/>
                                              </uix:columnHeader> 
                                              <uix:columnFormat columnDataFormat="textFormat"/>
                                              <uix:styledText textBinding="<%= AQMsgID.SENDER_QUEUE %>"/>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="CURR_LCRS@aqMsgs" sortable="no"/>
                                              </uix:columnHeader> 
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:styledText textBinding="<%= AQMsgID.CURR_LCRS %>"/>
                                            </uix:column>
                                            <uix:column>														
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="CUMM_LCRS@aqMsgs" sortable="no"/>
                                              </uix:columnHeader> 
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:styledText textBinding="<%= AQMsgID.CUMM_LCRS %>"/>
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnHeader>
                                                <uix:sortableHeader textBinding="LAST_LCR_ID@aqMsgs" sortable="no"/>
                                              </uix:columnHeader> 
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:styledText textBinding="<%= AQMsgID.LAST_LCR_ID %>"/>
                                            </uix:column>
                                    </uix:table>
                                    </uix:dataScope>
                                    
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                       <uix:header textBinding="SUBSCRIBER_STATISTICS@aqMsgs">
                          <uix:contents>
                            <uix:spacer height="10" width="10"/>
                            <uix:messageStyledText textBinding="BUFFERED_SUBS_INSTR@aqMsgs" styleClass="OraInstructionText"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout width="100%">
                                  <uix:contents>
                                  <uix:dataScope currentDataBinding="subsStats@buffQStatsBean@servletRequest">
                                     <uix:table name="subsStats" 
                                        alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                        formSubmitted="true"
                                        width="100%"
                                        tableDataBinding="rowData"
                                        minValue="1"
                                        valueBinding="startIndex"
                                        blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                        maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                                        shortDescBinding="SUBSCRIBER_STATISTICS_TABLE@aqMsgs"
                                        summaryBinding="SUBSCRIBER_STATISTICS_TABLE@aqMsgs">

               
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:column renderedBinding="isBuffQListRendered@servletRequest">
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="INSTANCE_NAME@aqMsgs" sortable="true"/>
                                        </uix:columnHeader> 
                                        <uix:columnFormat columnDataFormat="textFormat" />
                                        <uix:styledText textBinding="<%= AQMsgID.INSTANCE_NAME %>"/>
                                        </uix:column>
                                        
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SUBS_PROC_NAME@aqMsgs" sortable="true"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="textFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.SUBS_PROC_NAME %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="PROC_TYPE@aqMsgs" sortable="true"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="textFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.PROC_TYPE %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="SUBS_ADDR@aqMsgs" sortable="true"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="textFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.SUBS_ADDR %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CURR_LCRS@aqMsgs" sortable="no"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.CURR_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader  textBinding="CUMM_LCRS@aqMsgs" sortable="no"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.CUMM_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CUMM_SPILLED_LCRS@aqMsgs" sortable="no"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.CUMM_SPILLED_LCRS %>"/>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CUMM_DEQ_LCRS@aqMsgs" sortable="no"/>
                                          </uix:columnHeader> 
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          <uix:styledText textBinding="<%= AQMsgID.CUMM_DEQ_LCRS %>"/>
                                        </uix:column>										
                                    </uix:table>
                                </uix:dataScope>

                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout><uix:spacer height="8" />
                          </uix:contents>
                        </uix:header>                         

	  <uix:subTabs>
	    <uix:subTabBar selectedIndex="2">
	      <uix:contents>
		<uix:link textBinding="QUEUE_PROPAGATION_STATS@aqMsgs" destinationBinding="propagationStatsPageURL@buffQStatsBean@servletRequest" />
		<uix:link textBinding="QUEUE_MESSAGE_STATS@aqMsgs" destinationBinding="queueMessageStatsPageURL@buffQStatsBean@servletRequest" />
		<uix:link textBinding="BUFFERED_QUEUE_STATS@aqMsgs" />
	      </uix:contents>
	    </uix:subTabBar>
	  </uix:subTabs>
	</uix:subTabLayout>

</uix:contents>

</uix:pageLayout>    


</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>


