<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
<uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/> 
 <uix:document>
     <uix:metaContainer>
     <uix:head titleBinding="title@servletRequest"/>
     </uix:metaContainer>
     <uix:body>
         <db:form name="createAnydataQTable" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType">
             <uix:formValue name="pageName" value="/database/dist/streams/queue/createAnydataQTable"/>
             <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
             <uix:pageLayout titleBinding="header@servletRequest">
                 <%@ include file="/database/global.jspf" %>
                 <oem:messageBox messageType="info" 
                 errorTableBinding="info@servletRequest"
                 titleTextKey="titleText" mainTextKey="mainText"/>
                 <oem:messageBox messageType="error" 
                 errorTableBinding="errors@servletRequest"
                 titleTextKey="titleText" mainTextKey="mainText"/>
                 <uix:contents>
                 <uix:tableLayout width="75%" hAlign="center">
                     <uix:contents>
                     <uix:rowLayout>
                         <uix:contents>
                             <uix:cellFormat hAlign="right" width="30%">
                                 <uix:contents>
                                     <uix:messagePrompt promptBinding="NAME@dbMsgs" required="yes" labeledNodeId="NAME"/>
                                 </uix:contents>
                             </uix:cellFormat>
                             <uix:cellFormat>
                                 <uix:contents>
                                     <uix:spacer height="10" width="5"/>
                                 </uix:contents>
                             </uix:cellFormat>
                             <uix:cellFormat hAlign="left">
                                 <uix:contents>
                                     <%--<uix:messageTextInput name="queueTableName" columns="50" id="NAME" 
                                     shortDescBinding="NAME@dbMsgs" textBinding="fullQueueTableName@queueMainBean@servletRequest"
                                     /> --%>
                                     <uix:messageStyledText styleClass="OraDataText" shortDescBinding="fullQueueTableName@queueMainBean@servletRequest" textBinding="fullQueueTableName@queueMainBean@servletRequest"/>
                                 </uix:contents>
                             </uix:cellFormat>
                         </uix:contents>
                     </uix:rowLayout>
                     </uix:contents>
                 </uix:tableLayout>
                 <uix:spacer height="10" width="10"/>
                 <%-- START: TABLE STORAGE PAGE starts here --%>
                        <uix:dataScope currentDataBinding="qTableSegment@servletRequest">
                            <%--<jsp:include page="/database/dist/streams/queue/qtable/storageInclude.jsp" />--%>
                            <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
                            <uix:ref refID="storageInclude" />
                        </uix:dataScope>
                 <%-- END: TABLE STORAGE PAGE ends here --%>

                 </uix:contents>
                 <uix:pageButtons>
                     <uix:pageButtonBar>
                         <uix:contents>
                             <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>								 
                             <uix:submitButton shortDescBinding="OK@dbMsgs"textBinding="OK@dbMsgs" name="event" value="applyAnydataQTableParams"/>
                         </uix:contents>
                     </uix:pageButtonBar>
                 </uix:pageButtons>
             </uix:pageLayout>    


         </db:form>
     </uix:body>
 </uix:document>


</uix:renderingContext>
