<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="createNormalQueue" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/createNormalQueue"/>
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
 <uix:pageLayout titleBinding="header@servletRequest">
<%@ include file="/database/global.jspf" %>
<oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
<uix:contents>
<uix:spacer height="20" width="10"/> 
<uix:tableLayout hAlign="center" width="75%">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" width="30%">
                                  <uix:contents>
                                    <uix:messageStyledText labeledNodeId="queueName" textBinding="NAME@dbMsgs" required="yes" styleClass="OraInstructionText"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput shortDescBinding="NAME@dbMsgs" id="queueName" name="queueName" textBinding="queueName@queueMainBean@servletRequest" columns="50"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText labeledNodeId="fullQueueTableName" required="yes" styleClass="OraInstructionText" textBinding="QUEUE_TABLE@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageLovField columns="50" shortDescBinding="QUEUE_TABLE@aqMsgs" searchDescBinding="QUEUE_TABLE@aqMsgs" id="fullQueueTableName" name="fullQueueTableName" textBinding="fullQueueTableName@queueMainBean@servletRequest" onClick="startLov('fullQueueTableName', 'ListAnydataQTable')"/>
                                        <uix:submitButton shortDescBinding="SPECIFY_STORAGE_PARAMETERS@aqMsgs" textBinding="SPECIFY_STORAGE_PARAMETERS@aqMsgs" name="event" value="createNewQTable"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="QTABLE_HINT@aqMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText labeledNodeId="queueUser" styleClass="OraInstructionText" textBinding="QUEUE_USER@aqMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField shortDescBinding="QUEUE_USER@aqMsgs" searchDescBinding="QUEUE_USER@aqMsgs" columns="50" id="queueUser" name="queueUser" textBinding="schemaName@queueAdminBean@servletRequest" onClick="startLov('queueUser', 'ListSchema')" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                                                
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="SECURE_QUEUE_USER@aqMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                                                
                                                
                                                
                                                
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText  labeledNodeId="description" styleClass="OraInstructionText" textBinding="DESCRIPTION@dbMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput shortDescBinding="DESCRIPTION@dbMsgs" id="description" name="description" textBinding="description@queueMainBean@servletRequest" columns="50"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>


                        <uix:spacer height="10" width="10"/>                     

</uix:contents>
  <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
			    <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                            <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
			     <uix:submitButton shortDescBinding="BACK@dbMsgs" textBinding="BACK@dbMsgs" name="event" value="goBack"/>									 
                            <uix:submitButton shortDescBinding="FINISH@aqMsgs" textBinding="FINISH@aqMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="CREATE_ANYDATA_QUEUE_INSTR@aqMsgs"/>
                      </uix:pageStatus>
                      
      </uix:pageLayout>    


</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>
