<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="createQueue" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType,sname, oname">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/editQueue"/>
 <uix:pageLayout titleBinding="header@servletRequest">
<%@ include file="/database/global.jspf" %>
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
<uix:contents>

<uix:spacer height="10" width="10"/>
                        <uix:tableLayout hAlign="center" width="75%">
                          <uix:contents>
                            <uix:rowLayout hAlign="center">
                              <uix:contents>
                                <uix:labeledFieldLayout columns="1" width="60%">
                                  <uix:contents>
                                    <uix:messageStyledText shortDescBinding="SCHEMA@dbMsgs" promptBinding="SCHEMA@dbMsgs" styleClass="OraDataText" textBinding="schemaName@queueMainBean@servletRequest"/>
                                    <uix:messageStyledText shortDescBinding="QUEUE_TABLE@aqMsgs" promptBinding="QUEUE_TABLE@aqMsgs" styleClass="OraDataText" textBinding="queueTableNameForEdit@queueMainBean@servletRequest"/>
	<uix:switcher childNameBinding="queueTypeForEdit@queueMainBean@servletRequest">
	<uix:case name="0">
                                    <uix:messageStyledText shortDescBinding="QTYPE@aqMsgs" promptBinding="QTYPE@aqMsgs" styleClass="OraDataText" textBinding="NORMAL_QUEUE_ID@aqMsgs"/>
	</uix:case>
        <uix:case name="1">
                                    <uix:messageStyledText shortDescBinding="QTYPE@aqMsgs" promptBinding="QTYPE@aqMsgs" styleClass="OraDataText" textBinding="NON_PERSISTENT_QUEUE@aqMsgs"/>
	</uix:case>
        <uix:case name="2">
                                    <uix:messageStyledText shortDescBinding="QTYPE@aqMsgs" promptBinding="QTYPE@aqMsgs" styleClass="OraDataText" textBinding="EXCEPTION_QUEUE@aqMsgs"/>
	</uix:case>
        </uix:switcher>
                                    <uix:messageCheckBox disabled="true" name="enqEnabled" shortDescBinding="ENQENABLE@aqMsgs" textBinding="ENQENABLE@aqMsgs" checkedBinding="enqueueEnabledForEdit@queueMainBean@servletRequest"/>
                                    <uix:messageCheckBox name="deqEnabled" disabled="true" shortDescBinding="DEQENABLE@aqMsgs" textBinding="DEQENABLE@aqMsgs" checkedBinding="dequeueEnabledForEdit@queueMainBean@servletRequest"/>

<uix:switcher childNameBinding="queueType@queueMainBean@servletRequest">
<uix:case name="0">
                                    <uix:messageTextInput columns="5" disabled="false" messageBinding="MAX_RETRIES_TIP@aqMsgs" name="maxRetries" shortDescBinding="MAX_RETRIES@aqMsgs" promptBinding="MAX_RETRIES@aqMsgs" textBinding="maxRetries@queueMainBean@servletRequest"/>
</uix:case>
<uix:default>
 <uix:messageTextInput columns="5" disabled="true" shortDescBinding="MAX_RETRIES@aqMsgs" messageBinding="MAX_RETRIES_TIP@aqMsgs" name="maxRetries" promptBinding="MAX_RETRIES@aqMsgs" textBinding="maxRetries@queueMainBean@servletRequest"/>
</uix:default>
</uix:switcher>


<uix:switcher childNameBinding="queueType@queueMainBean@servletRequest">
<uix:case name="0">
                                    <uix:messageTextInput columns="5" disabled="false" messageBinding="RETRY_DELAY_TIP@aqMsgs" name="retryDelay" shortDescBinding="RETRY_DELAY@aqMsgs" promptBinding="RETRY_DELAY@aqMsgs" textBinding="retryDelay@queueMainBean@servletRequest"/>
</uix:case>
<uix:default>
 <uix:messageTextInput columns="5" shortDescBinding="RETRY_DELAY@aqMsgs" disabled="true" messageBinding="RETRY_DELAY_TIP@aqMsgs" name="retryDelay" promptBinding="RETRY_DELAY@aqMsgs" textBinding="retryDelay@queueMainBean@servletRequest"/>
</uix:default>
</uix:switcher>

<uix:switcher childNameBinding="queueType@queueMainBean@servletRequest">
<uix:case name="0">
                                    <uix:messageTextInput columns="5" disabled="false" messageBinding="RETENTION_TIME_TIP@aqMsgs" name="retentionTime" shortDescBinding="RETENTION_TIME@aqMsgs" promptBinding="RETENTION_TIME@aqMsgs" textBinding="retentionTime@queueMainBean@servletRequest"/>
</uix:case>
<uix:default>                                   
				     <uix:messageTextInput columns="5" disabled="true" messageBinding="RETENTION_TIME_TIP@aqMsgs" name="retentionTime" shortDescBinding="RETENTION_TIME@aqMsgs" promptBinding="RETENTION_TIME@aqMsgs" textBinding="retentionTime@queueMainBean@servletRequest"/>
</uix:default>
</uix:switcher>
                                    <uix:messageTextInput columns="50" name="description" shortDescBinding="DESCRIPTION@dbMsgs" promptBinding="DESCRIPTION@dbMsgs" textBinding="description@queueMainBean@servletRequest"/>
                                  </uix:contents>
                                </uix:labeledFieldLayout>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>

</uix:contents>
   <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                            <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                            <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
</uix:pageLayout>    


</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>
