<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <uix:dataScope currentDataBinding="stateDetailsBean@servletRequest">
                <db:form name="messageDetail" method="post" destinationBinding="destination@servletRequest" copyParams="target,type, QTABLENAME, oname, sname,otype,objectType,IS_80_COMPATIBLE,state ">
                    <uix:formValue name="pageName" value="/database/dist/streams/queue/messageDetails"/>    
                    <uix:pageLayout titleBinding="header@servletRequest">
                        <%@ include file="/database/global.jspf" %>
                        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <uix:contents>
                            <uix:spacer height="10" width="10"/>
                                <uix:separator/>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                            <uix:dataScope currentDataBinding="stateDetailsBean@servletRequest">
                                                <uix:table name="messageStateDetailsList" 
                                                alternateTextBinding="messageAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
						summaryBinding="messageAlterText"
												shortDescBinding="header@servletRequest"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column renderedBinding="isNonQ80Compatible">
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="CONS_NAME@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:link destinationBinding="detailsURL" textBinding="<%= AQMsgID.CONS_NAME %>" />
                                                </uix:column>
                                                <uix:column renderedBinding="isNonQ80Compatible">
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="CONS_ADDR@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= AQMsgID.CONS_ADDR %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="DEQUEUE_TIME@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                                <uix:text textBinding="<%= AQMsgID.DEQUEUE_TIME %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="DEQ_USER_ID@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= AQMsgID.DEQ_USER_ID %>" /> 
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="DEQ_TRANS_ID@aqMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                                <uix:text textBinding="<%= AQMsgID.DEQ_TRANS_ID %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="RETRY_COUNT@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="numberFormat" width="10%"/>
                                                <uix:text textBinding="<%= AQMsgID.RETRY_COUNT %>" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="EXPIRATION_REASON@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                <uix:text textBinding="<%= AQMsgID.EXPIRATION_REASON %>" />
                                                </uix:column>
                                                </uix:table>
                                                </uix:dataScope>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                        </uix:contents>
                        <uix:pageStatus>
                        <uix:tableLayout width="50%">
                            <uix:contents>
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="center" vAlign="top" >
                                        <uix:contents>
                                            <uix:tableLayout>
                                                <uix:contents>
                                                    <uix:rowLayout renderedBinding="forQTable@servletRequest">
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="QNAME@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                           <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left" columnSpan="2">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraDataText" textBinding="QName"/> 
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout> 
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="ID@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraDataText" textBinding="<%= AQMsgID.ID %>"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="PRIORITY@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:rowLayout>
                                                                        <uix:contents>
                                                                            <uix:messageStyledText styleClass="OraDataText" textBinding="priority"/>
                                                                        </uix:contents>
                                                                    </uix:rowLayout>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="ENQUEUE_TIME@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraDataText" textBinding="enqueueTime"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="5" width="10"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                        
                                                </uix:contents>
                                            </uix:tableLayout>
                                        </uix:contents>
                                    </uix:cellFormat>
                                    
                                </uix:contents>
                            </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                        </uix:pageStatus>
                    </uix:pageLayout>
                </db:form>
            </uix:dataScope>
        </uix:body>           
    </uix:document>
</uix:renderingContext>
                    
                    
                    
                    
                    
