<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script>
        function startLovAfterValidation(lovUrl)
        {
    
          if ((document.messageList.QName.value.length==0) ||
                (document.messageList.QName.value==null)) {
                submitForm('messageList', true, {event:'dispLovValidationError'})
            }
          else { openWindow(window, lovUrl + "&queueNameForSubs=" + document.messageList.QName.value 
            ,'subsLovWindow',{width:700, height:600},true, 'dialog',callBackLovField);}
        }
        function startLovWithoutValidation(lovUrl)
        {
          openWindow(window, lovUrl,'subsLovWindow',{width:700, height:600},true, 'dialog',callBackLovField);
        }
      </script>
        <uix:body>
        <uix:dataScope currentDataBinding="messageListBean@servletRequest">
            <db:form name="messageList" method="post" destinationBinding="destination@servletRequest" copyParams="target,type, QTABLENAME, oname, sname, otype,objectType,IS_80_COMPATIBLE">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/messageList"/>
                <uix:formValue name="snameForLov" valueBinding="snameForLov@servletRequest"/>
                <uix:formValue name="onameForLov" valueBinding="onameForLov@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        
                    <uix:header textBinding="SEARCH@dbMsgs">
                        <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">
                            <uix:contents>
                            <uix:rowLayout>
                                <uix:contents>
                                <uix:cellFormat hAlign="center" vAlign="top" width="50%">
                                    <uix:contents>
                                    <uix:tableLayout>
                                        <uix:contents>
                                        <uix:rowLayout renderedBinding="forQTable@servletRequest">
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="qname" styleClass="OraInstructionText" textBinding="QNAME@aqMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="3"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left" columnSpan="2">
                                                    <uix:contents>
                                                       <uix:messageLovField name="QName" shortDescBinding="QNAME@aqMsgs" 
														id="qname" searchDescBinding="QNAME@aqMsgs" 
                                                        onClick="setBindSqlParm('snameForLov');setBindSqlParm('onameForLov');startLov('QName','ListQueue')" 
                                                        textBinding="qName" 
                                                        columns="22"/> 
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="STATE@aqMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="3"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageChoice name="messageState" shortDescBinding="messageState" 
                                                            selectedValueBinding="messageState">
                                                            <uix:contents>
                                                                <uix:option textBinding="ALL@aqMsgs" value="ALL"/>
                                                                <uix:option textBinding="MESSAGE_STATE_READY@aqMsgs" value="READY"/>
                                                                <uix:option textBinding="MESSAGE_STATE_PROCESSED@aqMsgs" value="PROCESSED"/>
                                                                <uix:option textBinding="MESSAGE_STATE_UNDELIVERABLE@aqMsgs" value="UNDELIVERABLE"/>
                                                                <uix:option textBinding="MESSAGE_STATE_WAITING@aqMsgs" value="WAIT"/>
                                                                <uix:option textBinding="MESSAGE_STATE_EXPIRED@aqMsgs" value="EXPIRED"/>
                                                                <uix:option renderedBinding="versionEqualOrHigher101" textBinding="MESSAGE_STATE_SPILLED@aqMsgs" value="SPILLED"/>
                                                                <uix:option renderedBinding="versionEqualOrHigher101" textBinding="MESSAGE_STATE_IN_MEMORY@aqMsgs" value="IN MEMORY"/>
                                                                <uix:option renderedBinding="versionEqualOrHigher101" textBinding="MESSAGE_STATE_DEFERRED@aqMsgs" value="DEFERRED"/>
                                                                <uix:option renderedBinding="versionEqualOrHigher101" textBinding="MESSAGE_STATE_DEFERRED_SPILLED@aqMsgs" value="DEFERRED_SPILLED"/>
                                                                <uix:option renderedBinding="versionEqualOrHigher102" textBinding="MESSAGE_STATE_BUFFERED_EXPIRED@aqMsgs" value="BUFFERED_EXPIRED"/>
                                                            </uix:contents>
                                                        </uix:messageChoice>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="PRIORITY@aqMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="3"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:rowLayout>
                                                            <uix:contents>
                                                                <uix:messageChoice name="priorityOption" shortDescBinding="priorityOptionString"
                                                                    selectedValueBinding="priorityOptionString">
                                                                    <uix:contents>
                                                                        <uix:option textBinding="IS@aqMsgs" value="0"/>
                                                                        <uix:option textBinding="IS_NOT@aqMsgs" value="1"/>
                                                                        <uix:option textBinding="GREATER_THAN@aqMsgs" value="2"/>                                                                       
                                                                        <uix:option textBinding="LESS_THAN@aqMsgs" value="3"/>
                                                                    </uix:contents>
                                                                </uix:messageChoice>
                                                                <uix:messageTextInput shortDescBinding="PRIORITY@aqMsgs" columns="5" name="priority" textBinding="priority"/>
                                                            </uix:contents>
                                                        </uix:rowLayout>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="5" width="10"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                            <uix:cellFormat>
                                                <uix:contents/>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                                <uix:contents/>
                                            </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:submitButton textBinding="GO@dbMsgs" name="event" value="search"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        </uix:contents>
                                    </uix:tableLayout>
                                    </uix:contents>
                                </uix:cellFormat>
                                    <uix:cellFormat hAlign="center" vAlign="top" width="50%">
                                        <uix:contents>
                                            <uix:tableLayout>
                                                <uix:contents>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="ENQUEUE_TIME@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageChoice name="enqueueTimeOption" shortDescBinding="enqueueTimeOptionString" 
                                                                        selectedValueBinding="enqueueTimeOptionString">
                                                                        <uix:contents>
                                                                            <uix:option textBinding="ALL@aqMsgs" value="0"/>
                                                                            <uix:option textBinding="LAST_15_MINS@aqMsgs" value="1"/>
                                                                            <uix:option textBinding="LAST_30_MINS@aqMsgs" value="2"/>
                                                                            <uix:option textBinding="LAST_1_HR@aqMsgs" value="3"/>
                                                                            <uix:option textBinding="LAST_24_HR@aqMsgs" value="4"/>
                                                                            <uix:option textBinding="LAST_7_DAYS@aqMsgs" value="5"/>
                                                                            <uix:option textBinding="MORE_THAN_7_DAYS@aqMsgs" value="6"/>
                                                                        </uix:contents>
                                                                    </uix:messageChoice>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="DEQUEUE_TIME@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageChoice name="dequeueTimeOption" shortDescBinding="dequeueTimeOptionString" 
                                                                        selectedValueBinding="dequeueTimeOptionString">
                                                                        <uix:contents>
                                                                            <uix:option textBinding="ALL@aqMsgs" value="0"/>
                                                                            <uix:option textBinding="LAST_15_MINS@aqMsgs" value="1"/>
                                                                            <uix:option textBinding="LAST_30_MINS@aqMsgs" value="2"/>
                                                                            <uix:option textBinding="LAST_1_HR@aqMsgs" value="3"/>
                                                                            <uix:option textBinding="LAST_24_HR@aqMsgs" value="4"/>
                                                                            <uix:option textBinding="LAST_7_DAYS@aqMsgs" value="5"/>
                                                                            <uix:option textBinding="MORE_THAN_7_DAYS@aqMsgs" value="6"/>
                                                                        </uix:contents>
                                                                    </uix:messageChoice>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                     <uix:rowLayout renderedBinding="isNonQ80Compatible">
                                                        <uix:contents>
                                                            <uix:cellFormat hAlign="right">
                                                                <uix:contents>
                                                                    <uix:messageStyledText labeledNodeId="consumerName" shortDescBinding="CONSUMER@aqMsgs" 
									styleClass="OraInstructionText" textBinding="CONSUMER@aqMsgs"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageLovField id="consumerName" onClickBinding="lovDest@servletRequest" 
									shortDescBinding="CONSUMER@aqMsgs"  
									searchDescBinding="CONSUMER@aqMsgs" 
									columns="23" name="fullConsName" textBinding="fullConsName"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                     <uix:rowLayout renderedBinding="isNonQ80Compatible">
                                                        <uix:contents>
                                                            <uix:cellFormat/> 
                                                            <uix:cellFormat/>
                                                                
                                                            <uix:cellFormat hAlign="left">
                                                                <uix:contents>
                                                                    <uix:messageStyledText textBinding="CONS_FORMAT_MSG@aqMsgs" styleClass="OraInlineInfoText"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    
                                                </uix:contents>
                                            </uix:tableLayout>
                                        </uix:contents>
                                    </uix:cellFormat>
                                </uix:contents>
                            </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                            <uix:separator/>
                            <uix:spacer height="10" width="10"/>
                            <uix:tableLayout width="100%">
                                <uix:contents>
                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            <uix:table name="messageList" 
                                            alternateTextBinding="messageAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="rowData"
                                            minValue="1"
                                            valueBinding="startIndex" 
					    summaryBinding="messageAlterText"
											shortDescBinding="header@servletRequest"
                                            blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                            maxValueBinding="<%= StreamsConstants.NUM_ROWS %>">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ID@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:link destinationBinding="detailsURL" textBinding="<%= AQMsgID.ID %>" />
                                            </uix:column>
                                            <uix:column renderedBinding="forQTable@servletRequest">
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="QNAME@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:text textBinding="<%= AQMsgID.QNAME %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="PRIORITY@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="numberFormat" width="7%"/>
                                            <uix:text textBinding="<%= AQMsgID.PRIORITY %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="CONS_DIFF_STATES@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat width="10%" columnDataFormat="textFormat"/>
                                            <contents>
                                             <uix:include nodeBinding="<%= AQMsgID.CONS_DIFF_STATES %>"/>
                                            </contents>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ENQUEUE_TIME@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                            <uix:text textBinding="<%= AQMsgID.ENQUEUE_TIME %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ENQ_USER_ID@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:text textBinding="<%= AQMsgID.ENQ_USER_ID %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ENQ_TRANS_ID@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:text textBinding="<%= AQMsgID.ENQ_TRANS_ID %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="DELAY@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                            <uix:text textBinding="<%= AQMsgID.DELAY %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="EXPIRATION@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="numberFormat"/>
                                            <uix:text textBinding="<%= AQMsgID.EXPIRATION %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="EXCEPTION_QUEUE_NAME@aqMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:text textBinding="<%= AQMsgID.EXCEPTION_QUEUE_NAME %>" />
                                            </uix:column>
                                            </uix:table> 
                                        </uix:contents>
                                    </uix:rowLayout>
                                </uix:contents>
                            </uix:tableLayout>
                        </uix:contents>
                    </uix:header>
                    </uix:contents>
                </uix:pageLayout>
            </db:form>
            </uix:dataScope>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>

