<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"></uix:bundle>
  <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"></uix:bundle>

    <uix:document>
      <uix:metaContainer><!-- Set the page title -->
        <uix:head titleBinding="title@servletRequest"></uix:head>
      </uix:metaContainer>
      
      <uix:body>
        <db:form name="propagationErrorDetailsForm" method="post" destination="/console/database/dist/streams/overviewDetails" copyParams="target,type">
          <uix:formValue name="pageName" value="/database/dist/streams/queue/propagationErrorDetails"/>
          <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf"%>
            <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"></oem:messageBox>
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"></oem:messageBox><!--main contents --><!-- main contents -->
            <uix:spacer height="20" width="10"/>
            
            <uix:tableLayout hAlign="center" width="70%">
            
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" width="50%">
                  <uix:messageStyledText styleClass="OraInstructionText" textBinding="DESTINATION@aqMsgs"></uix:messageStyledText>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:spacer height="10" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="50%">
                  <uix:messageStyledText styleClass="OraDataText" textBinding="DESTINATION@servletRequest"></uix:messageStyledText>
                </uix:cellFormat>
              </uix:rowLayout>
            
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" width="50%">
                  <uix:messageStyledText styleClass="OraInstructionText" textBinding="FAILURES_IN_CURRENT_PROPAGATION@aqMsgs"></uix:messageStyledText>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:spacer height="10" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="50%">
                  <uix:messageStyledText styleClass="OraDataText" textBinding="FAILURES@servletRequest"></uix:messageStyledText>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" width="50%">
                  <uix:messageStyledText styleClass="OraInstructionText" textBinding="LAST_ERROR_OCCURED_AT@aqMsgs"></uix:messageStyledText>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" >
                  <uix:spacer height="10" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="50%">
                  <uix:messageStyledText styleClass="OraDataText" textBinding="LAST_ERROR_TIME@servletRequest"></uix:messageStyledText>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" width="30%">
                  <uix:messageStyledText styleClass="OraInstructionText" textBinding="LAST_ERROR_MESSAGE@aqMsgs" labeledNodeId="messageTextInput2" ></uix:messageStyledText>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:spacer height="10" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="70%">
                   <%-- <uix:messageStyledText styleClass="OraDataText" textBinding="LAST_ERROR_MESSAGE@servletRequest"></uix:messageStyledText>--%>
                  <uix:messageTextInput columns="75" name="messageTextInput2" rows="5" 
                                        id="messageTextInput2"
                                        shortDescBinding="LAST_ERROR_MESSAGE@aqMsgs"
                                        textBinding="LAST_ERROR_MESSAGE@servletRequest" 
                                        wrap="soft" readOnly="true">
                  </uix:messageTextInput> 
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:spacer height="10" width="10"/>

	    <%-- navigation -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding ="OK@dbMsgs" name="event" value="redisplayErrorsList"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

            <%--<uix:pageStatus>
                <uix:formattedText styleClass="OraInstructionText" textBinding="ErrorDetailsInfo@servletRequest"/>
            </uix:pageStatus>--%>
            
          </uix:pageLayout>
        </db:form>
      </uix:body>
    </uix:document>
  </uix:renderingContext>

