<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID"%>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <db:script src="/database/LOV.js"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

    <uix:document>
      <uix:metaContainer><!--Set the page title -->
        <uix:head titleBinding="title@servletRequest"></uix:head>
      </uix:metaContainer>

      <uix:body>
        <db:form name="propagationErrorsListForm" method="post" destination="/console/database/dist/streams/overviewDetails" copyParams="target,type,otype,objectType">

          <uix:formValue name="pageName" value="/database/dist/streams/queue/propagationErrorsList"/>
          <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>

          <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf" %>
            <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
		<!--main contents -->
            <uix:spacer height="10" width="10"/>
            <uix:messageStyledText textBinding="PROPAGATION_ERROR_MESSAGE@aqMsgs" styleClass="OraInstructionText"/>
            <uix:spacer height="10" width="10"/>

            <!--  Search contents begin   -->
            <uix:header textBinding="SEARCH@dbMsgs">

                    <%--<uix:messageStyledText styleClass="OraInstructionText" textBinding="PROPAGATION_ERROR_SEARCH_INSTR@aqMsgs"/>--%>
                    <uix:spacer height="10" width="10"/>
                    <uix:tableLayout width="50%" cellSpacing="5">
                      <uix:contents>
                      
                        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="SOURCE_QUEUE@aqMsgs" labeledNodeId="queueSearchName"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat/>

                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:messageLovField name="queueSearchName" id="queueSearchName" 
                                                     textBinding="queueSearchName@propagationErrorsListBean@servletRequest" 
                                                     columns="30" 
                                                     shortDescBinding="SOURCE_QUEUE@aqMsgs"
                                                     onClick="startLov('queueSearchName','ListAllNormalQueues')"/>
                                <%--<uix:messageTextInput name="queueSearchName" textBinding="queueSearchName@propagationErrorsListBean@servletRequest"/>--%>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat/>
                          </uix:contents>
                        </uix:rowLayout>                      
                      
                        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DESTINATION@aqMsgs" labeledNodeId="destinationSearchName"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat/>

                            <uix:cellFormat hAlign="left">
                              <uix:contents>
                                <uix:messageLovField name="destinationSearchName" id="destinationSearchName" 
                                                     textBinding="destinationSearchName@propagationErrorsListBean@servletRequest" 
                                                     columns="30" 
                                                     shortDescBinding="DESTINATION@aqMsgs"
                                                     onClick="startLov('destinationSearchName','ListSchemaDBLink')"/>
                              </uix:contents>
                            </uix:cellFormat>                                        

                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout width="100%">
                            <uix:contents>
                                <uix:cellFormat/>
                                <uix:cellFormat/>
                                <uix:cellFormat hAlign="left" width="75%">
                                    <uix:contents>
                                        <uix:submitButton textBinding="GO@dbMsgs" shortDescBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>

                      </uix:contents>
                    </uix:tableLayout>
                    <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                    <uix:separator/>                        

                <!--   Search contents end  -->
            
            
            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%">
              
              <!-- Table data begin -->
              <uix:dataScope currentDataBinding="propagationErrorsListBean@servletRequest">
                <uix:table name="propagationErrorsListTable" 
                    alternateTextBinding="tableAlternateText"
                    formSubmitted="true" 
                    width="100%" 
                    tableDataBinding="rowData" 
                    minValue="1" 
                    valueBinding="startIndex" 
                    blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                    maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                    shortDescBinding="PROPAGATION_ERRORS_TABLE@aqMsgs"
                    summaryBinding="PROPAGATION_ERRORS_TABLE@aqMsgs">
                    
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="SCHEMA@aqMsgs" sortable="true"/>
                  </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.SCHEMA %>"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="SOURCE_QUEUE@aqMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.SOURCE_QUEUE%>"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="DESTINATION@aqMsgs" sortable="true"/>
                  </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.DESTINATION %>"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="FAILURES@aqMsgs" sortable="true"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.FAILURES %>"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LAST_ERROR_TIME@aqMsgs" sortable="no"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.LAST_ERROR_TIME %>"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LAST_ERROR_MESSAGE@aqMsgs" sortable="no"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AQMsgID.LAST_ERROR_MESSAGE %>"
                                    destinationBinding="ErrorMessageURL@propagationErrorsListBean@servletRequest" />
                  </uix:column>                  
                </uix:table>
                </uix:dataScope>
                <!-- Table data end -->

              </uix:rowLayout>
            </uix:tableLayout>
            </uix:header>
            <uix:spacer height="10" width="10"/>

          </uix:pageLayout>
        </db:form>
      </uix:body>
    </uix:document>
  </uix:renderingContext>

