<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
        <uix:rawText>
			<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />        
		</uix:rawText>
    </uix:case>
  </uix:switcher>

    <uix:document>
      <uix:metaContainer>
        <!-- Set the page title -->
        <uix:head titleBinding="title@servletRequest"/>
      </uix:metaContainer>
        <uix:body>
            <db:form name="propagationStatsForm" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType,sname, oname, isBufferQueue, QTYPE">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/propagationStats"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

			<!-- Main Contents Begin -->
                  <uix:contents>
                    <uix:tableLayout width="100%">
                      <uix:contents>
                        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:contents>
                                <uix:tableLayout width="100%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                          <uix:contents>
                                                <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESH@aqMsgs"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:submitButton textBinding="REFRESH@dbMsgs" shortDescBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout hAlign="right">
                                      <uix:contents>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="30" width="10"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <%-- <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@dbMsgs"/> --%>

                                                  <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" shortDescBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                      onChange="submitForm('propagationStatsForm', true, {'event':'refreshStatistics'})"
                                                       selectedValueBinding="refreshHomeSelected@servletRequest">
                                                    <uix:option textBinding="MANUAL_REFRESH@aqMsgs"
                                                      value="RT_MAN"/>
                                                    <uix:option textBinding="AUTOMATIC_REFRESH@aqMsgs"
                                                      value="RT_60"/> 
                                                  </uix:messageChoice>          
                                                
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                    <uix:subTabLayout>
                      <uix:contents>
	<uix:spacer height="10" width="10"/>
                        <!-- Table data begin -->
        <uix:dataScope currentDataBinding="propagationStatsList@servletRequest">
	<uix:table name="propagationStatsTable" 
		alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
		formSubmitted="true"
		width="100%"
		tableDataBinding="rowData"
		minValue="1"
		valueBinding="startIndex"
                blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                shortDescBinding="PROPAGATION_LIST_TABLE@aqMsgs"
		summaryBinding="PROPAGATION_LIST_TABLE@aqMsgs">
               
			<uix:tableFormat tableBanding="rowBanding"/>
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="PROPAGATION_TARGET@aqMsgs" sortable="no"/>
			  </uix:columnHeader> 
			  <uix:columnFormat columnDataFormat="textFormat" />
			  <uix:styledText textBinding="<%= AQMsgID.PROPAGATION_TARGET %>"/>
			</uix:column>
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="PROPAGATION_ENABLED@aqMsgs" sortable="no"/>
			  </uix:columnHeader> 
			  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
			  <uix:image sourceBinding="<%= AQMsgID.PROPAGATION_ENABLED %>"/>
			</uix:column>
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="PROPAGATION_START_TIME@aqMsgs" sortable="no"/>
			  </uix:columnHeader>
			  <uix:columnFormat columnDataFormat="textFormat"/>
			  <uix:styledText textBinding="<%= AQMsgID.PROPAGATION_START_TIME %>"/>
			</uix:column>
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="NEXT_SCHEDULED_TIME@aqMsgs" sortable="no"/>
			  </uix:columnHeader>
			  <uix:columnFormat columnDataFormat="textFormat"/>
			  <uix:styledText textBinding="<%= AQMsgID.NEXT_SCHEDULED_TIME %>"/>
			</uix:column>			
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="SESSION_ID@aqMsgs" sortable="no"/>
			  </uix:columnHeader>
			  <uix:columnFormat columnDataFormat="numberFormat"/>
			  <uix:styledText textBinding="<%= AQMsgID.SESSION_ID %>"/>
			</uix:column>
			<uix:column>
			  <uix:columnHeader>
			    <uix:sortableHeader textBinding="CLUSTER_DATABASE_INSTANCE@aqMsgs" sortable="no"/>
			  </uix:columnHeader>
			  <uix:columnFormat columnDataFormat="numberFormat"/>
			  <uix:styledText textBinding="<%= AQMsgID.CLUSTER_DATABASE_INSTANCE %>"/>
			</uix:column>
                

                <uix:tableSelection>
                          <uix:singleSelection selectedIndexBinding="SelectedRow@propagationStatsList@servletRequest" shortDescBinding="TABLE_SELECTION@aqMsgs" >
                               <uix:contents>
                                    <uix:submitButton textBinding ="SHOW_DETAILS@aqMsgs" shortDescBinding="SHOW_DETAILS@aqMsgs" name="event" value="showDetails"/>
                                </uix:contents>
                           </uix:singleSelection>
                 </uix:tableSelection>

	</uix:table>
	</uix:dataScope>
                        <!-- Table data end -->

                        
                        <uix:header renderedBinding="PropStatsRendered@propagationStatsList@servletRequest"  textBinding="destinationForDisplay@propStatsBean@servletRequest">
                          <uix:contents>
                            <uix:tableLayout>
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="left" vAlign="top" width="50%">
					<uix:header textBinding="INITIAL_STATS_TITLE@aqMsgs">
                                          <uix:contents>                                          
				             <uix:labeledFieldLayout>
				                 <uix:contents>
		                                    <uix:messageStyledText promptBinding="AVERAGE_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="avgNumberOfMessages@propStatsBean@servletRequest"/>
		                                    <uix:messageStyledText promptBinding="AVERAGE_PROPAGATED_MESSAGE_SIZE@aqMsgs" styleClass="OraDataText" textBinding="avgSizeOfMessages@propStatsBean@servletRequest"/>
                		                    <uix:messageStyledText promptBinding="AVERAGE_PROPAGATED_MESSAGE_TIME@aqMsgs" styleClass="OraDataText" textBinding="avgTimeForMessages@propStatsBean@servletRequest"/>
                                		    <uix:messageStyledText promptBinding="MAX_BYTES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="maxBytesPropagated@propStatsBean@servletRequest"/>
                                              	    <uix:messageStyledText promptBinding="MAX_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="maxMessagesPropagated@propStatsBean@servletRequest"/>
						    <uix:messageStyledText promptBinding="TOTAL_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="totalMsgPropagated@propStatsBean@servletRequest"/>
						    <uix:messageStyledText promptBinding="TOTAL_BYTES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="totalBytesPropagated@propStatsBean@servletRequest"/>
					            <uix:messageStyledText promptBinding="TOTAL_TIME_SPENT@aqMsgs" styleClass="OraDataText" textBinding="totalTime@propStatsBean@servletRequest"/>
				                 </uix:contents>
				             </uix:labeledFieldLayout>
                                          </uix:contents>
                                        </uix:header>
                                    </uix:cellFormat>
                                    <uix:cellFormat vAlign="top" width="50%">
                                      <uix:contents>
	 			      <uix:header textBinding="INITIAL_BUFFERED_STATS_TITLE@aqMsgs">
                                          <uix:contents>
                                            <uix:labeledFieldLayout>
                                              <uix:contents>
					      
                                                <uix:messageStyledText promptBinding="AVERAGE_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="avgNumberOfMessagesForBuffered@propStatsBean@servletRequest"/>
                                                <uix:messageStyledText promptBinding="AVERAGE_PROPAGATED_MESSAGE_SIZE@aqMsgs" styleClass="OraDataText" textBinding="avgSizeOfMessagesForBuffered@propStatsBean@servletRequest"/>
                                                <uix:messageStyledText promptBinding="AVERAGE_PROPAGATED_MESSAGE_TIME@aqMsgs" styleClass="OraDataText" textBinding="avgTimeForMessagesForBuffered@propStatsBean@servletRequest"/>
                                                <uix:messageStyledText promptBinding="MAX_BYTES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="maxBytesPropagatedForBuffered@propStatsBean@servletRequest"/>
                                                <uix:messageStyledText promptBinding="MAX_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="maxMessagesPropagatedForBuffered@propStatsBean@servletRequest"/>
					      
						<uix:messageStyledText promptBinding="TOTAL_MESSAGES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="totalMsgPropagatedForBuffered@propStatsBean@servletRequest"/>
						<uix:messageStyledText promptBinding="TOTAL_BYTES_PROPAGATED@aqMsgs" styleClass="OraDataText" textBinding="totalBytesPropagatedForBuffered@propStatsBean@servletRequest"/>
						<uix:messageStyledText promptBinding="TOTAL_TIME_SPENT@aqMsgs" 	styleClass="OraDataText" textBinding="totalTimeForBuffered@propStatsBean@servletRequest"/>
					      
                                              </uix:contents>
                                            </uix:labeledFieldLayout>
                                          </uix:contents>
                                        </uix:header>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>                                                                                                        
                            
                            <uix:tableLayout hAlign="left">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat >
                                      <uix:contents>
					<uix:header textBinding="FAILURES@aqMsgs">
                                          <uix:contents>
                                            <%-- UI Exit review changes: Remove the labled Field layout here and add only to below text. This is to remove the unnecessary tab that comes for hint text.--%>
                                            <uix:messageStyledText messageBinding="MSG_EXECUTION_FAILED_COUNT@aqMsgs" promptBinding="EXECUTION_FAILED_COUNT@aqMsgs" styleClass="OraDataText" textBinding="failedExecutionCount@propStatsBean@servletRequest"/>
                                            <uix:labeledFieldLayout>
                                              <uix:contents> 
                                              <uix:spacer height="5" width="178"/>
                                                <uix:messageStyledText promptBinding="LAST_ERROR_TIME@aqMsgs" styleClass="OraDataText" textBinding="lastErrorTimeStamp@propStatsBean@servletRequest"/>
                                                <uix:messageTextInput name="messageTextInput0"
								promptBinding="LAST_ERROR_MESSAGE@aqMsgs"
								shortDescBinding="LAST_ERROR_MESSAGE@aqMsgs" 
								wrap="soft" readOnly="true" rows="5" columns="75" 
								textBinding="lastErrorMessage@propStatsBean@servletRequest"/>
					      
                                              </uix:contents>
                                            </uix:labeledFieldLayout>
                                          </uix:contents>
                                        </uix:header>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
			<uix:spacer height="10" width="10"/>
                        </uix:header>
                      </uix:contents>
                      <uix:subTabs>
                        <uix:subTabBar selectedIndex="0">
                          <uix:contents>
                            <uix:link renderedBinding="IsPropStatsTabRendered@propagationStatsList@servletRequest" textBinding="QUEUE_PROPAGATION_STATS@aqMsgs"/>
                            <uix:link textBinding="QUEUE_MESSAGE_STATS@aqMsgs"  destinationBinding = "MessageQueueStatsURL@propagationStatsList@servletRequest"/>
                            <uix:link renderedBinding="IsBufferQRendered@propagationStatsList@servletRequest" textBinding="BUFFERED_QUEUE_STATS@aqMsgs" destinationBinding = "BufferedQueueStatsURL@propagationStatsList@servletRequest"/>
                          </uix:contents>
                        </uix:subTabBar>
                      </uix:subTabs>
                    </uix:subTabLayout>
                  </uix:contents>

			<!-- Main Contents End -->

		</uix:pageLayout>
		</db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
