<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:document>

        <uix:metaContainer>
            <uix:head titleBinding="CONFIRMATION@dbMsgs"/>
        </uix:metaContainer>
        <uix:body>
            <uix:contents>
                <db:form name="purgeConfirmation" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type, QTABLENAME, otype, objectType, oname, sname,IS_80_COMPATIBLE">
                    <uix:formValue name="pageName" value="/database/dist/streams/queue/purgeConfirmation"/>
                    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                    <uix:pageLayout messageType="confirmation">
                    <% if (request.getAttribute("em2goApp") != null) {%>
                    <%@ include file="/em2go/em2goGlobal.jspf" %>
                    <% } else {%>
                    <%@ include file="/database/globalPopup.jspf" %>
                    <%} %>

                    <% if (request.getAttribute("em2goApp") != null) {%>
                    <%@ include file="/em2go/em2goFooter.jspf" %>
                    <%}%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

                        <uix:stackLayout>
                            <uix:rowLayout>
                        <% if (request.getAttribute("em2goApp") == null) {%>
                                <uix:spacer width="40"/>
                        <%} %>
                                <uix:styledText styleClass="OraDataText"
                                textBinding="purgeConfirmationMsg@servletRequest"/>
                            </uix:rowLayout>
                            <uix:rowLayout/>
                        <uix:rowLayout>
                        <% if (request.getAttribute("em2goApp") == null) {%>
                                <uix:spacer width="40"/>
                        <%} %>
                        <%@ include file="/credentials.jspf"%>
                        </uix:rowLayout>
                        </uix:stackLayout>
                        <uix:pageButtons>
                            <uix:pageButtonBar>
                                <uix:submitButton name="event" shortDescBinding="NO@dbMsgs" textBinding="NO@dbMsgs" value="cancel"/>
                                <uix:submitButton name="event" shortDescBinding="YES@dbMsgs" textBinding="YES@dbMsgs" value="doPurge"/>
                            </uix:pageButtonBar>
                        </uix:pageButtons>

                    </uix:pageLayout>
                </db:form>
            </uix:contents>
        </uix:body>
    </uix:document>
</uix:renderingContext>
