<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script>
        function startLovAfterValidation(lovUrl)
        {
    
          if ((document.messageList.QName.value.length==0) ||
                (document.messageList.QName.value==null)) {
                submitForm('messageList', true, {event:'dispLovValidationError'})
            }
          else { openWindow(window, lovUrl + "&queueNameForSubs=" + document.messageList.QName.value 
            ,'subsLovWindow',{width:700, height:600},true, 'dialog',callBackLovField);}
        }
        function startLovWithoutValidation(lovUrl)
        {
          openWindow(window, lovUrl,'subsLovWindow',{width:700, height:600},true, 'dialog',callBackLovField);
        }
      </script>
        <uix:body>
            <db:form name="purgeCondition" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type, QTABLENAME, otype, objectType, oname, sname,IS_80_COMPATIBLE ">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/purgeMessage"/> 
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                    <uix:spacer height="10" width="10"/>
                    <uix:tableLayout hAlign="center" width="100%">
                        <uix:contents>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat hAlign="left">
                                    <uix:contents>
                                        <uix:messageCheckBox checkedBinding="block@purgeConditionBean@servletRequest" name="block" shortDescBinding="PURGE_BLOCK_INSTR@aqMsgs" textBinding="PURGE_BLOCK_INSTR@aqMsgs"/>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat>
                                    <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:contents>
                            <uix:cellFormat hAlign="left">
                                <uix:contents>
                                <uix:stackLayout>
                                    <uix:radioButton name="purgeAll"
                                    textBinding="PURGE_ALL_MESSAGES@aqMsgs"
                                    shortDescBinding="PURGE_ALL_MESSAGES@aqMsgs"
                                    value="true"
                                    selectedValueBinding="purgeAllString@purgeConditionBean@servletRequest"
                                    onClick="submitForm('purgeCondition',true,{'event':'purgeConditionChanged'})"/>
                                    <uix:rowLayout>
                                        <uix:contents/>
                                    </uix:rowLayout>
                                    <uix:radioButton name="purgeAll"
                                    textBinding="PURGE_CONDITIONAL_MESSAGES@aqMsgs"
                                    shortDescBinding="PURGE_CONDITIONAL_MESSAGES@aqMsgs"
                                    value="false"
                                    selectedValueBinding="purgeAllString@purgeConditionBean@servletRequest"
                                    onClick="submitForm('purgeCondition',true,{'event':'purgeConditionChanged'})"/>
                                    <uix:tableLayout width="70%">
                                        <uix:contents>
                                            <uix:rowLayout>
                                                <uix:contents>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                            <uix:spacer height="15" width="10"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                                <uix:contents>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                            <uix:spacer height="10" width="30"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat>
                                                        <uix:contents>
                                                    
                                                            <uix:stackLayout>
                                                                <uix:radioButton name="simpleCondition"
                                                                disabledBinding="purgeAll@purgeConditionBean@servletRequest"
                                                                textBinding="SIMPLE@aqMsgs"
                                                                shortDescBinding="SIMPLE@aqMsgs"
                                                                value="true"
                                                                selectedValueBinding="simpleConditionString@purgeConditionBean@servletRequest"/>
                                                                <uix:tableLayout width="120%">
                                                                    <uix:contents>
                                                                        <uix:rowLayout>
                                                                            <uix:contents>
                                                                                <uix:cellFormat>
                                                                                    <uix:contents>
                                                                                        <uix:spacer height="10" width="10"/>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                                <uix:cellFormat>
                                                                                    <uix:contents>
                                                                                        <uix:tableLayout width="100%">
                                                                                            <uix:contents>
                                                                                                <uix:rowLayout width="100%">
                                                                                                    <uix:contents>
                                                                                                        <uix:cellFormat>
                                                                                                            <uix:contents>
                                                                                                                <uix:spacer height="10" width="15"/>
                                                                                                            </uix:contents>
                                                                                                        </uix:cellFormat>
                                                                                                        <uix:cellFormat vAlign="top" width="50%">
                                                                                                            <uix:contents>
                                                                                                                <uix:tableLayout>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:rowLayout>
                                                                                                                            <uix:contents>
                                                                                                                                <uix:cellFormat hAlign="right">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageStyledText labeledNodeId="messageState" styleClass="OraInstructionText" textBinding="STATE@aqMsgs"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:spacer height="10" width="3"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageChoice shortDescBinding="STATE@aqMsgs" disabledBinding="purgeAll@purgeConditionBean@servletRequest" id="messageState" name="messageState" 
                                                                                                                                            selectedValueBinding="messageState@purgeConditionBean@servletRequest">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:option textBinding="ALL@aqMsgs" value="ALL"/>
                                                                                                                                                <uix:option textBinding="MESSAGE_STATE_READY@aqMsgs" value="READY"/>
                                                                                                                                                <uix:option textBinding="MESSAGE_STATE_PROCESSED@aqMsgs" value="PROCESSED"/>
                                                                                                                                                <uix:option textBinding="MESSAGE_STATE_UNDELIVERABLE@aqMsgs" value="UNDELIVERABLE"/>
                                                                                                                                                <uix:option textBinding="MESSAGE_STATE_WAITING@aqMsgs" value="WAIT"/>
                                                                                                                                                <uix:option textBinding="MESSAGE_STATE_EXPIRED@aqMsgs" value="EXPIRED"/>
                                                                                                                                                <uix:option renderedBinding="versionEqualOrHigher101@purgeConditionBean@servletRequest" textBinding="MESSAGE_STATE_SPILLED@aqMsgs" value="SPILLED"/>
                                                                                                                                                <uix:option renderedBinding="versionEqualOrHigher101@purgeConditionBean@servletRequest" textBinding="MESSAGE_STATE_IN_MEMORY@aqMsgs" value="IN MEMORY"/>
                                                                                                                                                <uix:option renderedBinding="versionEqualOrHigher101@purgeConditionBean@servletRequest" textBinding="MESSAGE_STATE_DEFERRED@aqMsgs" value="DEFERRED"/>
                                                                                                                                                <uix:option renderedBinding="versionEqualOrHigher101@purgeConditionBean@servletRequest" textBinding="MESSAGE_STATE_DEFERRED_SPILLED@aqMsgs" value="DEFERRED_SPILLED"/>
                                                                                                                                                <uix:option renderedBinding="versionEqualOrHigher102@purgeConditionBean@servletRequest" textBinding="MESSAGE_STATE_BUFFERED_EXPIRED@aqMsgs" value="BUFFERED_EXPIRED"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:messageChoice>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                            </uix:contents>
                                                                                                                        </uix:rowLayout>
                                                                                                                        <uix:rowLayout>
                                                                                                                            <uix:contents>
                                                                                                                                <uix:cellFormat hAlign="right">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="priorityOption" textBinding="PRIORITY@aqMsgs"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:spacer height="10" width="3"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:rowLayout>
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:messageChoice disabledBinding="purgeAll@purgeConditionBean@servletRequest" name="priorityOption" 
                                                                                                                                                    shortDescBinding="PRIORITY@aqMsgs" id="priorityOption" selectedValueBinding="priorityOptionString@purgeConditionBean@servletRequest">
                                                                                                                                                    <uix:contents>
                                                                                                                                                        <uix:option textBinding="IS@aqMsgs" value="0"/>
                                                                                                                                                        <uix:option textBinding="IS_NOT@aqMsgs" value="1"/>
                                                                                                                                                        <uix:option textBinding="GREATER_THAN@aqMsgs" value="2"/>                                                                       
                                                                                                                                                        <uix:option textBinding="LESS_THAN@aqMsgs" value="3"/>
                                                                                                                                                    </uix:contents>
                                                                                                                                                </uix:messageChoice>
                                                                                                                                                <uix:messageTextInput disabledBinding="purgeAll@purgeConditionBean@servletRequest" columns="5" shortDescBinding="PRIORITY@aqMsgs" name="priority" textBinding="priority@purgeConditionBean@servletRequest"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:rowLayout>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                            </uix:contents>
                                                                                                                        </uix:rowLayout>
                                                                                                                        <uix:rowLayout>
                                                                                                                            <uix:contents>
                                                                                                                                <uix:cellFormat hAlign="right">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageStyledText labeledNodeId="fullConsName" styleClass="OraInstructionText" textBinding="CONSUMER@aqMsgs"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:spacer height="10" width="3"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageLovField shortDescBinding="CONSUMER@aqMsgs" disabledBinding="purgeAll@purgeConditionBean@servletRequest" onClickBinding="lovDest@servletRequest" columns="23" name="fullConsName" id="fullConsName" textBinding="fullConsName@purgeConditionBean@servletRequest"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                            </uix:contents>
                                                                                                                        </uix:rowLayout>  
                                                                                                                    </uix:contents>
                                                                                                                </uix:tableLayout>
                                                                                                            </uix:contents>
                                                                                                        </uix:cellFormat>
                                                                                                        <uix:cellFormat vAlign="top" width="50%">
                                                                                                            <uix:contents>
                                                                                                                <uix:tableLayout>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:rowLayout>
                                                                                                                            <uix:contents>
                                                                                                                                <uix:cellFormat hAlign="right">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageStyledText labeledNodeId="enqueueTimeOption" styleClass="OraInstructionText" textBinding="ENQUEUE_TIME@aqMsgs"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:spacer height="10" width="3"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageChoice shortDescBinding="ENQUEUE_TIME@aqMsgs" disabledBinding="purgeAll@purgeConditionBean@servletRequest" id="enqueueTimeOption" name="enqueueTimeOption" 
                                                                                                                                            selectedValueBinding="enqueueTimeOptionString@purgeConditionBean@servletRequest">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:option textBinding="ALL@aqMsgs" value="0"/>
                                                                                                                                                <uix:option textBinding="LAST_15_MINS@aqMsgs" value="1"/>
                                                                                                                                                <uix:option textBinding="LAST_30_MINS@aqMsgs" value="2"/>
                                                                                                                                                <uix:option textBinding="LAST_1_HR@aqMsgs" value="3"/>
                                                                                                                                                <uix:option textBinding="LAST_24_HR@aqMsgs" value="4"/>
                                                                                                                                                <uix:option textBinding="LAST_7_DAYS@aqMsgs" value="5"/>
                                                                                                                                                <uix:option textBinding="MORE_THAN_7_DAYS@aqMsgs" value="6"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:messageChoice>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                            </uix:contents>
                                                                                                                        </uix:rowLayout>
                                                                                                                        <uix:rowLayout>
                                                                                                                            <uix:contents>
                                                                                                                                <uix:cellFormat hAlign="right">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="dequeueTimeOption" textBinding="DEQUEUE_TIME@aqMsgs"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:spacer height="10" width="3"/>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:messageChoice shortDescBinding="DEQUEUE_TIME@aqMsgs" disabledBinding="purgeAll@purgeConditionBean@servletRequest" id="dequeueTimeOption" name="dequeueTimeOption" 
                                                                                                                                            selectedValueBinding="dequeueTimeOptionString@purgeConditionBean@servletRequest">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:option textBinding="ALL@aqMsgs" value="0"/>
                                                                                                                                                <uix:option textBinding="LAST_15_MINS@aqMsgs" value="1"/>
                                                                                                                                                <uix:option textBinding="LAST_30_MINS@aqMsgs" value="2"/>
                                                                                                                                                <uix:option textBinding="LAST_1_HR@aqMsgs" value="3"/>
                                                                                                                                                <uix:option textBinding="LAST_24_HR@aqMsgs" value="4"/>
                                                                                                                                                <uix:option textBinding="LAST_7_DAYS@aqMsgs" value="5"/>
                                                                                                                                                <uix:option textBinding="MORE_THAN_7_DAYS@aqMsgs" value="6"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:messageChoice>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:cellFormat>
                                                                                                                            </uix:contents>
                                                                                                                        </uix:rowLayout>
                                                                                                                    </uix:contents>
                                                                                                                </uix:tableLayout>
                                                                                                            </uix:contents>
                                                                                                        </uix:cellFormat>
                                                                                                    </uix:contents>
                                                                                                </uix:rowLayout>
                                                                                            </uix:contents>
                                                                                        </uix:tableLayout>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                            </uix:contents>
                                                                        </uix:rowLayout>
                                                                    </uix:contents>
                                                                </uix:tableLayout>
                                                                <uix:spacer height="10" width="10"/>
                                                                <uix:radioButton name="simpleCondition"
                                                                textBinding="ADVANCED@aqMsgs"
                                                                disabledBinding="purgeAll@purgeConditionBean@servletRequest"
                                                                shortDescBinding="ADVANCED@aqMsgs"
                                                                value="false"
                                                                selectedValueBinding="simpleConditionString@purgeConditionBean@servletRequest"/>
                                                                <uix:spacer height="10" width="10"/>
                                                                <uix:tableLayout>
                                                                    <uix:contents>
                                                                        <uix:rowLayout>
                                                                            <uix:contents>
                                                                                <uix:cellFormat>
                                                                                    <uix:contents>
                                                                                        <uix:spacer height="10" width="30"/>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                                <uix:cellFormat>
                                                                                    <uix:contents>
                                                                                        <uix:messageTextInput disabledBinding="purgeAll@purgeConditionBean@servletRequest" shortDescBinding="ADVANCED_CONDITION_TIP@aqMsgs" messageBinding="ADVANCED_CONDITION_TIP@aqMsgs" name="advPurgeCondition" textBinding="advPurgeCondition@purgeConditionBean@servletRequest" rows="10" columns="50"/>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                            </uix:contents>
                                                                        </uix:rowLayout>
                                                                    </uix:contents>
                                                                </uix:tableLayout>
                                                            </uix:stackLayout>
                                                    
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>
                                        </uix:contents>
                                    </uix:tableLayout>
                                </uix:stackLayout>
                                </uix:contents>
                            </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                        </uix:contents>
                    </uix:tableLayout>
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showPurgeSql"/>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="purge"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:pageStatus>
                        <uix:formattedText textBinding="PURGE_INSTR@aqMsgs" styleClass="OraInstructionText"/>
                    </uix:pageStatus>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>

