<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext" >
    <uix:bundle name="strmMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg" />
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg" />
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
        <!-- Set the page title -->
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <db:form name="remStrmStatus" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type, otype,objectType,sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/purgeMessageStatus" />
            <uix:pageLayout messageType="info">
          <% if (request.getAttribute("em2goApp") != null) {%>
                <%@ include file="/em2go/em2goGlobal.jspf" %>
                    <% } else {%>
                <%@ include file="/database/globalPopup.jspf" %>
                    <%} %>

                    <% if (request.getAttribute("em2goApp") != null) {%>
                <%@ include file="/em2go/em2goFooter.jspf" %>
                    <%}%>
                <!-- main contents -->
                <uix:contents>
                    <oem:messageBox messageType="info"
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <%-- <uix:messageStyledText styleClass="OraDataText" textBinding="PurgeSuccessMsg@servletRequest"/> --%>

                  <uix:stackLayout>
                    <uix:rowLayout>
                      <% if (request.getAttribute("em2goApp") == null) {%>
                         <uix:spacer width="40"/>
                      <%} %>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="PurgeSuccessMsg@servletRequest"/>
                    </uix:rowLayout>
                  </uix:stackLayout>
                    
                    <uix:spacer height="10" width="10" />
                    <uix:tableLayout width="62%"  >
                        <uix:contents>
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat>
                                        <uix:contents>
                                            <uix:labeledFieldLayout>
                                                <uix:contents>
                                                    <uix:link textBinding="EXEC_ID@servletRequest" destinationBinding="jobStatusDest@servletRequest"/>
                                                </uix:contents>
                                            </uix:labeledFieldLayout>
                                        </uix:contents>
                                    </uix:cellFormat>
                                </uix:contents>
                            </uix:rowLayout>
                        </uix:contents>
                    </uix:tableLayout>
                </uix:contents>
                <uix:pageButtons>
                    <uix:pageButtonBar>
                        <uix:contents>
                            <uix:button shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" destinationBinding="backURL@servletRequest" />
                        </uix:contents>
                    </uix:pageButtonBar>
                </uix:pageButtons>
    
                 
            </uix:pageLayout>
        </db:form>
    </uix:document>
</uix:renderingContext>



