<%-- Name:        lobStorageInclude.jsp 
  -- Type:        JSP Include 
  -- Description: This page contains the UI for lob segments for a
  --              schema object. Lob Storage is handled via a button
  --              that should lead to the standard storage include.
  --
  -- EMO Beans:  You provide the name of your instance of the 
  --             LobSegment bean.  Your instance of the LobSegment will also
  --             serve as the bean for the Lob Storage Page.
  --         
  --             Messages are  expected to be in: uixDBObjectBundle@servlet request
  --             which should point to an instance of the DBObjectMsg bundle.
  --
  --             Errors are expected to be in: errors@servletRequest
  -- 
  -- JSP Changes: To use this page, add the following to your jsp file:
  --
  --  <uix:dataScope currentDataBinding="<your lob bean>@servletRequest">
  --    <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
  --    <uix:ref refID="lobStorageInclude" />
  --  </uix:dataScope>
  --
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of the bean can be whatever you need.
  --             Make sure your controller calls beanUtils with your bean
  --             when submit form is called.
  --
  -- Initializer Changes:
  --             You must create a SegmentInitializer that extents from 
  --             LobSegmentInitializer - see Table for an example.
  --
  -- Getting Storage To Initialize on CREATE:
  --             Currently you must override LobSegment.java and then 
  --             override the getInitializer function to save your own 
  --             initializer.
  --             See TableLob.java for an example.
  --             To make the page initialize everytime a tablespace changes,
  --             you must set the objects initialized variable to false
  --             whenever the tablespace changes.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.adm.schema.utilities.UtilConst" %>
<%@ page import="oracle.sysman.emo.constants.Units" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="lobStorageInclude">
<uix:dataScope>

<%-- Message Bundles Used --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>


  <%-- START: LOB ATTRIBUTES --%>
  <uix:header textBinding="LOB_ATTRIBUTES@dbMsgs">
  <uix:labeledFieldLayout columns="1">

    <%-- Segment Name --%>
    <uix:messageTextInput name="segmentName"
                    promptBinding="SEGMENT@dbMsgs"
                    shortDescBinding="SEGMENT@dbMsgs"
                    textBinding="segmentName@" 
                    disabledBinding="lobNameDisabled@" />

    <%-- Number of blocks accessed at one time (CHUNK) --%>
    <uix:messagePrompt promptBinding="NUM_OF_BLOCKS_ACC@dbMsgs" labeledNodeId="LOB_CHUNK_ID" />
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:messageTextInput name="chunk"
                    id="LOB_CHUNK_ID"
                    shortDescBinding="NUM_OF_BLOCKS_ACC@dbMsgs"
                    textBinding="chunk@" 
                    disabledBinding="lobDisabled@"
                    columns="10"/>
      <uix:messageChoice name="chunkUnit" 
                    id="LOB_CHUNK_ID"
                    shortDescBinding="NUM_OF_BLOCKS_ACC@dbMsgs"
                    selectedValueBinding="chunkUnit@"
                    disabledBinding="lobDisabled@" >
         <uix:option textBinding="BYTES@dbMsgs"
                    value="<%= Units.BYTES %>" />
         <uix:option textBinding="KBYTES@dbMsgs"
                    value="<%= Units.KBYTES %>" />
         <uix:option textBinding="MBYTES@dbMsgs"
                    value="<%= Units.MBYTES %>" />
      </uix:messageChoice>
    </uix:rowLayout>
    </uix:tableLayout>

    <%-- Space used for new version(pctVersion)--%>
    <uix:messageTextInput name="pctVersion"
                    promptBinding="PCTVERSION@dbMsgs"
                    shortDescBinding="PCTVERSION@dbMsgs"
                    textBinding="pctVersion@" 
                    disabledBinding="allDisabled@"
                    columns="10" />

    <%-- Cache--%>
    <uix:messageChoice name="cache" 
                    promptBinding="CACHE@dbMsgs"
                    onChange="submitForm('lobStorageInclude', true, {'event':'changeType'})"
                    shortDescBinding="CACHE@dbMsgs"
                    selectedValueBinding="cache@"
                    disabledBinding="allDisabled@" >
      <uix:option text="<%= UtilConst.S_CACHE %>"
                    value="<%= UtilConst.CACHE_ON %>" />
      <uix:option text="<%= UtilConst.S_NO_CACHE %>"
                    value="<%= UtilConst.CACHE_OFF %>" />
      <uix:option text="<%= UtilConst.S_CACHE_READS %>"
                    value="<%= UtilConst.CACHE_READS %>" />
    </uix:messageChoice>

    <%-- Enable storage in Row --%>
    <uix:messageCheckBox name="storageInRow"
                    textBinding="ENABLE_STORAGE_IN_ROW@dbMsgs"
                    shortDescBinding="ENABLE_STORAGE_IN_ROW@dbMsgs"
                    checkedBinding="storageInRow@" 
                    disabledBinding="lobDisabled@"/>

    </uix:labeledFieldLayout>
    </uix:header>
    <%-- END: LOB ATTRIBUTES --%>

    <%-- START: LOB STORAGE ATTRIBUTES --%>
    <uix:header textBinding="LOB_STORAGE_ATTRIBUTES@dbMsgs">
      <jsp:include page="storageInclude.jsp" />
      <uix:ref refID="storageInclude" />
    </uix:header>
    <%-- END: LOB STORAGE ATTRIBUTES --%>           

</uix:dataScope>
</uix:buildTree>

