<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.SubscriberMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/>   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="qTableForm" method="post" destination="/console/database/dist/streams/queueTable" copyParams="target,type,objectType,otype,oname,sname">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/qtable/qTableGeneral"/>   
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/> 
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        <uix:subTabLayout>
                            <uix:subTabs>
                                <jsp:include page="subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                            </uix:subTabs>
                            <uix:contents>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="75%" hAlign="center">
                                    <uix:contents>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right" width="30%">
                                                    <uix:contents>
                                                        <uix:messagePrompt promptBinding="NAME@dbMsgs" required="yes" labeledNodeId="QTableName"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageTextInput name="QTableName" columns="50" id="QTableName" 
                                                        shortDescBinding="NAME@dbMsgs" textBinding="QTableName@qTableMainBean@servletRequest"
                                                        disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="schemaName" required="yes" styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageLovField shortDescBinding="SCHEMA@dbMsgs" 
														id="schemaName" name="schemaName" 
														searchDescBinding="SCHEMA@dbMsgs"
														onClick="startLov('schemaName','ListSchema')" disabledBinding="editing@qTableMainBean@servletRequest" textBinding="schemaName@qTableMainBean@servletRequest" columns="50"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:styledText textBinding="TABLESPACE@dbMsgs" labeledNodeId="tablespace" styleClass="OraInstructionText"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageLovField id="tablespace" shortDescBinding="TABLESPACE@dbMsgs" 
														searchDescBinding="TABLESPACE@dbMsgs"
														name="tablespace" onClick="startLov('tablespace','ListTablespaceAll')" 
														disabledBinding="editing@qTableMainBean@servletRequest" 
														textBinding="tablespace@qTableMainBean@servletRequest" 
														columns="50"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="description" textBinding="DESCRIPTION@dbMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageTextInput id="description" shortDescBinding="DESCRIPTION@dbMsgs" name="description" textBinding="description@qTableMainBean@servletRequest" columns="50"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right" vAlign="top">
                                                    <uix:contents>
                                                        <uix:styledText textBinding="QUEUE_FEATURE_COMPAT@qTableMsgs" styleClass="OraInstructionText"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:stackLayout>
                                                            <uix:contents>
                                                                <uix:radioButton name="compatible"
                                                                renderedBinding="versionEqualOrHigher102@qTableMainBean@servletRequest"
                                                                textBinding="COMPAT_10@qTableMsgs"
                                                                shortDescBinding="COMPAT_10@qTableMsgs"
                                                                value="10.0" 
                                                                selectedValueBinding="compatible@qTableMainBean@servletRequest"/>
                                                                <uix:radioButton name="compatible" 
                                                                textBinding="COMPAT_8i@qTableMsgs"
                                                                shortDescBinding="COMPAT_8i@qTableMsgs"
                                                                value="8.1" 
                                                                renderedBinding="versionEqualOrHigher81@qTableMainBean@servletRequest"
                                                                selectedValueBinding="compatible@qTableMainBean@servletRequest"/>
                                                                <uix:radioButton name="compatible" 
                                                                textBinding="COMPAT_80@qTableMsgs" 
                                                                shortDescBinding="COMPAT_80@qTableMsgs"
                                                                value="8.0" 
                                                                selectedValueBinding="compatible@qTableMainBean@servletRequest"/>
                                                            </uix:contents>
                                                        </uix:stackLayout>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat width="50%" vAlign="top">
                                                    <uix:contents>
                                                        <uix:header textBinding="PAYLOAD_TYPE@qTableMsgs">
                                                            <uix:contents>
                                                                <uix:stackLayout>
                                                                    <uix:contents>
                                                                        <uix:radioButton name="payloadType"
                                                                        textBinding="VARIANT@qTableMsgs"
                                                                        shortDescBinding="VARIANT@qTableMsgs"
                                                                        value="2"
                                                                        selectedValueBinding="payloadTypeString@qTableMainBean@servletRequest"
                                                                        renderedBinding="editing@qTableMainBean@servletRequest"
                                                                        disabledBinding="editing@qTableMainBean@servletRequest"/>							    
                                                                        <uix:radioButton name="payloadType"
                                                                        textBinding="RAW@qTableMsgs"
                                                                        shortDescBinding="RAW@qTableMsgs"
                                                                        value="0"
                                                                        selectedValueBinding="payloadTypeString@qTableMainBean@servletRequest"
                                                                        disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                                        <uix:radioButton name="payloadType"
                                                                        textBinding="OBJECT@qTableMsgs"
                                                                        shortDescBinding="OBJECT@qTableMsgs"
                                                                        value="1"
                                                                        selectedValueBinding="payloadTypeString@qTableMainBean@servletRequest"
                                                                        disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                                        <uix:tableLayout>
                                                                            <uix:contents>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="20"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:messageStyledText labeledNodeId="payloadObjectType" styleClass="OraInstructionText" textBinding="TYPE@qTableMsgs"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="3"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:messageLovField columns="20" 
                                                                                                onClick="startLov('payloadObjectType','ListCompleteObjType')"
                                                                                                disabled="false" name="payloadObjectType"
                                                                                                id="payloadObjectType"
                                                                                                textBinding="payloadObjectType@qTableMainBean@servletRequest"
                                                                                                shortDescBinding="TYPE@qTableMsgs"
																								searchDescBinding="TYPE@qTableMsgs"
                                                                                                disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                                            </uix:contents>
                                                                        </uix:tableLayout>
                                                                    </uix:contents>
                                                                </uix:stackLayout>
                                                            </uix:contents>
                                                        </uix:header>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat vAlign="top" width="50%">
                                                    <uix:contents>
                                                        <uix:header textBinding="OPTIONS@qTableMsgs">
                                                            <uix:contents>
                                                                <uix:tableLayout>
                                                                    <uix:contents>
                                                                        <uix:rowLayout width="100%">
                                                                            <uix:contents>
                                                                                <uix:messageCheckBox checkedBinding="messageGroup@qTableMainBean@servletRequest" 
                                                                                name="messageGroup" 
                                                                                textBinding="ALLOW_MSG_GROUPING@qTableMsgs"
                                                                                shortDescBinding="ALLOW_MSG_GROUPING@qTableMsgs"
                                                                                disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                                            </uix:contents>
                                                                        </uix:rowLayout>
                                                                        <uix:rowLayout>
                                                                            <uix:contents>
                                                                                <uix:messageCheckBox checkedBinding="allowSubs@qTableMainBean@servletRequest" 
                                                                                name="allowSubs" 
                                                                                textBinding="ALLOW_SUBS@qTableMsgs"
                                                                                shortDescBinding="ALLOW_SUBS@qTableMsgs"
                                                                                disabledBinding="editing@qTableMainBean@servletRequest"/>
                                                                            </uix:contents>
                                                                        </uix:rowLayout>
                                                                    </uix:contents>
                                                                </uix:tableLayout>
                                                            </uix:contents>
                                                        </uix:header>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                                <uix:header textBinding="SORT_LIST@qTableMsgs">
                                    <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="SORT_LIST_INSTR@qTableMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:tableLayout width="50%">
                                            <uix:contents>
                                                <uix:rowLayout>
                                                    <uix:contents>
                                                        <uix:cellFormat>
                                                            <uix:contents>
                                                                <uix:stackLayout>
                                                                    <uix:contents>
                                                                        <uix:radioButton disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="ENQ_TIME@qTableMsgs" textBinding="ENQ_TIME@qTableMsgs" value="0" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/>
                                                                        <uix:radioButton disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="PRIORITY@qTableMsgs" textBinding="PRIORITY@qTableMsgs" value="1" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/>
                                                                        <uix:radioButton renderedBinding="versionEqualOrHigher102@qTableMainBean@servletRequest" disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="COMMIT_TIME@qTableMsgs" textBinding="COMMIT_TIME@qTableMsgs" value="2" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/> 
                                                                    </uix:contents>
                                                                </uix:stackLayout>
                                                            </uix:contents>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat>
                                                            <uix:contents>
                                                                <uix:stackLayout>
                                                                    <uix:contents>
                                                                        <uix:radioButton disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="PRIO_ENQ_TIME@qTableMsgs" textBinding="PRIO_ENQ_TIME@qTableMsgs" value="3" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/>
                                                                        <uix:radioButton renderedBinding="versionEqualOrHigher102@qTableMainBean@servletRequest" disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="PRIO_COMMIT_TIME@qTableMsgs" textBinding="PRIO_COMMIT_TIME@qTableMsgs" value="4" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/> 
                                                                        <uix:radioButton disabledBinding="editing@qTableMainBean@servletRequest" name="sortOption" shortDescBinding="ENQ_TIME_PRIO@qTableMsgs" textBinding="ENQ_TIME_PRIO@qTableMsgs" value="5" selectedValueBinding="sortOptionString@qTableMainBean@servletRequest"/>
                                                                    </uix:contents>
                                                                </uix:stackLayout>
                                                            </uix:contents>
                                                        </uix:cellFormat>
                                                    </uix:contents>
                                                </uix:rowLayout>
                                            </uix:contents>
                                        </uix:tableLayout>
                                    </uix:contents>
                                </uix:header>
                                <uix:spacer height="15" width="10"/>
                            </uix:contents>
                        </uix:subTabLayout>
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@qTableMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                
                                <uix:switcher defaultCase="false" childNameBinding="editing@qTableMainBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
