<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueTableMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/>   
  
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="qTableForm" method="post" destination="/console/database/dist/streams/queueTable" copyParams="target,type,objectType,otype, sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/qtable/qTableLOB"/>
             <%-- Hack as this page by itself does not need cancelURL.This is for the lobStorageGeneral page --%>
                 <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        <uix:stackLayout> 
                            <uix:spacer height="10"/>
                            <uix:switcher childNameBinding="lobChoice@payloadLobs@servletRequest">
                                <uix:case name="0"> 
                                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="DEFAULT_LOB_INSTR@qTableMsgs" />
                                </uix:case>
                            </uix:switcher>
                            <uix:dataScope currentDataBinding="lobSegment@servletRequest">
                               <%-- <jsp:include page="/database/dist/streams/queue/qtable/lobStorageInclude.jsp" /> --%>
                               <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
                                <uix:ref refID="lobStorageInclude" />
                            </uix:dataScope>
                        </uix:stackLayout>
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="redisplayLobStorage"/>
                                <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="applyLob"/>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
