<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueTableMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/>   
  
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="qTableForm" method="post" destination="/console/database/dist/streams/queueTable" copyParams="target,type,objectType,otype, sname, oname, cancelURL">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/qtable/qTableLOBGeneral"/>   
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        <uix:subTabLayout>
    
                            <%-- QTable SubTabs --%>
                            <uix:subTabs>
                                <jsp:include page="/database/dist/streams/queue/qtable/subTabsInclude.jsp" />
                                <uix:ref refID="subTabsInclude" />
                            </uix:subTabs>
                        
                            <uix:spacer height="20" width="10"/>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="LOB_INSTR@qTableMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            
                                           
                            <uix:tableLayout width="50%">
                                <uix:contents>
                                    <uix:rowLayout width="100%" hAlign="right">
                                        <uix:contents>
                                            <uix:submitButton  disabledBinding="defaultLobNotShown@payloadLobs@servletRequest" shortDescBinding="SET_DEF_LOB@qTableMsgs" textBinding="SET_DEF_LOB@qTableMsgs" name="event" value="setDefaultLob"/>
                                        </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            
                                            <uix:cellFormat>
                                                <uix:contents>
                                                <uix:dataScope currentDataBinding="lobListUI@payloadLobs@servletRequest">
                                                    <uix:table name="lobList" 
                                                    alternateTextBinding="NO_LOBS_FOUND@qTableMsgs"
                                                    formSubmitted="true"
                                                    width="100%"
                                                    tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                    minValue="1"
                                                    valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                    blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                    maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                    summaryBinding="LOB_ATTR_SUMMARY@qTableMsgs">
               
                                                    <uix:tableFormat tableBanding="rowBanding"/>
                                                    <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:sortableHeader textBinding="LOB_ATTR_NAME@qTableMsgs" sortable="no"/>
                                                    </uix:columnHeader> 
                                                    <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                                    <uix:text textBinding="<%= QueueTableMsgID.LOB_ATTR_NAME %>" />
                                                    </uix:column>

                                                    <uix:tableSelection>
                                                        <uix:singleSelection shortDescBinding="SELECT_LOB@qTableMsgs" selectedIndexBinding="selectedIndex">
                                                            <uix:contents>
                                                                <uix:submitButton shortDescBinding="LOB_ATTRS@qTableMsgs" textBinding="LOB_ATTRS@qTableMsgs" name="event" value="setSpecificLob"/>
                  
                                                            </uix:contents>
                                                        </uix:singleSelection>
                                                    </uix:tableSelection>		
                                                    </uix:table>
                                                </uix:dataScope>
                                                </uix:contents>
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>
                                </uix:contents>
                            </uix:tableLayout>
                           <uix:spacer height="20" width="10"/>              
                                     
                        </uix:subTabLayout>
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@payloadLobs@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                <uix:switcher defaultCase="false" childNameBinding="editing@payloadLobs@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                                
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
