<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.SubscriberMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/>   
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="qTableForm" method="post" destination="/console/database/dist/streams/queueTable" copyParams="target,type,objectType,otype,oname,sname,cancelURL">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/qtable/qTableStorage"/>   
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                    <uix:subTabLayout>
    
                        <%-- QTable SubTabs --%>
                        <uix:subTabs>
                            <jsp:include page="/database/dist/streams/queue/qtable/subTabsInclude.jsp" />
                            <uix:ref refID="subTabsInclude" />
                        </uix:subTabs>


                        <%-- START: TABLE STORAGE PAGE starts here --%>
                        <uix:dataScope currentDataBinding="qTableSegment@servletRequest">
                            <%-- <jsp:include page="/database/dist/streams/queue/qtable/storageInclude.jsp" /> --%>
                            <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
                            <uix:ref refID="storageInclude" />
                        </uix:dataScope>
                        <%-- END: TABLE STORAGE PAGE ends here --%>
                    </uix:subTabLayout>
                    
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:switcher defaultCase="false" childNameBinding="editing@qTableSegment@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                    </uix:case>
                                </uix:switcher>
                                <uix:switcher defaultCase="false" childNameBinding="editing@qTableSegment@servletRequest">
                                    <uix:case name="true">
                                        <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:pageButtonBar>  
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
