<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueTableMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:bundle name="qTableMsgs" class="oracle.sysman.db.rsc.streams.QueueTableMsg"/>   
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>    
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="queueTableList" method="post" destination="/console/database/dist/streams/queueTable" copyParams="target,type,otype,objectType">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/qtable/queueTableList"/>    
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:header textBinding="SEARCH@dbMsgs">
                            <uix:contents>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="45%" cellSpacing="5">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="schemaSearchName" styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageLovField shortDescBinding="SCHEMA@dbMsgs" 
														searchDescBinding="SCHEMA@dbMsgs"
														id="schemaSearchName" name="schemaSearchName" onClick="startLov('schemaSearchName','ListSchema')" 
                                                        textBinding="schemaSearchName@qTableList@servletRequest"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="queueTableSearchName" styleClass="OraInstructionText" textBinding="QTABLENAME@qTableMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageTextInput shortDescBinding="QTABLENAME@qTableMsgs" id="queueTableSearchName" name="queueTableSearchName" textBinding="queueTableSearchName@qTableList@servletRequest"/>
                                                    </uix:contents>
                                                </uix:cellFormat> 
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat/>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left" width="75%">
                                                    <uix:contents>
                                                        <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator/>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout hAlign="right">
                                            <uix:contents>
                                                <uix:submitButton  shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:dataScope currentDataBinding="qTableList@servletRequest">
                                            <uix:table name="qTableList" 
                                            alternateTextBinding="tableAlterText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                            minValue="1"
                                            valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                            blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                            maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                            summaryBinding="QTABLE_LIST_SUMMARY@qTableMsgs"
											shortDescBinding="QTABLE_LIST_SUMMARY@qTableMsgs">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="QTABLENAME@qTableMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:link destinationBinding="editURL" textBinding="<%= QueueTableMsgID.QTABLENAME %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="SCHEMA@qTableMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:text textBinding="<%= QueueTableMsgID.SCHEMA %>"/>
                                            </uix:column>
            
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="NUM_QUEUES@qTableMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="numberFormat" width="5%"/>
                                            <uix:text textBinding="<%= QueueTableMsgID.NUM_QUEUES %>"/>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="TYPE@qTableMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:text textBinding="<%= QueueTableMsgID.TYPE %>"/>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="COMPATIBLE@qTableMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                            <uix:text textBinding="<%= QueueTableMsgID.COMPATIBLE %>"/>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="USER_COMMENT@qTableMsgs"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                            <uix:text textBinding="<%= QueueTableMsgID.USER_COMMENT %>"/>
                                            </uix:column>
                                            <uix:tableSelection>
                                                <uix:singleSelection shortDescBinding="QTABLE_SELECT@qTableMsgs" selectedIndex="0">
                                                    <uix:contents>
                                                        <uix:submitButton shortDescBinding="DISPLAY_MESSAGES@aqMsgs" textBinding="DISPLAY_MESSAGES@aqMsgs" name="event" value="displayMessages"/>
                                                        <uix:submitButton shortDescBinding="EDIT@dbMsgs" textBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                        <uix:submitButton shortDescBinding="DELETE@dbMsgs" textBinding="DELETE@dbMsgs" name="event" value="delete"/>                          
                                                    </uix:contents>
                                                </uix:singleSelection>
                                            </uix:tableSelection>		
                                            </uix:table>
                                        </uix:dataScope>
                                    </uix:contents>
                                </uix:tableLayout>
               
                            </uix:contents>
                        </uix:header>
                        
                        <uix:header textBinding="RELATED_LINKS@streamsMsgs">
                            <uix:bulletedList>
                                <uix:link shortDescBinding="STREAMS_ADMINISTRATION@streamsMsgs" textBinding="STREAMS_ADMINISTRATION@streamsMsgs" destinationBinding="AdministrationURL@servletRequest"/>
                                <uix:link renderedBinding="IsTransRendered@servletRequest" shortDescBinding="MANAGE_TRANSFORMATIONS@streamsMsgs" textBinding="MANAGE_TRANSFORMATIONS@streamsMsgs" destinationBinding="TransformationsURL@servletRequest"/>
                            </uix:bulletedList>
                            <uix:spacer height="10" width="10"/>
                        </uix:header>
                        
                    </uix:contents>
             
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>

