<%--
  -- Page:       subTabsInclude.jsp
  -- Controller: db/adm/dist/streams/QueueTableController.java
  -- 
  -- Description: This handles all of the qtable subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="subTabsInclude">

<%-- Define Msg Bundles --%>
<uix:dataScope>

<uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="GENERAL@dbMsgs"
           shortDescBinding="GENERAL@dbMsgs"
           onClick="submitForm('qTableForm', true, {event:'subTabGeneral'})"
           copyParams="target,type,sname,oname,otype,objectType" />

  <%-- Storage Tab --%>
  
      <db:link textBinding="STORAGE@dbMsgs"
               shortDescBinding="STORAGE@dbMsgs"
               onClick="submitForm('qTableForm', true, {event:'subTabStorage'})" 
               copyParams="target,type,sname,oname,otype,objectType" />
               
  <%-- LOB Tab --%>
  
      <db:link textBinding="LOB_STORAGE@qTableMsgs"
               shortDescBinding="LOB_STORAGE@qTableMsgs"
               onClick="submitForm('qTableForm', true, {event:'subTabLOB'})" 
               copyParams="target,type,sname,oname,otype,objectType" />
 

</uix:subTabBar>
</uix:dataScope>
</uix:buildTree>

