<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
        <uix:rawText>
			<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
		</uix:rawText>
    </uix:case>
  </uix:switcher>

 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="queueMessageStatsForm" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType,sname, oname, isBufferQueue, QTYPE">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/queueMessageStats"/>
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
 <uix:pageLayout titleBinding="header@servletRequest">
<%@ include file="/database/global.jspf" %>
 <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- main contents -->
                      <uix:contents>
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:tableLayout width="100%">
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat columnSpan="2" hAlign="right" width="100%">
                                              <uix:contents>
                                                <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESH@aqMsgs"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:submitButton textBinding="REFRESH@dbMsgs" shortDescBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout hAlign="right">
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer height="30" width="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          
                                            <uix:cellFormat hAlign="right">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <%-- <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@dbMsgs"/> --%>
                                                    
                                                      <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" shortDescBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                          onChange="submitForm('queueMessageStatsForm', true, {'event':'refreshStatistics'})"
                                                           selectedValueBinding="refreshHomeSelected@servletRequest">
                                                        <uix:option textBinding="MANUAL_REFRESH@aqMsgs"
                                                          value="RT_MAN"/>
                                                        <uix:option textBinding="AUTOMATIC_REFRESH@aqMsgs"
                                                          value="RT_60"/> 
                                                      </uix:messageChoice>                                                    
                                                    
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:subTabLayout>
                          <uix:contents>
                            <uix:spacer height="10" width="10"/>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="SHOW_QUEUE_STATISTICS_INTRO@aqMsgs"/>
                            <uix:spacer height="15" width="10"/>
                            <uix:tableLayout hAlign="center" width="75%">
                              <uix:contents>
                                <uix:rowLayout hAlign="center" width="100%">
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right" width="50%">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="MESSAGES_IN_STATE_WAITING@aqMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" width="1%"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraDataText" textBinding="numOfMessagesWaiting@queueMessageStatsBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="MESSAGES_IN_STATE_READY@aqMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" width="1%"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraDataText" textBinding="numOfMessagesReady@queueMessageStatsBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="MESSAGES_IN_STATE_EXPIRED@aqMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" width="1%"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraDataText" textBinding="numOfMessagesExpired@queueMessageStatsBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="TOTAL_WAIT_TIME@aqMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" width="1%"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraDataText" textBinding="totalWaitTime@queueMessageStatsBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat hAlign="right">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="AVERAGE_WAIT_TIME@aqMsgs"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat hAlign="left" width="1%"/>
                                    <uix:cellFormat hAlign="left">
                                      <uix:contents>
                                        <uix:messageStyledText styleClass="OraDataText" textBinding="averageWaitTime@queueMessageStatsBean@servletRequest"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                            <uix:spacer height="10" width="10"/>
                          </uix:contents>
                          <uix:subTabs>
                            <uix:subTabBar selectedIndex="1">
                              <uix:contents>
                                <uix:link renderedBinding="propStatsTabRendered@queueMessageStatsBean@servletRequest" textBinding="QUEUE_PROPAGATION_STATS@aqMsgs" destinationBinding="propagationStatsPageURL@queueMessageStatsBean@servletRequest"/>
                                <uix:link textBinding="QUEUE_MESSAGE_STATS@aqMsgs"/>
                                <uix:link renderedBinding="bufferQueue@queueMessageStatsBean@servletRequest" textBinding="BUFFERED_QUEUE_STATS@aqMsgs" destinationBinding="bufferQueueStatsPageURL@queueMessageStatsBean@servletRequest"/>
                              </uix:contents>
                            </uix:subTabBar>
                          </uix:subTabs>
                        </uix:subTabLayout>
                      </uix:contents>
                      
                    </uix:pageLayout>
                    </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
